/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.extensionpoint.metadata.OutlineRootNode;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.project.virtual.VirtualBusinessIndicatorsContainer;
import oracle.bpm.project.virtual.VirtualDataObjectsContainer;
import oracle.bpm.project.virtual.VirtualProjectDataObjectsContainer;
import org.jetbrains.annotations.NotNull;

@OutlineRootNode(objectClass=Project.class)
public class ProjectStructureTreeNode
extends ProjectObjectTreeNode<Project> {
    public ProjectStructureTreeNode(Project element) {
        super((ProjectObject)element);
    }

    @Override
    protected void onLoading() {
        this.setFilter(new ProjectStructureNavigator());
        super.onLoading();
    }

    private class ProjectStructureNavigator
    implements ProjectFilter {
        private VirtualBusinessIndicatorsContainer businessIndicatorsContainer;
        private VirtualDataObjectsContainer projectDataObjectsContainer;

        private ProjectStructureNavigator() {
        }

        @NotNull
        public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer projectObjectContainer) {
            ArrayList<ProjectObject> children = new ArrayList<ProjectObject>();
            if (projectObjectContainer instanceof Project) {
                Project project = (Project)projectObjectContainer;
                children.add(this.getProjectDataObjectsNodeContainer((ProjectObjectContainer)project, (NodeContainer)project.getProjectModel()));
                children.add(this.getBusinessIndicatorsNodeContainer((ProjectObjectContainer)project, (NodeContainer)project.getProjectModel()));
                return CollectionUtils.asSequence(children);
            }
            return projectObjectContainer.getChildren();
        }

        public ProjectObjectContainer getParent(ProjectObject projectObject) {
            ProjectDataObject projectDataObject;
            Object result = projectObject instanceof ProjectDataObject ? ((projectDataObject = (ProjectDataObject)projectObject).isBusiness() ? this.businessIndicatorsContainer : this.projectDataObjectsContainer) : (ProjectObjectContainer)projectObject.getParentObject();
            return result;
        }

        private ProjectObject getProjectDataObjectsNodeContainer(ProjectObjectContainer parent, NodeContainer realParent) {
            if (this.projectDataObjectsContainer == null) {
                this.projectDataObjectsContainer = new VirtualProjectDataObjectsContainer(parent, realParent);
            }
            return this.projectDataObjectsContainer;
        }

        private ProjectObject getBusinessIndicatorsNodeContainer(ProjectObjectContainer parent, NodeContainer realParent) {
            if (this.businessIndicatorsContainer == null) {
                this.businessIndicatorsContainer = new VirtualBusinessIndicatorsContainer(parent, realParent);
            }
            return this.businessIndicatorsContainer;
        }
    }
}

