/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import oracle.bpm.designer.DesignerMode;
import oracle.bpm.designer.measurementmark.keyPerformanceIndicatorPropertiesPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.designer.preferences.HighlightLevel;
import oracle.bpm.draw.Color;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.lang.exception.ReadOnlyException;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.fs.FileProjectWriter;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectGenerateEvents;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.ProjectRunnable;
import oracle.bpm.project.model.Transactable;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.RoutingMode;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.LanguageChooser;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.TitlePanel;
import oracle.bpm.ui.TreePanel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiManager;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.ValidationException;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.TreeSelectionEvent;
import oracle.bpm.ui.event.TreeSelectionListener;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.IdentifierUpperCaseTextField;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.utils.Layout;

public class ProjectPreferencesDialog
extends OkCancelDialog {
    private final Project project;
    private final TreePanel treePanel;

    public ProjectPreferencesDialog(UiWindow parent, Project project) {
        super(parent, DesignerMsg.PROJECT_PREFERENCES_TITLE(project.getName()), true);
        this.project = project;
        this.treePanel = this.createTreePanel(this.getContentPane());
        this.getContentPane().add((UiComponent)this.treePanel, (Object)"Center");
        this.setSize(600, 600);
        this.setLocationRelativeTo((UiComponent)parent);
    }

    public void ok() {
        try {
            this.treePanel.getSelectedSheet().validate();
            FileProjectWriter projectWriter = (FileProjectWriter)this.getProject().getWriter();
            ProjectPreferences projectPreferences = this.getProject().getPreferences();
            Transactable tx = (Transactable)projectPreferences;
            tx.run(new ProjectRunnable(){

                public void run() {
                    ProjectPreferencesDialog.this.applyChanges();
                }
            });
            projectWriter.write(new ProjectObject[]{projectPreferences});
            this.setUserAccepted(true);
            this.close();
        }
        catch (ReadOnlyException e) {
            MessageDialog.showError((Msg)e.getMsg());
            try {
                List objects = this.project.getLoader().getAllObjects(ProjectPreferences.class);
                if (!objects.isEmpty()) {
                    this.getProject().addProjectPreferences((ProjectPreferences)objects.get(0));
                }
            }
            catch (ProjectException pe) {
                Log.logTrace(pe);
            }
        }
        catch (ValidationException e) {
            MessageDialog.showError((Msg)e.getKey());
        }
        catch (Throwable t) {
            t.printStackTrace();
            MessageDialog.showError((Throwable)t);
        }
    }

    public String getHelpId() {
        String sheet = this.treePanel.getSelectedSheet().getName().getCode();
        return ProjectPreferencesDialog.getHelpIdFromObjectClass((Object)((Object)this)) + "." + sheet;
    }

    protected boolean isDirty() {
        for (TreePanel.Sheet sheet : this.treePanel.getSheetList()) {
            BasePropertiesSheet bSheet;
            if (!(sheet instanceof BasePropertiesSheet) || !(bSheet = (BasePropertiesSheet)sheet).isDirty()) continue;
            return true;
        }
        return false;
    }

    Project getProject() {
        return this.project;
    }

    private TreePanel createTreePanel(UiContainer parent) {
        TreePanel panel = new TreePanel(parent);
        TreePanel.Sheet root = panel.getRoot();
        Project theProject = this.getProject();
        ProjectPreferences projectPreferences = theProject.getPreferences();
        root.addSheet((TreePanel.Sheet)new GeneralPropertiesSheet(root, projectPreferences));
        root.addSheet((TreePanel.Sheet)new ProcessAnalyticsSummarySheet(root, projectPreferences));
        root.addSheet((TreePanel.Sheet)new ProcessesPropertiesSheet(root));
        root.addSheet((TreePanel.Sheet)new LanguagePropertiesSheet(root, projectPreferences));
        panel.getTree().getRoot().getFirstChild().select();
        panel.getTree().addTreeSelectionListener(this.getTreeSelectionListener());
        return panel;
    }

    private TreeSelectionListener getTreeSelectionListener() {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreePanel.Sheet previousSheet = (TreePanel.Sheet)e.getOldLeadPath().getLastPathComponent();
                try {
                    previousSheet.validate();
                }
                catch (ValidationException e1) {
                    MessageDialog.showError((Msg)e1.getKey());
                }
            }
        };
    }

    private void applyChanges() {
        for (TreePanel.Sheet sheet : this.treePanel.getSheetList()) {
            TreePanel.Sheet.Listener listener = sheet.getListener();
            if (listener == null) continue;
            listener.save();
        }
    }

    private class ProcessesPropertiesSheet
    extends BasePropertiesSheet<DesignerPreferences> {
        private CheckBox autoLayout;
        private ComboBox<ExpressionMode> expressionMode;
        private CheckBox grid;
        private ComboBox<HighlightLevel> highlighting;
        private CheckBox notes;
        private CheckBox optimize;
        private CheckBox properties;
        private ComboBox<RoutingMode> rountingModeCombo;

        public ProcessesPropertiesSheet(TreePanel.Sheet root) {
            super(root, DesignerMsg.PROCESSES, DesignerPreferences.getPreferences());
        }

        @Override
        public void disable() {
        }

        @Override
        public void enable() {
        }

        @Override
        protected UiComponent buildEditorPanel(UiContainer parent) {
            return this.createProcessPanel(parent);
        }

        @Override
        protected void load() {
        }

        @Override
        protected void save() {
            DesignerPreferences preferences = (DesignerPreferences)super.getPropertiesObject();
            preferences.showPropertiesAutomaticallyWhenAddingActivity(this.properties.isSelected());
            preferences.setShowGrid(this.grid.isSelected());
            preferences.setShowNotes(this.notes.isSelected());
            preferences.setAutoLayout(this.autoLayout.isSelected());
            preferences.setOptimizeLanesOnAutoLayout(this.optimize.isSelected());
            preferences.setTransitionDefaultRoutingMode((RoutingMode)this.rountingModeCombo.getSelectedItem());
            preferences.setHighlight((HighlightLevel)((Object)this.highlighting.getSelectedItem()));
            preferences.setExpressionMode((ExpressionMode)this.expressionMode.getSelectedItem());
            preferences.store();
        }

        private Panel createProcessPanel(UiContainer parent) {
            Panel processPanel = new Panel(parent);
            RelativeLayout relativeLayout = new RelativeLayout();
            processPanel.setLayout((oracle.bpm.ui.layout.Layout)relativeLayout);
            String activityPanelId = "activity";
            processPanel.add((UiComponent)this.createActivityPanel((UiContainer)processPanel), (Object)activityPanelId);
            Layout.fixToRoot((RelativeLayout)relativeLayout, (String)activityPanelId, (AttributeType)AttributeType.TOP, (int)2);
            Layout.fixToRoot((RelativeLayout)relativeLayout, (String)activityPanelId, (AttributeType)AttributeType.LEFT, (int)2);
            Layout.fixToRoot((RelativeLayout)relativeLayout, (String)activityPanelId, (AttributeType)AttributeType.RIGHT, (int)-2);
            return processPanel;
        }

        private Panel createActivityPanel(UiContainer parent) {
            String dClickPanelID;
            DesignerPreferences preferences = DesignerPreferences.getPreferences();
            Panel centerPanel = new Panel(parent, DesignerMsg.ACTIVITY);
            RelativeLayout layout = new RelativeLayout();
            centerPanel.setLayout((oracle.bpm.ui.layout.Layout)layout);
            Panel generalPanel = new Panel((UiContainer)centerPanel, DesignerMsg.GENERAL);
            generalPanel.setLayout((oracle.bpm.ui.layout.Layout)new BoxLayout((UiContainer)generalPanel, 1));
            this.properties = CheckBox.create((UiContainer)generalPanel, (Msg)DesignerMsg.SHOW_PROPS_WHEN_ADDING, (boolean)preferences.showPropertiesAutomaticallyWhenAddingActivity());
            this.grid = CheckBox.create((UiContainer)generalPanel, (Msg)DesignerMsg.SHOWGRID, (boolean)preferences.getShowGrid());
            this.notes = CheckBox.create((UiContainer)generalPanel, (Msg)DesignerMsg.SHOW_NOTES, (boolean)preferences.getShowNotes());
            generalPanel.add((UiComponent)this.properties);
            generalPanel.add((UiComponent)this.grid);
            generalPanel.add((UiComponent)this.notes);
            Panel layoutPanel = new Panel((UiContainer)centerPanel, DesignerMsg.AUTOMATIC_LAYOUT);
            layoutPanel.makeRecyclable();
            layoutPanel.setLayout((oracle.bpm.ui.layout.Layout)new BoxLayout((UiContainer)layoutPanel, 1));
            this.autoLayout = CheckBox.create((UiContainer)generalPanel, (Msg)DesignerMsg.AUTOLAYOUT_WHEN_ADDING, (boolean)preferences.isAutoLayout());
            this.optimize = CheckBox.create((UiContainer)layoutPanel, (Msg)DesignerMsg.PRUNE_INTERACTIVE, (boolean)preferences.isOptimizeLanesOnAutoLayout());
            Panel routingPanel = new Panel((UiContainer)layoutPanel);
            routingPanel.makeRecyclable();
            routingPanel.setLayout((oracle.bpm.ui.layout.Layout)new BoxLayout((UiContainer)layoutPanel, 0));
            this.rountingModeCombo = UiFactory.createComboBox((UiContainer)routingPanel, (Object[])RoutingMode.values());
            this.rountingModeCombo.setSelectedItem((Object)preferences.getTransitionDefaultRoutingMode());
            Label routingLabel = Label.create((UiContainer)routingPanel, (Msg)DesignerMsg.SEQUENCE_FLOW_STYLE);
            routingPanel.add((UiComponent)routingLabel);
            routingPanel.add(this.rountingModeCombo);
            layoutPanel.add((UiComponent)this.autoLayout);
            layoutPanel.add((UiComponent)this.optimize);
            layoutPanel.add((UiComponent)routingPanel);
            Panel highlightingPanel = new Panel((UiContainer)centerPanel, DesignerMsg.EMPTY_MSG(""));
            highlightingPanel.setLayout((oracle.bpm.ui.layout.Layout)new FlowLayout(3));
            Label highlightingLabel = Label.create((UiContainer)highlightingPanel, (Msg)DesignerMsg.HIGHLIGHTING_LEVEL);
            this.highlighting = UiFactory.createComboBox((UiContainer)highlightingPanel, (Object[])HighlightLevel.values());
            this.highlighting.setLabelProvider((LabelProvider)new LabelProvider<HighlightLevel>(){

                public Image getIcon(HighlightLevel element) {
                    return element.getIcon();
                }

                public String getText(HighlightLevel element) {
                    return element.getMsg().getString();
                }
            });
            this.highlighting.setSelectedItem((Object)preferences.getHighlight());
            highlightingPanel.add((UiComponent)highlightingLabel);
            highlightingPanel.add(this.highlighting);
            Panel expressionPanel = new Panel((UiContainer)centerPanel, DesignerMsg.EXPRESSION);
            expressionPanel.setLayout((oracle.bpm.ui.layout.Layout)new FlowLayout(3));
            Label expressionModeLabel = Label.create((UiContainer)expressionPanel, (Msg)DesignerMsg.DEFAULT_EXPRESSION_MODE_DATA_ASSOCIATION);
            this.expressionMode = UiFactory.createComboBox((UiContainer)expressionPanel);
            this.expressionMode.addItem((Object)ExpressionMode.SIMPLE);
            this.expressionMode.addItem((Object)ExpressionMode.XPATH);
            this.expressionMode.setLabelProvider((LabelProvider)new LabelProvider<ExpressionMode>(){

                public Image getIcon(ExpressionMode element) {
                    return Image.create((Msg)element.getMsg());
                }

                public String getText(ExpressionMode element) {
                    return element.getString();
                }
            });
            this.expressionMode.setSelectedItem((Object)preferences.getExpressionMode());
            expressionPanel.add((UiComponent)expressionModeLabel);
            expressionPanel.add(this.expressionMode);
            String generalPanelID = "generalPanel";
            String titleParent = dClickPanelID = "doubleClickPanel";
            if (!DesignerMode.isValid(2)) {
                titleParent = generalPanelID;
            }
            centerPanel.add((UiComponent)generalPanel, (Object)generalPanelID);
            String messagesPanelID = "layoutPanel";
            centerPanel.add((UiComponent)layoutPanel, (Object)messagesPanelID);
            centerPanel.add((UiComponent)layoutPanel, (Object)messagesPanelID);
            String highlightingPanelID = "titlePanel";
            centerPanel.add((UiComponent)highlightingPanel, (Object)highlightingPanelID);
            String expressionPanelID = "expressionPanel";
            centerPanel.add((UiComponent)expressionPanel, (Object)expressionPanelID);
            Layout.fixToRoot((RelativeLayout)layout, (String)generalPanelID, (AttributeType)AttributeType.TOP, (int)2);
            Layout.fixToRoot((RelativeLayout)layout, (String)generalPanelID, (AttributeType)AttributeType.LEFT, (int)2);
            Layout.fixToRoot((RelativeLayout)layout, (String)generalPanelID, (AttributeType)AttributeType.RIGHT, (int)-2);
            Layout.fixToComp((RelativeLayout)layout, (String)messagesPanelID, (AttributeType)AttributeType.TOP, (String)generalPanelID, (AttributeType)AttributeType.BOTTOM, (int)5);
            Layout.fixToComp((RelativeLayout)layout, (String)messagesPanelID, (AttributeType)AttributeType.LEFT, (String)generalPanelID);
            Layout.fixToComp((RelativeLayout)layout, (String)messagesPanelID, (AttributeType)AttributeType.RIGHT, (String)generalPanelID);
            Layout.fixToComp((RelativeLayout)layout, (String)dClickPanelID, (AttributeType)AttributeType.TOP, (String)messagesPanelID, (AttributeType)AttributeType.BOTTOM, (int)5);
            Layout.fixToComp((RelativeLayout)layout, (String)dClickPanelID, (AttributeType)AttributeType.LEFT, (String)messagesPanelID);
            Layout.fixToComp((RelativeLayout)layout, (String)dClickPanelID, (AttributeType)AttributeType.RIGHT, (String)messagesPanelID);
            Layout.fixToComp((RelativeLayout)layout, (String)highlightingPanelID, (AttributeType)AttributeType.TOP, (String)titleParent, (AttributeType)AttributeType.BOTTOM, (int)5);
            Layout.fixToComp((RelativeLayout)layout, (String)highlightingPanelID, (AttributeType)AttributeType.LEFT, (String)generalPanelID);
            Layout.fixToComp((RelativeLayout)layout, (String)highlightingPanelID, (AttributeType)AttributeType.RIGHT, (String)generalPanelID);
            Layout.fixToComp((RelativeLayout)layout, (String)expressionPanelID, (AttributeType)AttributeType.TOP, (String)highlightingPanelID, (AttributeType)AttributeType.BOTTOM, (int)5);
            Layout.fixToComp((RelativeLayout)layout, (String)expressionPanelID, (AttributeType)AttributeType.LEFT, (String)generalPanelID);
            Layout.fixToComp((RelativeLayout)layout, (String)expressionPanelID, (AttributeType)AttributeType.RIGHT, (String)generalPanelID);
            return centerPanel;
        }
    }

    private class ProcessAnalyticsSummarySheet
    extends BasePropertiesSheet<ProjectPreferences> {
        private RadioButton generateEvents;
        private RadioButton generateInteractiveEvents;
        private keyPerformanceIndicatorPropertiesPanel kpisPropertiesPanel;

        public ProcessAnalyticsSummarySheet(TreePanel.Sheet root, ProjectPreferences projectPreferences) {
            super(root, DesignerMsg.PROCESS_ANALYTICS_SUMMARY, projectPreferences);
        }

        @Override
        public void disable() {
        }

        @Override
        public void enable() {
        }

        @Override
        protected UiComponent buildEditorPanel(UiContainer parent) {
            Panel panel = new Panel(parent);
            MigLayout layout = new MigLayout("fill, gap 5, ins 5, wrap 1");
            panel.setLayout((oracle.bpm.ui.layout.Layout)layout);
            Panel projectEventsPanel = this.buildProjectEventsPanel(panel);
            this.kpisPropertiesPanel = new keyPerformanceIndicatorPropertiesPanel((UiContainer)panel, ProjectPreferencesDialog.this.getProject().getPreferences().getKeyPerformanceIndicatorsContainer());
            panel.add((UiComponent)projectEventsPanel, (Object)"grow 20");
            panel.add((UiComponent)this.kpisPropertiesPanel, (Object)"grow 80");
            return panel;
        }

        @Override
        protected void load() {
            this.generateEvents.addModificationListener(this.getDirtyModificationListener());
            this.generateInteractiveEvents.addModificationListener(this.getDirtyModificationListener());
            this.kpisPropertiesPanel.addModificationListener(this.getDirtyModificationListener());
        }

        @Override
        protected void save() {
            if (this.isDirty()) {
                ((ProjectPreferences)this.getPropertiesObject()).getKeyPerformanceIndicatorsContainer().setGenerateEvents(this.getGenerateEventsValue());
                this.kpisPropertiesPanel.applyChanges();
            }
        }

        private Panel buildProjectEventsPanel(Panel panel) {
            Panel radioPanel = new Panel((UiContainer)panel, DesignerMsg.PROJECT_EVENTS);
            radioPanel.setLayout((oracle.bpm.ui.layout.Layout)new BoxLayout((UiContainer)radioPanel));
            ButtonGroup group = new ButtonGroup();
            this.generateEvents = new RadioButton((UiContainer)radioPanel, ProjectGenerateEvents.GENERATE_ALL_EVENTS.getString());
            this.generateInteractiveEvents = new RadioButton((UiContainer)radioPanel, ProjectGenerateEvents.GENERATE_INTERACTIVE_EVENTS.getString());
            RadioButton noEvents = new RadioButton((UiContainer)radioPanel, ProjectGenerateEvents.DO_NOT_GENERATE_EVENTS.getMsg());
            radioPanel.add((UiComponent)this.generateInteractiveEvents);
            radioPanel.add((UiComponent)this.generateEvents);
            radioPanel.add((UiComponent)noEvents);
            group.add((AbstractButton)this.generateEvents);
            group.add((AbstractButton)this.generateInteractiveEvents);
            group.add((AbstractButton)noEvents);
            switch (((ProjectPreferences)this.getPropertiesObject()).getKeyPerformanceIndicatorsContainer().getGenerateEvents()) {
                case GENERATE_ALL_EVENTS: {
                    this.generateEvents.setSelected(true);
                    break;
                }
                case GENERATE_INTERACTIVE_EVENTS: {
                    this.generateInteractiveEvents.setSelected(true);
                    break;
                }
                case DO_NOT_GENERATE_EVENTS: {
                    noEvents.setSelected(true);
                }
            }
            return radioPanel;
        }

        private ModificationListener getDirtyModificationListener() {
            return new ModificationListener(){

                public void objectModified(ModificationEvent event) {
                    ProcessAnalyticsSummarySheet.this.setDirty(true);
                }
            };
        }

        private ProjectGenerateEvents getGenerateEventsValue() {
            if (this.generateEvents.isSelected()) {
                return ProjectGenerateEvents.GENERATE_ALL_EVENTS;
            }
            if (this.generateInteractiveEvents.isSelected()) {
                return ProjectGenerateEvents.GENERATE_INTERACTIVE_EVENTS;
            }
            return ProjectGenerateEvents.DO_NOT_GENERATE_EVENTS;
        }
    }

    private class GeneralPropertiesSheet
    extends BasePropertiesSheet<ProjectPreferences> {
        private TextField databaseGranteesText;
        private TextField templateViewIdText;

        public GeneralPropertiesSheet(TreePanel.Sheet parent, ProjectPreferences propertiesObject) {
            super(parent, DesignerMsg.GENERAL, propertiesObject);
        }

        @Override
        public void disable() {
        }

        @Override
        public void enable() {
        }

        public void validate() throws ValidationException {
            if (this.templateViewIdText.getText().getBytes(Charset.defaultCharset()).length > 10) {
                this.templateViewIdText.setText(((ProjectPreferences)this.getPropertiesObject()).getTemplateViewIdentifier());
                throw new ValidationException(DesignerMsg.VIEW_IDENTIFIER_EXCEEDED_BYTES(DesignerMsg.TEMPLATE_VIEW_IDENTIFIER.getString(), 10));
            }
            if (this.databaseGranteesText.getText().getBytes(Charset.defaultCharset()).length > 2000) {
                this.databaseGranteesText.setText(this.flattenDatabaseGrantees(((ProjectPreferences)this.getPropertiesObject()).getDatabaseGrantees()));
                throw new ValidationException(DesignerMsg.VIEW_IDENTIFIER_EXCEEDED_BYTES(DesignerMsg.DATABASE_GRANTEES.getString(), 2000));
            }
        }

        @Override
        protected UiComponent buildEditorPanel(UiContainer parent) {
            Panel panel = new Panel(parent);
            MigLayout layout = new MigLayout("fillx, gap 5, ins 5, wrap 2");
            panel.setLayout((oracle.bpm.ui.layout.Layout)layout);
            this.templateViewIdText = new IdentifierUpperCaseTextField((UiContainer)panel, 20);
            this.templateViewIdText.setEnabled(((ProjectPreferences)this.getPropertiesObject()).getProject().isTemplate());
            this.databaseGranteesText = new TextField((UiContainer)panel);
            this.databaseGranteesText.setEnabled(((ProjectPreferences)this.getPropertiesObject()).getProject().isTemplate());
            Label granteesValueHint = Label.createWithNoColon((UiContainer)panel, (Msg)DesignerMsg.ALLOWS_COMMA_SEPARATED_VALUES);
            granteesValueHint.getFont().scale(0.75f);
            granteesValueHint.setForeground(Color.DARK_GRAY);
            panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.TEMPLATE_VIEW_IDENTIFIER));
            panel.add((UiComponent)this.templateViewIdText, (Object)"growx");
            panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.DATABASE_GRANTEES));
            panel.add((UiComponent)this.databaseGranteesText, (Object)"growx");
            panel.add((UiComponent)granteesValueHint, (Object)"skip 1, growx");
            return panel;
        }

        @Override
        protected void load() {
            this.templateViewIdText.setText(((ProjectPreferences)this.getPropertiesObject()).getTemplateViewIdentifier());
            this.databaseGranteesText.setText(this.flattenDatabaseGrantees(((ProjectPreferences)this.getPropertiesObject()).getDatabaseGrantees()));
        }

        @Override
        protected void save() {
            ((ProjectPreferences)this.getPropertiesObject()).setTemplateViewIdentifier(this.templateViewIdText.getText());
            ((ProjectPreferences)this.getPropertiesObject()).setDatabaseGrantees(this.getDatabaseGrantees());
        }

        private String flattenDatabaseGrantees(List<String> databaseGrantees) {
            String flattenGrantees = "";
            for (String grantee : databaseGrantees) {
                if (flattenGrantees.isEmpty()) {
                    flattenGrantees = flattenGrantees.concat(grantee);
                    continue;
                }
                flattenGrantees = flattenGrantees.concat("," + grantee);
            }
            return flattenGrantees;
        }

        private List<String> getDatabaseGrantees() {
            String grantees = this.databaseGranteesText.getText();
            StringTokenizer tokenizer = new StringTokenizer(grantees, ",");
            ArrayList<String> separatedGrantees = new ArrayList<String>();
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String grantee = tokenizer.nextToken().trim();
                separatedGrantees.add(grantee);
                ++i;
            }
            return separatedGrantees;
        }
    }

    private static class LanguagePropertiesSheet
    extends BasePropertiesSheet<ProjectPreferences> {
        private ComboBox<Locale> comboBox;
        private LanguageChooser languageChooser;

        public LanguagePropertiesSheet(TreePanel.Sheet parent, ProjectPreferences projectPreferences) {
            super(parent, UIMsg.LANGUAGES, projectPreferences);
        }

        @Override
        public void disable() {
            this.comboBox.setEnabled(false);
            this.languageChooser.setEnabled(false);
        }

        @Override
        public void enable() {
            this.comboBox.setEnabled(true);
            this.languageChooser.setEnabled(true);
        }

        @Override
        protected UiComponent buildEditorPanel(UiContainer parent) {
            RelativeLayout layout = new RelativeLayout();
            Panel panel = new Panel(parent);
            panel.setLayout((oracle.bpm.ui.layout.Layout)layout);
            ArrayList availableLanguages = ((ProjectPreferences)this.getPropertiesObject()).getAvailableLanguages();
            Locale defaultLanguage = ((ProjectPreferences)this.getPropertiesObject()).getDefaultLanguage();
            availableLanguages = new ArrayList(availableLanguages);
            this.comboBox = UiFactory.createMutableComboBox((UiContainer)panel, availableLanguages);
            this.comboBox.setLabelProvider((LabelProvider)LanguageChooser.getDefaultLabelProvider());
            this.comboBox.setSelectedItem((Object)defaultLanguage);
            this.languageChooser = new LanguageChooser((UiContainer)panel, UIMsg.TO_MSG((String)""), availableLanguages){

                protected boolean preDeleteAction(List<Locale> locales) {
                    Locale defaultLocale = (Locale)LanguagePropertiesSheet.this.comboBox.getSelectedItem();
                    for (Locale locale : locales) {
                        if (!locale.equals(defaultLocale)) continue;
                        MessageDialog.showNotice((Msg)DesignerMsg.ERROR_DELETING_CURRENT_LANGUAGE(locale.getDisplayName(locale)));
                        return false;
                    }
                    return super.preDeleteAction(locales);
                }

                protected Locale[] getAvailableLocales() {
                    return ProjectPreferences.PROJECT_ALL_VALID_LOCATES;
                }
            };
            this.languageChooser.setAllowEmptyList(false);
            this.languageChooser.addLanguageChooserListener(new LanguageChooser.LanguageChooserListener(){

                public void added(Locale[] locales) {
                    for (Locale locale : locales) {
                        LanguagePropertiesSheet.this.comboBox.addItem((Object)locale);
                    }
                    LanguagePropertiesSheet.this.setDirty(true);
                }

                public void removed(Locale[] locales) {
                    for (Locale locale : locales) {
                        LanguagePropertiesSheet.this.comboBox.removeItem((Object)locale);
                    }
                    LanguagePropertiesSheet.this.setDirty(true);
                }
            });
            panel.add((UiComponent)new LabelMultiline((UiContainer)panel, DesignerMsg.PROJECT_LANGUAGES_HELP), (Object)"textArea");
            panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.DEFAULT_LANGUAGE), (Object)"label");
            panel.add(this.comboBox, (Object)"comboBox");
            panel.add((UiComponent)this.languageChooser, (Object)"languages");
            Layout.fixToRoot((RelativeLayout)layout, (String)"textArea", (AttributeType)AttributeType.TOP, (int)5);
            Layout.fixToRoot((RelativeLayout)layout, (String)"textArea", (AttributeType)AttributeType.LEFT, (int)5);
            Layout.fixToRoot((RelativeLayout)layout, (String)"textArea", (AttributeType)AttributeType.RIGHT, (int)-5);
            Layout.fixToRoot((RelativeLayout)layout, (String)"label", (AttributeType)AttributeType.LEFT, (int)5);
            Layout.fixToComp((RelativeLayout)layout, (String)"label", (AttributeType)AttributeType.VERTICAL_CENTER, (String)"comboBox");
            Layout.fixToComp((RelativeLayout)layout, (String)"comboBox", (AttributeType)AttributeType.LEFT, (String)"label", (AttributeType)AttributeType.RIGHT, (int)5);
            Layout.fixToComp((RelativeLayout)layout, (String)"comboBox", (AttributeType)AttributeType.TOP, (String)"textArea", (AttributeType)AttributeType.BOTTOM, (int)5);
            Layout.fixToRoot((RelativeLayout)layout, (String)"comboBox", (AttributeType)AttributeType.RIGHT, (int)-5);
            Layout.fixToComp((RelativeLayout)layout, (String)"languages", (AttributeType)AttributeType.TOP, (String)"comboBox", (AttributeType)AttributeType.BOTTOM, (int)5);
            Layout.fixToRoot((RelativeLayout)layout, (String)"languages", (AttributeType)AttributeType.LEFT, (int)5);
            Layout.fixToRoot((RelativeLayout)layout, (String)"languages", (AttributeType)AttributeType.RIGHT, (int)-5);
            Layout.fixToRoot((RelativeLayout)layout, (String)"languages", (AttributeType)AttributeType.BOTTOM, (int)-5);
            this.comboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    LanguagePropertiesSheet.this.setDirty(true);
                }
            });
            return panel;
        }

        @Override
        protected void load() {
            this.setDirty(false);
        }

        @Override
        protected void save() {
            if (this.isDirty()) {
                Locale[] locales = this.languageChooser.getLocales();
                ArrayList<Locale> list = new ArrayList<Locale>(locales.length);
                list.addAll(Arrays.asList(locales));
                ((ProjectPreferences)this.getPropertiesObject()).setAvailableLanguages(list);
                ((ProjectPreferences)this.getPropertiesObject()).setDefaultLanguage((Locale)this.comboBox.getSelectedItem());
            }
        }
    }

    private static abstract class BasePropertiesSheet<PO>
    extends TreePanel.Sheet {
        private boolean dirty = false;
        private PO propertiesObject;

        BasePropertiesSheet(TreePanel.Sheet parent, Msg msg, PO propertiesObject) {
            super(parent, msg, null);
            this.propertiesObject = propertiesObject;
            this.setListener(this.createListener());
            UiContainer container = parent.getParentProvider().createParent();
            UiComponent editor = this.buildEditorPanel(container);
            TitlePanel titlePanel = (TitlePanel)container;
            this.decorateTitlePanel(titlePanel);
            titlePanel.addContent(editor);
            this.setEditor(editor);
        }

        public abstract void disable();

        public abstract void enable();

        public PO getPropertiesObject() {
            return this.propertiesObject;
        }

        public void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        protected abstract UiComponent buildEditorPanel(UiContainer var1);

        protected abstract void load();

        protected abstract void save();

        protected void decorateTitlePanel(TitlePanel titlePanel) {
            TitlePanel.TopPanel topPanel = titlePanel.getTopPanel();
            topPanel.setBackground(Color.FUEGO_LIGHT_BLUE);
            topPanel.setForeground(Color.GRAY);
            topPanel.setFont(UiManager.font((String)"InternalFrame.titleFont"));
        }

        private TreePanel.Sheet.Listener createListener() {
            return new TreePanel.Sheet.Listener(){

                public void load() {
                    BasePropertiesSheet.this.load();
                }

                public void save() {
                    BasePropertiesSheet.this.save();
                }
            };
        }
    }
}

