/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.Comparator;
import java.util.List;
import oracle.bpm.collections.factory.CollectionFactory;
import oracle.bpm.collections.sets.IdentityHashSet;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.TreeModel;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.events.BatchProjectListenerAdapter;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectEventSet;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.tree.TreeNode;

public class ProjectObjectTreeModel
extends TreeModel<ProjectObjectTreeNode> {
    private ProjectListener<ProjectObject> projectListener;
    private ProjectListener<ProjectObject> projectListenerDelegate;

    public ProjectObjectTreeModel(ProjectObjectTreeNode rootNode) {
        super(rootNode);
        rootNode.getProject().addListener(this.getProjectListener());
    }

    public static List<ProjectObject> calculatePath(ProjectObject projectObject, ProjectFilter filter, TreeNode rootNode) {
        ProjectObjectContainer parent;
        if (projectObject == null) {
            return CollectionFactory.createList();
        }
        ProjectObjectContainer projectObjectContainer = parent = filter != null ? filter.getParent(projectObject) : (ProjectObjectContainer)projectObject.getParentObject();
        if (parent == null || projectObject == rootNode.getUserObject()) {
            return CollectionFactory.createListWith(projectObject);
        }
        List<ProjectObject> path = ProjectObjectTreeModel.calculatePath((ProjectObject)parent, filter, rootNode);
        path.add(projectObject);
        return path;
    }

    public ProjectFilter getProjectFilter() {
        return ((ProjectObjectTreeNode)((Object)this.getRootNode())).getFilter();
    }

    public void setProjectListenerDelegate(ProjectListener projectListener) {
        this.projectListenerDelegate = projectListener;
    }

    public void removeProjectListenerDelegate() {
        this.projectListenerDelegate = null;
    }

    public TreeNode findNode(ProjectObject projectObject) {
        List<ProjectObject> path = this.calculatePath(projectObject);
        Object currentNode = this.getRootNode();
        for (ProjectObject po : path) {
            if (currentNode == null) break;
            if (currentNode.getUserObject() == po) continue;
            currentNode = currentNode.findChildByUserObject((Object)po);
        }
        assert (currentNode == null || currentNode.getUserObject() == projectObject);
        return currentNode;
    }

    public List<ProjectObject> calculatePath(ProjectObject projectObject) {
        return ProjectObjectTreeModel.calculatePath(projectObject, this.getProjectFilter(), this.getRootNode());
    }

    public void dispose() {
        ((ProjectObjectTreeNode)((Object)this.getRootNode())).getProject().removeListener(this.getProjectListener());
    }

    void changeNode(ProjectObject projectObject) {
        TreeNode node = this.findNode(projectObject);
        node.nodeChanged();
    }

    void replaceProjectObject(ProjectObject oldProjectObject, ProjectObject newProjectObject) {
        TreeNode node = this.findNode(oldProjectObject);
        node.setUserObject((Object)newProjectObject);
        node.nodeChanged();
    }

    private ProjectListener getProjectListener() {
        if (this.projectListener == null) {
            this.projectListener = new BatchProjectListenerAdapter<ProjectObject>(ProjectObject.class){

                public void processPostEvents(final ProjectEventSet events) {
                    if (!UiUtilities.isEventDispatchThread()) {
                        UiUtilities.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                this.processPostEvents(events);
                            }
                        });
                        return;
                    }
                    IdentityHashSet<ProjectObject> changedObjects = new IdentityHashSet<ProjectObject>();
                    for (ProjectEvent event : events) {
                        TreeNode parentNode;
                        ProjectObjectContainer parentObject;
                        ProjectObject projectObject;
                        if (event.getType() == ProjectEvent.Type.CHANGE) {
                            changedObjects.add(event.getProjectObject());
                            continue;
                        }
                        if (event.getType() == ProjectEvent.Type.POST_ADD) {
                            projectObject = event.getProjectObject();
                            parentObject = ProjectObjectTreeModel.this.getProjectFilter().getParent(projectObject);
                            if (parentObject == null || (parentNode = ProjectObjectTreeModel.this.findNode((ProjectObject)parentObject)) == null || !parentNode.isLoaded() || parentNode.findChildByUserObject((Object)projectObject) != null) continue;
                            parentNode.addDynamic((Object)projectObject, (Comparator)ProjectObjectTreeNode.getComparator());
                            continue;
                        }
                        if (event.getType() != ProjectEvent.Type.POST_REMOVE) continue;
                        projectObject = event.getProjectObject();
                        parentObject = ProjectObjectTreeModel.this.getProjectFilter().getParent(projectObject);
                        if (parentObject == null || (parentNode = ProjectObjectTreeModel.this.findNode((ProjectObject)parentObject)) == null || !parentNode.isLoaded()) continue;
                        TreeNode childNode = ProjectObjectTreeModel.this.findNode(projectObject);
                        if (!parentNode.getChildren().contains(childNode)) continue;
                        parentNode.remove(childNode);
                    }
                    for (ProjectObject changedObject : changedObjects) {
                        TreeNode node = ProjectObjectTreeModel.this.findNode(changedObject);
                        if (node == null) continue;
                        node.nodeChanged();
                        if (!(changedObject instanceof ProcessContent)) continue;
                        ProcessContent process = (ProcessContent)changedObject;
                        TreeNode inputArgsNode = ProjectObjectTreeModel.this.findNode((ProjectObject)process.getInputArgumentsContainer());
                        TreeNode outputArgsNode = ProjectObjectTreeModel.this.findNode((ProjectObject)process.getOutputArgumentsContainer());
                        if (process.isCallableSubprocess()) {
                            if (inputArgsNode != null) continue;
                            node.addDynamic((Object)process.getInputArgumentsContainer());
                            node.addDynamic((Object)process.getOutputArgumentsContainer());
                            continue;
                        }
                        if (inputArgsNode == null) continue;
                        node.remove(inputArgsNode);
                        node.remove(outputArgsNode);
                    }
                    if (ProjectObjectTreeModel.this.projectListenerDelegate != null) {
                        ProjectObjectTreeModel.this.projectListenerDelegate.processPostEvents(events);
                    }
                }
            };
        }
        return this.projectListener;
    }
}

