/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.awt.Component;
import java.awt.Graphics;
import java.net.URL;
import javax.swing.Icon;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.designer.preferences.HighlightLevel;
import oracle.bpm.project.model.ErrorSource;
import oracle.bpm.ui.Image;
import org.jetbrains.annotations.NotNull;

public class ProjectObjectIcon {
    static final Image ERROR_IMAGE = Image.create((URL)DesignerMsg.SMALL_ERROR.getImageResource());
    static final Image WARNING_IMAGE = Image.create((URL)DesignerMsg.SMALL_WARNING.getImageResource());

    public static Image create(Object object, Image icon) {
        Image result = icon;
        HighlightLevel level = DesignerPreferences.getPreferences().getHighlight();
        if (object instanceof ErrorSource) {
            ErrorSource errorSource = (ErrorSource)object;
            if (errorSource.hasNestedErrors() && (level.isError() || level.isWarning())) {
                result = Image.create((Icon)new DecoratedIcon(icon, ERROR_IMAGE));
            } else if (errorSource.hasNestedWarnings() && level.isWarning()) {
                result = Image.create((Icon)new DecoratedIcon(icon, WARNING_IMAGE));
            }
        }
        return result;
    }

    static class DecoratedIcon
    implements Icon {
        private Image decorator;
        private Image image;

        DecoratedIcon(@NotNull Image image, Image decorator) {
            this.image = image;
            this.decorator = decorator;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int x, int y) {
            this.image.asSwingIcon().paintIcon(component, graphics, x, y);
            int decoratorWidth = this.decorator.getIconWidth();
            this.decorator.asSwingIcon().paintIcon(component, graphics, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.image.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.image.getIconHeight();
        }
    }
}

