/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.ProjectObjectEditor;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.text.TextArea;

public abstract class ProjectObjectEditorPanel<E extends ProjectObject>
extends Panel
implements ProjectObjectEditor<E> {
    private E projectObject;

    protected ProjectObjectEditorPanel(UiContainer parent, E projectObject) {
        super(parent);
        this.projectObject = projectObject;
    }

    protected ProjectObjectEditorPanel(UiContainer parent, Msg title, E projectObject) {
        super(parent, title);
        this.projectObject = projectObject;
    }

    @Override
    public E getProjectObject() {
        return this.projectObject;
    }

    protected FormLayout createStandardLayout() {
        String colSpecs = "5dlu, pref, 5dlu, pref, 5dlu, pref, fill:pref:grow, 5dlu";
        return new FormLayout(colSpecs);
    }

    protected void appendRow(FormLayout layout, UiComponent label, UiComponent component) {
        this.addRowSeparator(layout);
        layout.appendRow("pref");
        int row = layout.getRowCount();
        this.add(label, layout.createCellConstraints().xy(2, row));
        this.add(component, layout.createCellConstraints().xy(4, row));
    }

    protected void appendRow(FormLayout layout, UiComponent label, UiComponent component, UiComponent component1) {
        this.addRowSeparator(layout);
        layout.appendRow("pref");
        int row = layout.getRowCount();
        this.add(label, layout.createCellConstraints().xy(2, row));
        this.add(component, layout.createCellConstraints().xy(4, row));
        this.add(component1, layout.createCellConstraints().xy(6, row));
    }

    protected void appendRow(FormLayout layout, UiComponent label, TextArea component) {
        this.addRowSeparator(layout);
        layout.appendRow("pref");
        this.add(label, layout.createCellConstraints().xyw(2, layout.getRowCount(), 6));
        layout.appendRow("pref");
        this.add((UiComponent)component, layout.createCellConstraints().xyw(2, layout.getRowCount(), 6));
    }

    protected void appendRow(FormLayout layout, UiComponent component) {
        layout.appendRow("fill:pref");
        this.add(component, layout.createCellConstraints().xyw(2, layout.getRowCount(), 6));
    }

    protected void appendExpandedRow(FormLayout layout, UiComponent component) {
        this.appendExpandedRow(layout, component, null);
    }

    protected void addRowSeparator(FormLayout layout) {
        layout.appendRow("5dlu");
    }

    protected void appendExpandedRow(FormLayout layout, UiComponent component, String size) {
        String grow = size != null && size.length() > 0 ? ":grow(" + size + ")" : ":grow";
        layout.appendRow("fill:pref" + grow);
        this.add(component, layout.createCellConstraints().xywh(2, layout.getRowCount(), 6, 1));
    }
}

