/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.ProjectObjectEditorPanel;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.Transactable;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;

public abstract class ProjectObjectEditorDialog<E extends ProjectObject>
extends OkCancelDialog {
    private ProjectObjectEditorPanel<E> editor;

    public ProjectObjectEditorDialog(UiWindow parent, Msg title) {
        super(parent, title, true);
    }

    public abstract ProjectObjectEditorPanel<E> buildEditor(UiContainer var1, E var2);

    public abstract void save(E var1) throws ProjectException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ok() {
        this.setUserAccepted(true);
        try {
            this.editor.validateEditor();
            Transactable po = (Transactable)this.editor.getProjectObject();
            try {
                po.beginTransaction();
                ProjectObject projectObject = this.editor.editorToObject();
                this.save(projectObject);
            }
            finally {
                po.endTransaction();
            }
            this.close();
        }
        catch (ProjectException e) {
            Msg msg = e.getKey();
            if (msg != null) {
                MessageDialog.showError((UiContainer)this, (Msg)msg);
            }
            MessageDialog.showError((UiContainer)this, (Throwable)e);
        }
    }

    protected void init(E projectObject) {
        UiContainer parent = this.getContentPane();
        this.editor = this.buildEditor(parent, projectObject);
        this.editor.objectToEditor((ProjectObject)projectObject);
        parent.add(this.editor, (Object)"Center");
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }
}

