/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.navigator.ProjectNavigatorBuilder;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ReferenceControl;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextField;
import org.jetbrains.annotations.NotNull;

public class ProjectObjectBrowser<E extends ProjectObject>
extends Panel
implements ReferenceControl<E> {
    private Button browseButton;
    private Msg browserTitle;
    private ToolBar customActionsToolbar;
    private ProjectFilter filter;
    private LabelProvider<E> labelProvider;
    private ArrayList<ModificationListener> listeners = new ArrayList();
    private List<BaseAction> navigatorActions = new ArrayList<BaseAction>();
    private LabelProvider<ProjectObject> navigatorStatusLabelProvider;
    private Button resetButton;
    private ProjectObjectContainer root;
    private boolean showRoot = false;
    private TextField textField;
    private E value;

    public ProjectObjectBrowser(@NotNull UiContainer parent, @NotNull ProjectFilter filter, @NotNull ProjectObjectContainer root) {
        super(parent);
        this.filter = filter;
        this.root = root;
        this.init();
    }

    public void addCustomAction(@NotNull BaseAction action) {
        this.customActionsToolbar.add(action);
    }

    public void addModificationListener(@NotNull ModificationListener listener) {
        this.listeners.add(listener);
    }

    public void removeModificationListener(@NotNull ModificationListener listener) {
        this.listeners.remove(listener);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.customActionsToolbar.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
        this.resetButton.setEnabled(enabled);
    }

    public boolean showRoot() {
        return this.showRoot;
    }

    public void setShowRoot(boolean showRoot) {
        this.showRoot = showRoot;
    }

    public void setLabelProvider(LabelProvider<E> labelProvider) {
        this.labelProvider = labelProvider;
    }

    public void setNavigatorStatusLabelProvider(@NotNull LabelProvider<ProjectObject> navigatorStatusLabelProvider) {
        this.navigatorStatusLabelProvider = navigatorStatusLabelProvider;
    }

    public boolean isValidSelection() {
        return this.value == null || this.filter.getChildren(this.root).contains(this.value);
    }

    public void setValue(E newValue) {
        E oldValue = this.value;
        if (oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.value = newValue;
        this.textField.setText(newValue != null ? this.getText(newValue) : "");
        this.textField.setForeground(this.isValidSelection() ? VALID_COLOR : INVALID_COLOR);
        this.fireSelectionChanged(oldValue, newValue);
    }

    public E getValue() {
        return this.value;
    }

    public void addNavigatorAction(@NotNull BaseAction action) {
        this.navigatorActions.add(action);
    }

    public void removeNavigatorAction(@NotNull BaseAction action) {
        this.navigatorActions.remove(action);
    }

    public void setBrowserTitle(Msg browserTitle) {
        this.browserTitle = browserTitle;
    }

    public Msg getBrowserTitle() {
        return this.browserTitle;
    }

    private String getText(@NotNull E value) {
        return this.labelProvider != null ? this.labelProvider.getText(value) : value.getId();
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("ins 0, gap 0, fillx"));
        this.textField = this.createTextField((UiContainer)this);
        this.add((UiComponent)this.textField, "growx");
        this.customActionsToolbar = this.createToolbar((UiContainer)this);
        this.add((UiComponent)this.customActionsToolbar);
        this.browseButton = this.createBrowseButton((UiContainer)this);
        this.add((UiComponent)this.browseButton);
        this.resetButton = this.createResetButton((UiContainer)this);
        this.add((UiComponent)this.resetButton);
    }

    private TextField createTextField(@NotNull UiContainer container) {
        TextField result = new TextField(container);
        result.setEditable(false);
        return result;
    }

    private Button createResetButton(UiContainer container) {
        Button result = Button.createIconic((UiContainer)container, (Msg)UIMsg.CLEAR);
        result.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectObjectBrowser.this.setValue(null);
            }
        });
        return result;
    }

    private ToolBar createToolbar(UiContainer container) {
        return new ToolBar(container, ToolBar.Orientation.HORIZONTAL);
    }

    private Button createBrowseButton(UiContainer container) {
        Button result = Button.createBrowse((UiContainer)container);
        result.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectNavigatorBuilder builder = ProjectObjectBrowser.this.createProjectNavigatorBuilder();
                for (BaseAction action : ProjectObjectBrowser.this.navigatorActions) {
                    builder.addAction(action);
                }
                ProjectObject object = builder.selectSingle(ProjectObject.class);
                if (object != null) {
                    ProjectObjectBrowser.this.setValue(object);
                }
            }
        });
        return result;
    }

    private ProjectNavigatorBuilder createProjectNavigatorBuilder() {
        ProjectNavigatorBuilder result = new ProjectNavigatorBuilder((ProjectObject)this.root, this.browserTitle).filter(this.filter).setNavigatorStatusLabelProvider(this.navigatorStatusLabelProvider).initialSelection((ProjectObject)this.value);
        return this.showRoot ? result.showRoot() : result.hideRoot();
    }

    private void fireSelectionChanged(E oldValue, E newValue) {
        for (ModificationListener listener : this.listeners) {
            listener.objectModified(new ModificationEvent<ProjectObjectBrowser>(this, oldValue, newValue));
        }
    }
}

