/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.HashMap;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.Context;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.view.project.view.renderer.ProjectObjectRenderer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;

public class ProcessUsagesDialog
extends OkCancelDialog {
    private HashMap<Process, Sequence<CallActivity>> activities = new HashMap();
    private Tree usages;

    public ProcessUsagesDialog() {
        super(Ui.getRoot(), DesignerMsg.FIND_PROCESS_USAGES);
    }

    public void setActivities(HashMap<Process, Sequence<CallActivity>> activities) {
        this.activities = activities;
    }

    public void ok() {
        TreeNode selectedTreeNode = this.usages.getSelectedTreeNode();
        if (selectedTreeNode != null) {
            FlowNode fn;
            Process process;
            ProcessDomain selectedProcessDomain;
            Object object = selectedTreeNode.getUserObject();
            AbstractStudioWorkbench.getInstance().openEditorForObject(object);
            if (object instanceof FlowNode && (selectedProcessDomain = Context.getDomainFor(process = (fn = (FlowNode)object).getProcess())) != null) {
                selectedProcessDomain.getSelectionProvider().setSelection(selectedProcessDomain.getController((FlowElement)fn));
            }
            this.close();
        } else {
            MessageDialog.showError((Msg)DesignerMsg.ERROR_PROCESS_USAGES);
        }
    }

    public void init() {
        this.buildPanel();
        this.setVisible(true);
    }

    private void buildPanel() {
        Panel usagesPanel = new Panel(this.getContentPane());
        this.usages = new Tree((UiContainer)usagesPanel, this.createTree());
        this.usages.setRootVisible(false);
        this.usages.setShowsRootHandles(true);
        Label processUsages = Label.createWithNoColon((UiContainer)usagesPanel, (Msg)DesignerMsg.PROCESS_USAGES);
        usagesPanel.setLayout((Layout)new BorderLayout());
        usagesPanel.add((UiComponent)processUsages, (Object)"North");
        usagesPanel.add((UiComponent)this.usages, (Object)"Center");
        this.getContentPane().add((UiComponent)usagesPanel, (Object)"Center");
        this.setSize(Dimension.valueOf(400, 300));
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private TreeNode createTree() {
        TreeNode root = TreeNode.create();
        for (Process process : this.activities.keySet()) {
            TreeNode processNode = TreeNode.create((Object)process);
            processNode.setIcon(ProjectObjectRenderer.Default.getIcon((ProjectObject)process));
            Sequence<CallActivity> activitySequence = this.activities.get(process);
            for (CallActivity anActivitySequence : activitySequence) {
                TreeNode node = TreeNode.create((Object)anActivitySequence);
                node.setIcon(ProjectObjectRenderer.Default.getIcon((ProjectObject)anActivitySequence));
                processNode.add(node);
            }
            root.add(processNode);
        }
        return root;
    }
}

