/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.ProcessUsagesDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CloseableDialog;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.selection.Selection;
import org.jetbrains.annotations.Nullable;

public class ProcessUsagesAction
extends BaseAction {
    public ProcessUsagesAction() {
        super(DesignerMsg.FIND_PROCESS_USAGES, Process.class);
    }

    public void run() {
        Process process = (Process)this.getSelection().as(Process.class);
        Project project = process.getProject();
        ArrayList activities = new ArrayList();
        HashMap<Process, Sequence<CallActivity>> activitiesMap = new HashMap<Process, Sequence<CallActivity>>();
        for (Process caller : project.getProcesses()) {
            Sequence<CallActivity> callingCallActivities = this.getCallingCallActivities(caller, process);
            if (callingCallActivities.isEmpty()) continue;
            activitiesMap.put(caller, callingCallActivities);
        }
        if (activitiesMap.isEmpty()) {
            Panel usagesPanel = new Panel(null);
            Label noUsages = Label.createWithNoColon((UiContainer)usagesPanel, (Msg)DesignerMsg.NO_PROCESS_USAGES);
            noUsages.setHorizontalAlignment(0);
            usagesPanel.setLayout((Layout)new BorderLayout());
            usagesPanel.add((UiComponent)noUsages, (Object)"Center");
            CloseableDialog.showComponent((UiWindow)Ui.getRoot(), (UiComponent)usagesPanel, (Msg)DesignerMsg.FIND_PROCESS_USAGES, null, (Dimension)Dimension.valueOf(250, 150));
        } else {
            ProcessUsagesDialog dialog = new ProcessUsagesDialog();
            dialog.setActivities(activitiesMap);
            dialog.init();
        }
    }

    protected void updateEnableStatus(Selection s) {
        super.updateEnableStatus(s);
        Process p = (Process)s.as(Process.class);
        this.setEnabled(p.isCallableSubprocess());
    }

    private Sequence<CallActivity> getCallingCallActivities(Process caller, final Process process) {
        return caller.getDescendants(CallActivity.class).select(new Predicate<CallActivity>(){

            @Override
            public boolean check(@Nullable CallActivity activity) {
                return activity != null && activity.getCalledElement() == process;
            }
        });
    }
}

