/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.activitiespanels.FeatureEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.features.ProcessSealTypeFeature;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.ProcessSealType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;

public class ProcessSealTypePanel
extends FeatureEditor<ProcessSealTypeFeature> {
    private CheckBox activitySealed;
    private CheckBox flowSealed;

    protected ProcessSealTypePanel(UiContainer parent, ProcessSealTypeFeature feature) {
        super(parent, feature);
        this.algo();
    }

    @Override
    public void toFeature() {
        ((ProcessSealTypeFeature)this.getFeature()).setValue((Enum)this.getResolverFeatureValue());
    }

    @Override
    public void fromFeature() {
        ProcessSealType value = (ProcessSealType)((ProcessSealTypeFeature)this.getFeature()).getValue();
        this.flowSealed.setSelected(value.isFlowSealed());
        this.activitySealed.setSelected(value.isActivitySealed());
    }

    private void algo() {
        LabelMultiline descTextArea = this.createMsgArea((UiContainer)this, ProjectModelMsg.SEAL_TYPE_DESC);
        Panel checkboxes = this.createCheckboxes();
        UiUtilities.layoutCheckBoxPanel((Panel)this, (UiComponent)descTextArea, (UiComponent)checkboxes);
    }

    private Panel createCheckboxes() {
        Panel parent = new Panel((UiContainer)this);
        this.flowSealed = CheckBox.create((UiContainer)parent, (Msg)DesignerMsg.FLOW_SEALED);
        this.activitySealed = CheckBox.create((UiContainer)parent, (Msg)DesignerMsg.ACTIVITY_SEALED);
        UiUtilities.layoutCheckBoxPanel((Panel)parent, (UiComponent)this.flowSealed, (UiComponent)this.activitySealed);
        return parent;
    }

    private ProcessSealType getResolverFeatureValue() {
        ProcessSealType result = this.flowSealed.isSelected() && this.activitySealed.isSelected() ? ProcessSealType.SEALED : (this.flowSealed.isSelected() ? ProcessSealType.FLOW_SEALED : (this.activitySealed.isSelected() ? ProcessSealType.ACTIVITY_SEALED : ProcessSealType.REGULAR));
        return result;
    }
}

