/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableFactory;
import oracle.bpm.diagram.draw.DrawableRegister;
import oracle.bpm.draw.AntialiasingMode;
import oracle.bpm.draw.BpmnDrawableFactory;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableChildPopulator;
import oracle.bpm.draw.DrawableProcess;
import oracle.bpm.draw.DrawableSingleProcessRoot;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Insets;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.PaintCanvas;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessPreviewer
extends PaintCanvas {
    private DrawContext context;
    private DrawableSingleProcessRoot root;

    public ProcessPreviewer(@NotNull UiContainer parent) {
        super(parent);
        this.setupContext();
        this.root = DrawableSingleProcessRoot.create((PaintCanvas)this, (DiagramContext)this.getDrawContext());
    }

    public Dimension getPreferredSize() {
        return this.getVisibleRect().getSize();
    }

    public void paintCanvas(@NotNull Graphics graphics) {
        if (this.root.hasSingleProcess()) {
            graphics.setAntialiasing(AntialiasingMode.ON);
            this.updateContext(graphics, this.getVisibleRect());
            this.root.draw();
        }
    }

    @NotNull
    public DrawableProcess getDrawableProcess() {
        return this.root.getSingleProcess();
    }

    public void setRegister(@NotNull DrawableRegister register) {
        this.root.setRegister(register);
    }

    public void setProcessToRender(@Nullable Process process) {
        this.clearRoot();
        if (process != null) {
            this.addProcessToRoot(process);
        }
    }

    protected void setupContext() {
        DrawContext context = new DrawContext();
        context.setContainer((UiContainer)this);
        context.setRenderFlowOnly(false);
        context.setScale(1.0f);
        this.setDrawContext(context);
    }

    protected void setScaleForBounds(float width, float height) {
        Dimension bounds = this.getDrawableProcess().getBounds().getSize();
        float xRatio = width / (float)bounds.getWidth();
        float yRatio = height / (float)bounds.getHeight();
        this.getDrawContext().setScale(Math.min(xRatio, yRatio));
    }

    protected void updateContext(@NotNull Graphics graphics, @NotNull Rectangle rect) {
        DrawContext context = this.getDrawContext();
        context.setGraphics(graphics);
        context.setRectangle(rect);
    }

    protected void setDrawContext(@NotNull DrawContext context) {
        this.context = context;
    }

    protected DrawContext getDrawContext() {
        return this.context;
    }

    protected DrawableFactory resolveDrawableFactory() {
        return BpmnDrawableFactory.getInstance();
    }

    private void clearRoot() {
        for (Drawable child : this.root.getDrawables()) {
            child.remove();
        }
    }

    private void addProcessToRoot(@NotNull Process process) {
        DrawableFactory factory = this.resolveDrawableFactory();
        DrawableChildPopulator.populateChild((DrawableFactory)factory, (Drawable)this.root, (Object)process);
        this.root.getSingleProcess().setInsets(Insets.valueOf(0, 0, 100, 100));
    }
}

