/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import fuego.simulation.Simulation;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import oracle.bpm.designer.AbstractEditor;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.AutoLayoutPanel;
import oracle.bpm.designer.DesignPanel;
import oracle.bpm.designer.DesignerMode;
import oracle.bpm.designer.DesignerStateManager;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.ProcessCanvas;
import oracle.bpm.designer.ProcessDesignerListener;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.controller.ControllerUtils;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.errorview.ErrorView;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.designer.toolbar.HighlightTool;
import oracle.bpm.designer.toolbar.ScaleTool;
import oracle.bpm.designer.toolbar.UtilityToolBar;
import oracle.bpm.designer.utils.IconFactory;
import oracle.bpm.extensionpoint.metadata.Editor;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.observers.ObjectPropertyListener;
import oracle.bpm.print.Printable;
import oracle.bpm.project.compile.CheckOptions;
import oracle.bpm.project.compile.process.ProcessChecker;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Margin;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.ScrollPolicy;
import oracle.bpm.ui.SplitPane;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.FocusAdapter;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import org.jetbrains.annotations.NotNull;

@Editor(objectClass=Process.class)
public class ProcessPanel
extends AbstractEditor<Process>
implements ProcessDesignerListener {
    private DesignPanel designPanel;
    private ObjectPropertyListener lanesOrientationListener;
    private Panel splitContainer;
    private ObjectPropertyListener themeListener;
    private ToolBar toolbar;
    private boolean toolbarAdded = false;
    private UiContainer uiParent;

    public ProcessPanel(UiContainer parent, Process process) {
        super(parent, process, Process.class);
        this.uiParent = parent;
        this.setInsets(new Margin(0, 0, 0, 0));
        this.setPanelId(ModelUtils.getModelTitle((Process)process));
        DesignerPreferences designerPreferences = DesignerPreferences.getPreferences();
        this.themeListener = new ObjectPropertyListener(){

            @Override
            public void propertyChanged(Object object, String propertyName) {
                ProcessPanel.this.updateTheme();
            }
        };
        designerPreferences.addPropertyObserver("selectedDesignerTheme", this.themeListener);
        this.lanesOrientationListener = new ObjectPropertyListener(){

            @Override
            public void propertyChanged(Object object, String propertyName) {
                UiUtilities.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ProcessPanel.this.getProcessDomain().getCanvas().repaint();
                    }
                });
            }
        };
        this.getProject().getPreferences().addPropertyObserver("lanesOrientation", this.lanesOrientationListener);
    }

    @Override
    public boolean isPrintable() {
        return true;
    }

    @Override
    public String getPanelId() {
        return ModelUtils.getModelTitle((Process)this.getModel());
    }

    @Override
    public void disposeEditor() {
        if (this.getProject().isOpen()) {
            this.getProject().getPreferences().removePropertyObserver("lanesOrientation", this.lanesOrientationListener);
        }
        super.disposeEditor();
        this.getProcessDomain().onDispose();
        DesignerPreferences.getPreferences().removePropertyObserver("selectedDesignerTheme", this.themeListener);
    }

    @Override
    public void openPart(Object part) {
        if (part instanceof FlowElement) {
            FlowElement flowElement = (FlowElement)part;
            FlowElementController controller = this.getControllerFor(flowElement);
            this.scrollToCenter(controller);
        }
    }

    public Process getModel() {
        return (Process)this.getProjectObject();
    }

    public DesignerStateManager getStateManager() {
        return this.getDesignPanel().getStateManager();
    }

    public ProcessDomain getProcessDomain() {
        return this.getDesignPanel().getProcessDomain();
    }

    @Override
    public Printable getPrintable() {
        return this.getProcessDomain().getDomainPrintable();
    }

    @Override
    public EditorType getEditorType() {
        return EditorType.PROCESS;
    }

    @Override
    public Image getIcon() {
        return IconFactory.createProcessImageIcon(this.getModel().isReadOnly());
    }

    public String getName() {
        return this.getModel().getPath().toString();
    }

    public void dispose() {
        this.getProcessDomain().onDispose();
        super.dispose();
    }

    public Simulation getSimulation() {
        return null;
    }

    @Override
    public String getTitle() {
        return this.getPanelId();
    }

    public String getVisualName() {
        return this.getModel().getDefaultLabel();
    }

    public void paintSimulation() {
        this.getStateManager().repaint();
    }

    public void closeAllEditors() {
        DesignerStateManager controller = this.getStateManager();
        if (controller.isSimulating()) {
            this.getSimulation().setPerformingAnimation(false);
        }
        StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
        workbench.closeEditor(this);
    }

    @Override
    public void compile(ProjectMessageListener listener) {
        int checkAll = AbstractStudioWorkbench.getInstance().isBusinessAnalyst() ? 12803 : 242687;
        ProcessChecker checker = new ProcessChecker(this.getModel(), new CheckOptions(checkAll));
        try {
            checker.setListener(listener);
            checker.check();
        }
        catch (ProjectException e) {
            // empty catch block
        }
    }

    @Override
    public void setToolBar(ToolBar toolbar) {
        this.toolbar = toolbar;
    }

    @Override
    public ToolBar getToolBar() {
        return this.toolbar;
    }

    @Override
    protected void buildUI(UiContainer parent) {
        DesignerMode.setVisibility((UiComponent)parent, 65535);
        this.splitContainer = new Panel(parent);
        this.splitContainer.setLayout((Layout)new BorderLayout());
        parent.setLayout((Layout)new BorderLayout());
        this.buildMainPanels();
        parent.add((UiComponent)this.splitContainer, (Object)"Center");
        this.setReadOnly(((Process)this.getProjectObject()).isReadOnly());
        this.startModelCompiling();
    }

    @Override
    protected void onCompilationCompleted(Map<ProjectObject, List<ProjectException>> errors, Map<ProjectObject, List<ProjectException>> warnings) {
    }

    @Override
    protected void editorToObject() {
    }

    @Override
    protected void objectToEditor() {
        if (this.getProjectObject() != this.designPanel.getProcessDomain().getDomainElement()) {
            this.rebuild();
        }
    }

    @Override
    protected UiContainer createMainPanel() {
        return this;
    }

    private DesignPanel getDesignPanel() {
        return this.designPanel;
    }

    private void scrollToCenter(@NotNull FlowElementController controller) {
        ProcessDomain domain = this.getProcessDomain();
        Rectangle bounds = controller.getDrawableObject().getBounds();
        domain.getCanvas().scrollRectangleToCenter(bounds);
    }

    private FlowElementController getControllerFor(@NotNull FlowElement element) {
        ProcessCanvas canvas = this.getProcessDomain().getCanvas();
        NodeContainerController<?> container = ControllerUtils.getNodeContainerControllerFor(canvas.getProcessController(), element);
        return container.asController(element);
    }

    private void buildMainPanels() {
        if (Ui.isFusion()) {
            SplitPane splitPane = new SplitPane((UiContainer)this.splitContainer, 0);
            ScrollPane scrollPane = new ScrollPane((UiContainer)splitPane, ScrollPolicy.ALWAYS);
            Panel mainPanel = new Panel((UiContainer)scrollPane);
            mainPanel.setLayout((Layout)new BorderLayout());
            this.designPanel = new DesignPanel((UiContainer)mainPanel, (Process)this.getProjectObject());
            mainPanel.add((UiComponent)this.designPanel, (Object)"Center");
            this.splitContainer.add((UiComponent)splitPane, (Object)"Center");
            splitPane.setTopComponent((UiComponent)scrollPane);
            scrollPane.setView((UiComponent)mainPanel);
            if (this.toolbar != null) {
                UtilityToolBar.rebuildUtilityToolbar(this.toolbar, this.getStateManager());
                if (!this.toolbarAdded) {
                    this.toolbarAdded = true;
                    this.splitContainer.add((UiComponent)this.toolbar, (Object)"North");
                }
            }
            scrollPane.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    System.out.println("scroll.focusGained");
                }
            });
            mainPanel.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    System.out.println("main.focusGained");
                }
            });
            this.designPanel.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    System.out.println("design.focusGained");
                    ProcessPanel.this.onActivation();
                }
            });
            Panel southPanel = new Panel((UiContainer)splitPane);
            ErrorView view = new ErrorView(southPanel, this.designPanel);
            southPanel.setLayout((Layout)new BorderLayout());
            southPanel.add((UiComponent)view, (Object)"Center");
            Panel controls = new Panel((UiContainer)southPanel);
            controls.setLayout((Layout)new BorderLayout());
            JScrollBar h = ((JScrollPane)scrollPane.asSwing()).getHorizontalScrollBar();
            southPanel.asSwing().add((Component)h, "North");
            Panel optionsView = new Panel((UiContainer)controls);
            optionsView.setLayout((Layout)new MigLayout("gapx 4"));
            ScaleTool scaleTool = new ScaleTool(this.designPanel.getProcessDomain(), (UiContainer)controls, this.designPanel.getProcessDomain().getDomainElement());
            optionsView.add(scaleTool.getComponent(h.getHeight()), (Object)"West");
            AutoLayoutPanel layoutPanel = AutoLayoutPanel.create((UiContainer)controls, this.designPanel.getProcessDomain());
            optionsView.add((UiComponent)layoutPanel, (Object)"Center");
            final DesignerPreferences designerPreferences = DesignerPreferences.getPreferences();
            final CheckBox showGridCheckBox = new CheckBox((UiContainer)optionsView);
            showGridCheckBox.setSelected(designerPreferences.getShowGrid());
            showGridCheckBox.setText(DesignerMsg.SHOWGRID.toString());
            showGridCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    designerPreferences.setShowGrid(showGridCheckBox.isSelected());
                    designerPreferences.store();
                }
            });
            final ObjectPropertyListener gridListener = new ObjectPropertyListener(){

                @Override
                public void propertyChanged(Object object, String propertyName) {
                    showGridCheckBox.setSelected(designerPreferences.getShowGrid());
                }
            };
            this.addCloseListener(new AbstractEditor.CloseListener(){

                @Override
                public void editorClosed(AbstractEditor editor) {
                    designerPreferences.removePropertyObserver(DesignerMsg.SHOWGRID.getString(), gridListener);
                }
            });
            designerPreferences.addPropertyObserver(DesignerMsg.SHOWGRID.getString(), gridListener);
            optionsView.add((UiComponent)showGridCheckBox, (Object)"East");
            controls.add((UiComponent)optionsView, (Object)"East");
            Panel flowPanel = new Panel((UiContainer)controls);
            flowPanel.setLayout((Layout)new BorderLayout());
            UiComponent hintButton = view.getHintButton(flowPanel, h.getHeight(), splitPane);
            flowPanel.add(hintButton, (Object)"West");
            HighlightTool tool = new HighlightTool(this.designPanel.getProcessDomain());
            flowPanel.add(tool.getComponent((UiContainer)flowPanel), (Object)"East");
            controls.add((UiComponent)flowPanel, (Object)"West");
            southPanel.add((UiComponent)controls, (Object)"South");
            splitPane.setBottomComponent((UiComponent)southPanel);
            splitPane.setResizeWeight(0.7);
        }
    }

    private void updateTheme() {
        this.buildMainPanels();
        this.splitContainer.revalidate();
    }
}

