/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.ApplicationPanelBuilder;
import oracle.bpm.designer.DesignerException;
import oracle.bpm.designer.DesignerMode;
import oracle.bpm.designer.DesignerResources;
import oracle.bpm.designer.GenerateEventFeatureEditor;
import oracle.bpm.designer.NamespaceFeatureEditor;
import oracle.bpm.designer.ProcessNameIsNullException;
import oracle.bpm.designer.ProcessSealTypePanel;
import oracle.bpm.designer.argumentsdefinition.ArgumentsDefinitionPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.lang.Str;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.processmodel.SchemaType;
import oracle.bpm.project.ProcessArgumentContainer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.Transactable;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.NamespaceFeature;
import oracle.bpm.project.model.features.ProcessSealTypeFeature;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.MirrorTextArea;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RegexpTextField;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextComponent;
import oracle.bpm.ui.text.TextField;
import org.jetbrains.annotations.NotNull;

public class ProcessInfoPanel
extends Panel {
    private List<InnerPanelBuilder> builders = new ArrayList<InnerPanelBuilder>();
    private boolean isNew;
    private MainPanelBuilder mainPanelBuilder;
    private Process process;
    private TabbedPane tabbedPane;

    public ProcessInfoPanel(UiContainer parent, Process content, boolean isNew) {
        super(parent);
        this.process = content;
        this.isNew = isNew;
        this.setLayout((Layout)new BorderLayout());
        this.tabbedPane = new TabbedPane((UiContainer)this);
        this.tabbedPane.setOptions(253);
        this.add((UiComponent)this.tabbedPane, "Center");
        this.build();
        this.objectToPanel();
    }

    public static ProcessInfoPanel createForWizard(UiContainer parent, final Process process) {
        return new ProcessInfoPanel(parent, process, true){
            private AdvancedPanelBuilder advanced;

            @Override
            protected void build() {
                this.addArgumentsTab();
                this.advanced = this.addAdvancedTab();
            }

            @Override
            protected void objectToPanel() {
                super.objectToPanel();
                this.advanced.getNamespaceFeatureEditor().setNamespace(ProcessInfoPanel.getDefaultNamespace(process.getId()));
            }
        };
    }

    public String getHelpId() {
        return this.tabbedPane.getDefaultHelpId();
    }

    public boolean ok() {
        try {
            this.checkValues();
        }
        catch (DesignerException exc) {
            MessageDialog.showError((Msg)exc.getMsg());
            return false;
        }
        this.panelToObject();
        this.process.setDirty(true);
        return true;
    }

    protected void addGeneralTab() {
        Panel generalPanel = new Panel((UiContainer)this.tabbedPane);
        this.tabbedPane.addTab(DesignerMsg.GENERAL, (UiComponent)generalPanel);
        this.buildMainPanel(generalPanel);
    }

    protected AdvancedPanelBuilder addAdvancedTab() {
        Panel advancedPanel = new Panel((UiContainer)this.tabbedPane);
        this.tabbedPane.addTab(CoreMsg.ADVANCED, (UiComponent)advancedPanel);
        return this.buildAdvancedPanel(advancedPanel);
    }

    protected ApplicationPanelBuilder addApplicationTab() {
        Panel appPanel = new Panel((UiContainer)this.tabbedPane);
        this.tabbedPane.addTab(ProjectMsg.APPLICATION, (UiComponent)appPanel);
        return this.buildApplicationPanel(appPanel);
    }

    protected void addArgumentsTab() {
        if (this.mustShowArgs()) {
            Panel argumentPanel = new Panel((UiContainer)this.tabbedPane);
            this.buildArgumentsPanel((UiContainer)argumentPanel);
            this.tabbedPane.addTab(DesignerMsg.ARGUMENTS_DEFINITION, (UiComponent)argumentPanel);
        }
    }

    protected void build() {
        this.addGeneralTab();
        this.addAdvancedTab();
        this.addApplicationTab();
        this.addArgumentsTab();
    }

    protected void objectToPanel() {
        for (InnerPanelBuilder builder : this.builders) {
            builder.objectToPanel(this.process);
        }
    }

    Process getProcess() {
        return this.process;
    }

    private static String getDefaultNamespace(String name) {
        return "http://xmlns.oracle.com/bpmn/bpmnProcess/" + name;
    }

    private boolean mustShowArgs() {
        Sequence startEventSequence = this.process.getEvents(StartEvent.class, EventTriggerType.MESSAGE);
        return this.isNew && (!startEventSequence.isEmpty() || this.process.isCallableSubprocess());
    }

    private void buildArgumentsPanel(UiContainer parent) {
        ArgumentPanelBuilder argumentPanelBuilder = new ArgumentPanelBuilder(this.getProcess());
        this.builders.add(argumentPanelBuilder);
        argumentPanelBuilder.build(parent);
    }

    private AdvancedPanelBuilder buildAdvancedPanel(Panel parent) {
        final AdvancedPanelBuilder advancedPanelBuilder = new AdvancedPanelBuilder(this.getProcess(), this.isNew);
        advancedPanelBuilder.build(parent);
        this.builders.add(advancedPanelBuilder);
        if (this.mainPanelBuilder != null) {
            this.mainPanelBuilder.setNamespaceFeatureProvider(new NamespaceFeatureProvider(){

                @Override
                public NamespaceFeatureEditor get() {
                    return advancedPanelBuilder.getNamespaceFeatureEditor();
                }
            });
        }
        return advancedPanelBuilder;
    }

    private ApplicationPanelBuilder buildApplicationPanel(Panel panelToBuild) {
        ApplicationPanelBuilder builder = new ApplicationPanelBuilder(this.getProcess());
        builder.build(panelToBuild);
        this.builders.add(builder);
        return builder;
    }

    private void buildMainPanel(Panel parent) {
        this.mainPanelBuilder = new MainPanelBuilder(this.getProcess(), this.isNew);
        this.mainPanelBuilder.build(parent);
        this.builders.add(this.mainPanelBuilder);
    }

    private void checkValues() throws DesignerException {
        for (InnerPanelBuilder builder : this.builders) {
            builder.checkValues(this.process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void panelToObject() {
        try {
            ((Transactable)this.process).beginTransaction();
            for (InnerPanelBuilder builder : this.builders) {
                builder.panelToObject(this.process);
            }
        }
        finally {
            ((Transactable)this.process).endTransaction();
        }
    }

    private static class MainPanelBuilder
    extends InnerPanelBuilder {
        private RegexpTextField analyticsViewIdField;
        private TextField authorField;
        private TextArea descriptionArea;
        private Label idLabel;
        private boolean isNew;
        private TextField labelField;
        private NamespaceFeatureProvider namespaceFeatureProvider;
        private static final int ANALYTICS_VIEW_IDENTIFIER_LIMIT = 10;

        public MainPanelBuilder(Process process, boolean isNew) {
            super(process);
            this.isNew = isNew;
        }

        public void setNamespaceFeatureProvider(NamespaceFeatureProvider namespaceFeatureProvider) {
            this.namespaceFeatureProvider = namespaceFeatureProvider;
        }

        public void build(Panel panelToBuild) {
            Project project = this.getProcess().getProject();
            panelToBuild.setLayout((Layout)new MigLayout("gapx 5, ins 5"));
            this.idLabel = Label.createWithNoColon((UiContainer)panelToBuild, (Msg)Msg.QUOTE(""));
            this.idLabel.setFont(this.idLabel.getFont().italic());
            this.labelField = new TextField((UiContainer)panelToBuild, 30);
            this.descriptionArea = new MirrorTextArea((UiContainer)panelToBuild, (TextComponent)this.labelField);
            this.descriptionArea.setLineWrap(true);
            this.descriptionArea.setColumns(30);
            this.descriptionArea.setRows(3);
            this.descriptionArea.setWrapStyleWord(true);
            this.authorField = new TextField((UiContainer)panelToBuild, "");
            this.analyticsViewIdField = new RegexpTextField((UiContainer)panelToBuild, "[a-zA-Z0-9]{0,10}", false);
            panelToBuild.add((UiComponent)Label.create((UiContainer)panelToBuild, (Msg)CoreMsg.ID));
            panelToBuild.add((UiComponent)this.idLabel, (Object)"spanx 2, growx, wrap");
            panelToBuild.add((UiComponent)Label.create((UiContainer)panelToBuild, (Msg)CoreMsg.NAME));
            panelToBuild.add((UiComponent)this.labelField, (Object)"growx, pushx");
            panelToBuild.add((UiComponent)DesignerResources.buildLocalizationButton(project, (UiContainer)panelToBuild, this.getProcess().getLabelMap(), (TextComponent)this.labelField, DesignerMsg.LOCALIZE_LABEL.getString()), (Object)"wrap");
            panelToBuild.add((UiComponent)Label.create((UiContainer)panelToBuild, (Msg)DesignerMsg.DESCRIPTION));
            panelToBuild.add((UiComponent)this.descriptionArea, (Object)"growx");
            panelToBuild.add((UiComponent)DesignerResources.buildLocalizationButton(project, (UiContainer)panelToBuild, this.getProcess().getDescriptionMap(), (TextComponent)this.descriptionArea, DesignerMsg.LOCALIZE_LABEL.getString(), true), (Object)"aligny top, wrap");
            panelToBuild.add((UiComponent)Label.create((UiContainer)panelToBuild, (Msg)ProjectMsg.AUTHOR));
            panelToBuild.add((UiComponent)this.authorField, (Object)"spanx 2, growx, wrap");
            panelToBuild.add((UiComponent)Label.create((UiContainer)panelToBuild, (Msg)ProjectDrawMsg.ANALYTICS_VIEW_IDENTIFIER), (Object)"spanx 3, wrap");
            panelToBuild.add((UiComponent)this.analyticsViewIdField, (Object)"spanx 3, growx, wrap");
        }

        @Override
        public void panelToObject(Process model) {
            model.setId(this.idLabel.getText());
            model.setAuthor(this.authorField.getText());
            model.setAnalyticsViewIdentifier(this.analyticsViewIdField.getText());
            model.setDefaultLabel(this.labelField.getText());
            model.setDefaultDescription(this.descriptionArea.getText());
        }

        @Override
        public void objectToPanel(Process model) {
            String defaultLabel;
            this.analyticsViewIdField.setText(model.getAnalyticsViewIdentifier());
            if (this.descriptionArea != null) {
                this.descriptionArea.setText(model.getDefaultDescription());
            }
            if (this.isNew && (model.getAuthor() == null || "".equals(model.getAuthor()))) {
                this.authorField.setText(System.getProperty("user.name"));
            } else {
                this.authorField.setText(model.getAuthor());
            }
            if (this.isNew) {
                this.labelField.addDocumentListener(new DocumentListener(){

                    public void insertUpdate(DocumentEvent e) {
                        this.updateName();
                    }

                    public void removeUpdate(DocumentEvent e) {
                        this.updateName();
                    }

                    public void changedUpdate(DocumentEvent e) {
                        this.updateName();
                    }

                    private void updateName() {
                        MainPanelBuilder.this.idLabel.setText(MainPanelBuilder.this.cutName());
                        if (MainPanelBuilder.this.namespaceFeatureProvider != null) {
                            MainPanelBuilder.this.namespaceFeatureProvider.get().setNamespace(ProcessInfoPanel.getDefaultNamespace(MainPanelBuilder.this.idLabel.getText()));
                        }
                    }
                });
            }
            if ((defaultLabel = model.getDefaultLabel()) != null && !"".equals(defaultLabel)) {
                this.labelField.setText(defaultLabel);
                this.idLabel.setText(model.getId());
            } else {
                this.labelField.setText(ModelUtils.nextNameForModel((Project)model.getProject(), (String)SchemaType.PROCESS.getString()));
            }
        }

        @Override
        public void checkValues(Process model) throws DesignerException {
            if (this.idLabel.getText() == null || this.idLabel.getText().length() == 0 || Character.isDigit(this.idLabel.getText().charAt(0))) {
                throw new ProcessNameIsNullException(model);
            }
            if (this.labelField.getText() == null || this.labelField.getText().length() == 0) {
                throw new ProcessNameIsNullException(model);
            }
            if (this.analyticsViewIdField.getText().getBytes().length > 10) {
                throw new DesignerException((ProjectObject)model, DesignerMsg.VIEW_IDENTIFIER_EXCEEDED_BYTES(ProjectDrawMsg.ANALYTICS_VIEW_IDENTIFIER.getString(), 10));
            }
            if (!this.isUniqueAnaliticsViewIdentifier(this.analyticsViewIdField.getText())) {
                throw new DesignerException((ProjectObject)model, ProjectDrawMsg.NOT_UNIQUE_VIEW_IDENTIFIER((String)this.analyticsViewIdField.getText()));
            }
            Process process = model.getProject().findProcess(this.idLabel.getText());
            if (process != null && process != model) {
                throw new DesignerException(DesignerMsg.PROCESS_ID_EXISTS);
            }
        }

        private boolean isUniqueAnaliticsViewIdentifier(String viewIdentifier) {
            for (Process process : this.getProcess().getProject().getProcesses()) {
                if (process.equals(this.getProcess()) || Str.isEmpty(viewIdentifier) || !process.getAnalyticsViewIdentifier().toLowerCase().equals(viewIdentifier.toLowerCase())) continue;
                return false;
            }
            return true;
        }

        private String cutName() {
            return ModelUtils.validIdForProcess((Project)this.getProcess().getProject(), (String)this.labelField.getText());
        }
    }

    private static class ArgumentPanelBuilder
    extends InnerPanelBuilder {
        private ArgumentsDefinitionPanel argumentsDefinitionPanel;
        private DataDeclarationContainer inputDataDeclarationContainer;
        private DataDeclarationContainer outputDataDeclarationContainer;

        public ArgumentPanelBuilder(Process process) {
            super(process);
        }

        public Panel build(UiContainer parent) {
            Panel result = new Panel(parent);
            parent.setLayout((Layout)new BorderLayout());
            parent.add((UiComponent)result);
            result.setLayout((Layout)new MigLayout("ins 5, gap 5, fill"));
            if (this.getProcess().isCallableSubprocess()) {
                this.outputDataDeclarationContainer = this.getProcess().getInputArgumentsContainer();
                this.inputDataDeclarationContainer = this.getProcess().getOutputArgumentsContainer();
            } else {
                Sequence startEventSequence = this.getProcess().getEvents(StartEvent.class);
                StartEvent startEvent = (StartEvent)startEventSequence.iterator().next();
                Sequence endEventSequence = this.getProcess().getEvents(EndEvent.class);
                EndEvent endEvent = (EndEvent)endEventSequence.iterator().next();
                this.outputDataDeclarationContainer = startEvent.getOutputArgumentsContainer();
                this.inputDataDeclarationContainer = endEvent.getInputArgumentsContainer();
            }
            ProcessArgumentContainer inputsContainer = ProcessArgumentContainer.createFrom((DataDeclarationContainer)this.outputDataDeclarationContainer);
            ProcessArgumentContainer outputsContainer = ProcessArgumentContainer.createFrom((DataDeclarationContainer)this.inputDataDeclarationContainer);
            this.argumentsDefinitionPanel = new ArgumentsDefinitionPanel((UiContainer)result, (DataDeclarationContainer)inputsContainer, (DataDeclarationContainer)outputsContainer, false);
            result.add((UiComponent)this.argumentsDefinitionPanel, (Object)"grow");
            return result;
        }

        public void addAllArguments() {
            this.copyArguments(this.argumentsDefinitionPanel.getInputArgumentsContainer(), this.outputDataDeclarationContainer);
            this.copyArguments(this.argumentsDefinitionPanel.getOutputsArgumentsContainer(), this.inputDataDeclarationContainer);
        }

        @Override
        public void panelToObject(Process model) {
            this.addAllArguments();
        }

        @Override
        public void checkValues(Process model) throws DesignerException {
        }

        @Override
        public void objectToPanel(Process model) {
        }

        private void copyArguments(@NotNull DataDeclarationContainer source, @NotNull DataDeclarationContainer target) {
            try {
                target.clearDeclarations();
                for (DataDeclaration argument : source.getLocalDeclarations()) {
                    DataDeclaration inputArg = target.createDeclaration(argument.getName(), argument.getType());
                    target.addDeclaration(inputArg);
                }
            }
            catch (ProjectException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class AdvancedPanelBuilder
    extends InnerPanelBuilder {
        private GenerateEventFeatureEditor generateEventFeatureEditor;
        private boolean isNew;
        private NamespaceFeatureEditor namespaceFeatureEditor;
        private ProcessSealTypePanel sealEditor;
        private CheckBox suspendInstanceCheckBox;

        public AdvancedPanelBuilder(Process process, boolean isNew) {
            super(process);
            this.isNew = isNew;
        }

        public void build(Panel parent) {
            String cols = "5dlu, pref, 2dlu, pref:grow, pref, 5dlu";
            FormLayout layout = new FormLayout(cols);
            PanelBuilder builder = layout.createBuilder(parent);
            CellConstraints cc = layout.createCellConstraints();
            if (DesignerMode.isValid(2)) {
                this.generateEventFeatureEditor = new GenerateEventFeatureEditor((UiContainer)parent, this.getProcess());
                AdvancedPanelBuilder.addRow(builder, (UiComponent)this.generateEventFeatureEditor, cc);
            }
            this.suspendInstanceCheckBox = CheckBox.create((UiContainer)parent, (Msg)ProjectModelMsg.SUSPEND_INSTANCE_ON_DATA_ASSOCIATION_ERROR, (boolean)true);
            AdvancedPanelBuilder.addRow(builder, (UiComponent)this.suspendInstanceCheckBox, cc);
            this.namespaceFeatureEditor = new NamespaceFeatureEditor((UiContainer)parent, (NamespaceFeature)this.getProcess().getFeature(NamespaceFeature.class));
            AdvancedPanelBuilder.addRow(builder, (UiComponent)this.namespaceFeatureEditor, cc);
            this.namespaceFeatureEditor.setEnabled(this.isNew);
            if (this.getProcess().getProject().isTemplate()) {
                this.sealEditor = new ProcessSealTypePanel((UiContainer)parent, (ProcessSealTypeFeature)this.getProcess().getFeature(ProcessSealTypeFeature.class));
                AdvancedPanelBuilder.addRow(builder, (UiComponent)this.sealEditor, cc);
            }
        }

        @Override
        public void checkValues(Process model) throws DesignerException {
            if (this.namespaceFeatureEditor != null) {
                try {
                    this.namespaceFeatureEditor.checkValues();
                }
                catch (URISyntaxException e) {
                    throw new DesignerException(DesignerMsg.INVALID_NAMESPACE);
                }
            }
        }

        @Override
        public void objectToPanel(Process model) {
            if (this.generateEventFeatureEditor != null) {
                this.generateEventFeatureEditor.populateValues();
            }
            this.suspendInstanceCheckBox.setSelected(model.isSuspendInstanceOnDataAssociationError());
            if (this.namespaceFeatureEditor != null) {
                this.namespaceFeatureEditor.fromFeature();
                String value = ((NamespaceFeature)this.namespaceFeatureEditor.getFeature()).getValue();
                if (Str.isEmpty(value)) {
                    this.namespaceFeatureEditor.setNamespace(ProcessInfoPanel.getDefaultNamespace(model.getId()));
                }
            }
            if (model.getProject().isTemplate()) {
                this.sealEditor.fromFeature();
            }
        }

        @Override
        public void panelToObject(Process model) {
            if (this.generateEventFeatureEditor != null) {
                this.generateEventFeatureEditor.applyChanges();
            }
            model.setSuspendInstanceOnDataAssociationError(this.suspendInstanceCheckBox.isSelected());
            if (model.getProject().isTemplate()) {
                this.sealEditor.toFeature();
            }
            if (this.namespaceFeatureEditor != null) {
                this.namespaceFeatureEditor.toFeature();
            }
        }

        public NamespaceFeatureEditor getNamespaceFeatureEditor() {
            return this.namespaceFeatureEditor;
        }

        private static void addRow(PanelBuilder builder, UiComponent component, CellConstraints cc) {
            FormLayout layout = builder.getLayout();
            layout.appendRow("5dlu");
            layout.appendRow("pref");
            int y = layout.getRowCount();
            builder.add(component, cc.xywh(2, y, 4, 1));
        }
    }

    static abstract class InnerPanelBuilder {
        private Process process;

        public InnerPanelBuilder(Process process) {
            this.process = process;
        }

        public abstract void panelToObject(Process var1);

        public abstract void checkValues(Process var1) throws DesignerException;

        public abstract void objectToPanel(Process var1);

        public Process getProcess() {
            return this.process;
        }
    }

    public static interface NamespaceFeatureProvider {
        public NamespaceFeatureEditor get();
    }
}

