/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import fuego.simulation.Event;
import fuego.simulation.Simulation;
import fuego.simulation.SimulationEventListener;
import java.util.List;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.PredicateUtils;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ActivitySimulationInterface;
import oracle.bpm.designer.DesignerStateManager;
import oracle.bpm.designer.ProcessCanvas;
import oracle.bpm.designer.ProcessDomainEventDispatcher;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.controller.BpmnControllerFactory;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.controller.ProcessController;
import oracle.bpm.designer.controller.SequenceFlowController;
import oracle.bpm.designer.print.ProcessPrintable;
import oracle.bpm.designer.selection.DesignerSelectionProvider;
import oracle.bpm.designer.simulation.SimulationListener;
import oracle.bpm.diagram.draw.DrawableFactory;
import oracle.bpm.diagram.draw.Grid;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.Domain;
import oracle.bpm.draw.BpmnDrawableFactory;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableProcess;
import oracle.bpm.print.Printable;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessDomain
extends Domain {
    private ProcessDomainEventDispatcher dispatcher;
    @Deprecated
    private DesignerSimulationEventListener eventListener;
    private final Grid grid = Grid.createNull();
    @Deprecated
    private boolean simulate;
    @Deprecated
    private SimulationListener simulationListener;
    private static final Predicate<Controller> FLOW_NODE_INSTANCE = new Predicate<Controller>(){

        @Override
        public boolean check(@Nullable Controller controller) {
            return controller != null && controller.getModelObject() instanceof FlowNode;
        }
    };
    private static final Predicate<Controller> ONLY_NODE_CONTAINERS = new Predicate<Controller>(){

        @Override
        public boolean check(@Nullable Controller controller) {
            return controller != null && controller.getModelObject() instanceof NodeContainer;
        }
    };

    public ProcessDomain(@NotNull UiContainer parent, @NotNull Process process) {
        super(parent, (Object)process);
        this.initSimulation();
        process.addListener((ProjectListener)this.getDispatcher());
    }

    public void initialize() {
        this.initSelectionProviderListeners();
    }

    public ProcessCanvas getCanvas() {
        return (ProcessCanvas)super.getCanvas();
    }

    public DesignerSelectionProvider getSelectionProvider() {
        return (DesignerSelectionProvider)super.getSelectionProvider();
    }

    public DesignerStateManager getStateManager() {
        return (DesignerStateManager)super.getStateManager();
    }

    public Process getDomainElement() {
        return (Process)super.getDomainElement();
    }

    public DrawableFactory getDrawableFactory() {
        return BpmnDrawableFactory.getInstance();
    }

    public BpmnControllerFactory getControllerFactory() {
        return BpmnControllerFactory.getInstance();
    }

    public Grid getGrid() {
        return this.grid;
    }

    public Printable getDomainPrintable() {
        return new ProcessPrintable(this.getDomainElement());
    }

    public DrawContext getContext() {
        return (DrawContext)super.getContext();
    }

    public void onDispose() {
        AbstractStudioWorkbench.getInstance().removeSimulationListener(this.simulationListener);
        this.getDomainElement().removeListener((ProjectListener)this.getDispatcher());
        this.getProcessController().dispose();
    }

    @Deprecated
    public boolean isShowAnimation() {
        return this.simulate;
    }

    @Deprecated
    public void setShowAnimation(boolean simulate) {
        this.simulate = simulate;
        this.getCanvas().repaint();
    }

    public Controller<?> findController(@NotNull Predicate<Controller> recursion, int x, int y, @Nullable Predicate<Controller> check) {
        return this.getProcessController().findControllerAt(recursion, x, y, check);
    }

    @Nullable
    public FlowNodeController<?> findNodeControllerInPosition(int x, int y) {
        return (FlowNodeController)this.findController(ONLY_NODE_CONTAINERS, x, y, FLOW_NODE_INSTANCE);
    }

    @Deprecated
    @Nullable
    public FlowNodeController<?> findNodeControllerInPosition(@NotNull NodeContainerController<?> container, int x, int y) {
        return (FlowNodeController)container.findControllerAt(PredicateUtils.falsePredicate(), x, y, FLOW_NODE_INSTANCE);
    }

    public void unregister(Controller<? extends FlowElement> controller) {
        this.getDispatcher().unregister(controller);
    }

    public void register(Controller<? extends FlowElement> listener) {
        this.getDispatcher().register(listener);
    }

    public Controller getController(FlowElement fn) {
        return this.getProcessController().asController(fn);
    }

    protected ProcessCanvas initializeCanvas(@NotNull UiContainer parent) {
        return new ProcessCanvas(parent, this);
    }

    protected DrawContext initializeContext() {
        return new DrawContext();
    }

    protected DesignerSelectionProvider initializeSelectionProvider() {
        return new DesignerSelectionProvider();
    }

    protected DesignerStateManager initializeDomainManager() {
        return new DesignerStateManager(this);
    }

    private void initSelectionProviderListeners() {
        this.getSelectionProvider().addSelectionListener(new SelectionListener(){

            public void selectionChanged(Selection selection) {
                ProcessDomain.this.getCanvas().repaint();
            }
        });
    }

    @Deprecated
    private void initSimulation() {
        this.eventListener = new DesignerSimulationEventListener();
        StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
        if (workbench == null) {
            return;
        }
        if (workbench.isSimulating()) {
            workbench.getSimulation().addEventListener((SimulationEventListener)this.eventListener);
        }
        this.simulationListener = new SimulationListener(){

            @Override
            public void simulationStarted(Simulation simulation) {
                if (simulation != null) {
                    simulation.addEventListener((SimulationEventListener)ProcessDomain.this.eventListener);
                }
            }

            @Override
            public void simulationStopped(Simulation simulation) {
                if (simulation != null) {
                    simulation.removeEventListener((SimulationEventListener)ProcessDomain.this.eventListener);
                }
            }
        };
        workbench.addSimulationListener(this.simulationListener);
    }

    private DrawableProcess getDrawableProcess() {
        return (DrawableProcess)this.getProcessController().getDrawableObject();
    }

    private ProcessController getProcessController() {
        return this.getCanvas().getProcessController();
    }

    private ProcessDomainEventDispatcher getDispatcher() {
        if (this.dispatcher == null) {
            this.dispatcher = new ProcessDomainEventDispatcher(this);
        }
        return this.dispatcher;
    }

    private class DesignerSimulationEventListener
    implements SimulationEventListener {
        private static final int SIMULATION_THREAD_SLEEP = 50;

        private DesignerSimulationEventListener() {
        }

        public void eventDue(List<Event> eventList) {
            StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
            final Simulation simulation = workbench.getSimulation();
            for (Event event : eventList) {
                switch (event.getType()) {
                    case 2: 
                    case 6: {
                        boolean transitionExists;
                        if (event.getFrom() != null && event.getFrom().getProcess() != ProcessDomain.this.getDrawableProcess().getModelObject() || event.getTo() != null && event.getTo().getProcess() != ProcessDomain.this.getDrawableProcess().getModelObject()) break;
                        FlowElementController from = ProcessDomain.this.getProcessController().asController((FlowElement)event.getFrom());
                        FlowElementController to = ProcessDomain.this.getProcessController().asController((FlowElement)event.getTo());
                        if (event.isFirstStep() && from instanceof ActivitySimulationInterface) {
                            ((ActivitySimulationInterface)((Object)from)).updateSimulationValues();
                        }
                        if (transitionExists = ProcessDomain.this.getProcessController().contains((FlowElement)event.getTransition())) {
                            SequenceFlowController sequenceFlowController = (SequenceFlowController)ProcessDomain.this.getProcessController().asController((FlowElement)event.getTransition());
                            sequenceFlowController.setSimulationNextPercentage(event.getStep());
                        }
                        if (!(to instanceof ActivitySimulationInterface) || !event.isLastStep() && (simulation == null || simulation.isPerformingAnimation())) break;
                        ((ActivitySimulationInterface)((Object)to)).updateSimulationValues();
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 5: {
                        return;
                    }
                }
            }
            if (simulation != null && simulation.isPerformingAnimation()) {
                UiUtilities.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (simulation.isPerformingAnimation()) {
                            ProcessDomain.this.getCanvas().repaint();
                        }
                    }
                });
                try {
                    double timeScalePct = simulation.getTimeScalePct();
                    int sleepTime = 50 - (int)(48.0 * timeScalePct / 100.0);
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

