/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.controller.ProcessController;
import oracle.bpm.designer.controller.SingleProcessRootController;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.AntialiasingMode;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.features.ViewScaleFeature;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.ui.PaintCanvas;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.AdjustmentEvent;
import oracle.bpm.ui.event.AdjustmentListener;
import org.jetbrains.annotations.NotNull;

public class ProcessCanvas
extends PaintCanvas {
    private boolean addedListeners = false;
    private final ProcessDomain domain;
    private final SingleProcessRootController root;
    private Dimension size;

    public ProcessCanvas(@NotNull UiContainer parent, @NotNull ProcessDomain domain) {
        super(parent);
        this.setLayout(null);
        this.domain = domain;
        domain.getContext().setContainer((UiContainer)this);
        this.root = this.initializeRoot();
    }

    public void paintCanvas(@NotNull Graphics graphics) {
        if (this.root.getDrawableRoot().hasSingleProcess()) {
            graphics.setAntialiasing(AntialiasingMode.ON);
            this.updateDrawContext(graphics);
            this.root.getDrawableRoot().draw();
            this.drawSimulation(graphics);
        }
    }

    public void paintImmediately(@NotNull Rectangle rectangle) {
        this.getDrawContext().setRectangle(rectangle);
        super.paintImmediately(rectangle);
    }

    public ProcessController getProcessController() {
        return this.root.getSingleProcess();
    }

    public boolean getDrawAlternative() {
        return ModelUtils.isHorizontal((Process)this.getProcess());
    }

    public Dimension getPreferredSize() {
        if (this.size == null) {
            this.size = this.calculateSize();
        }
        return this.size;
    }

    public void repaint() {
        Dimension calculated = this.calculateSize();
        this.getDrawContext().setRectangle(Rectangle.ZERO);
        if (!this.getPreferredSize().equals(calculated)) {
            this.size = calculated;
            this.revalidate();
        } else {
            super.repaint();
        }
    }

    private SingleProcessRootController initializeRoot() {
        return SingleProcessRootController.create(this, this.domain);
    }

    private DrawContext getDrawContext() {
        return this.domain.getContext();
    }

    private void updateDrawContext(@NotNull Graphics graphics) {
        DrawContext context = this.getDrawContext();
        context.setGraphics(graphics);
        context.setLocale(this.getProject().getPreferences().getDefaultLanguage());
        context.setScale(((ViewScaleFeature)this.getProcess().getFeature(ViewScaleFeature.class)).getValue().floatValue());
        if (context.getRectangle() == Rectangle.ZERO) {
            context.setRectangle(this.getVisibleRect());
        } else {
            context.setRectangle(graphics.getClipBounds());
        }
        context.setHorizontalDrawing(this.getDrawAlternative());
        this.updateDrawContextWithDesignerPreferences(context);
        this.ensureScrollListeners();
    }

    private void updateDrawContextWithDesignerPreferences(@NotNull DrawContext context) {
        DesignerPreferences preferences = DesignerPreferences.getPreferences();
        context.setShowGrid(preferences.getShowGrid());
        context.setShowNotes(preferences.getShowNotes());
    }

    private Process getProcess() {
        return this.domain.getDomainElement();
    }

    private Project getProject() {
        return this.getProcess().getProject();
    }

    private void ensureScrollListeners() {
        if (!this.addedListeners) {
            this.addVerticalAdjustmentListener(new AdjustmentListener(){

                public void adjustmentValueChanged(AdjustmentEvent event) {
                    ProcessCanvas.this.getDrawContext().setDeltaY(event.getValue());
                    ProcessCanvas.this.repaint();
                }
            });
            this.addHorizontalAdjustmentListener(new AdjustmentListener(){

                public void adjustmentValueChanged(AdjustmentEvent event) {
                    ProcessCanvas.this.getDrawContext().setDeltaX(event.getValue());
                    ProcessCanvas.this.repaint();
                }
            });
            this.addedListeners = true;
        }
    }

    private Dimension calculateSize() {
        Dimension size = this.root.getDrawableRoot().getBounds().getSize();
        return this.getDrawContext().scale(size);
    }

    @Deprecated
    private void drawSimulation(Graphics graphics) {
        StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
        if (workbench != null && workbench.isSimulating()) {
            this.getProcessController().drawSimulation(graphics);
        }
        super.paintComponents(graphics);
    }
}

