/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.Collection;
import oracle.bpm.designer.ObjectCilContainer;
import oracle.bpm.designer.action.OpenCloseMemberAction;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.type.Argument;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.Variable;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.Selection;
import org.jetbrains.annotations.NotNull;

public class OpenCloseMemberAccessorAction
extends OpenCloseMemberAction {
    public OpenCloseMemberAccessorAction(@NotNull CatalogObject parent, @NotNull AttributeTypeDescription atd, int accessorType) {
        super(parent);
        MethodTypeDescription method = OpenCloseMemberAccessorAction.methodFor(atd, accessorType);
        super.setSelection(DefaultSelection.createSingle((Object)method));
    }

    public static MethodTypeDescription methodFor(@NotNull AttributeTypeDescription atd, @NotNull int accessorType) {
        MethodTypeDescription newMethod;
        ObjectTypeDescription parent = atd.getParent().asObject();
        final AttributeTypeDescription attributeTypeDescription = atd.asAttribute();
        if (accessorType == 8) {
            String name = ObjectCilContainer.READ_ACCESS_CODE + atd.getName();
            newMethod = new MethodTypeDescription(name){

                @Override
                public void setCode(SourceCode code) {
                    super.setCode(code);
                    attributeTypeDescription.setCode(code);
                }
            };
            newMethod.setModifiers(newMethod.getModifiers() | 0x100000000L);
            newMethod.setCode(attributeTypeDescription.getCode());
            newMethod.setResultType(atd.getResultType().get());
            newMethod.setParent(parent);
            Collection<Variable> variables = atd.getVariables();
            for (Variable variable : variables) {
                newMethod.addVariable(variable);
            }
        } else {
            String name = ObjectCilContainer.WRITE_ACCESS_CODE + atd.getName();
            newMethod = new MethodTypeDescription(name){

                @Override
                public void setCode(SourceCode code) {
                    super.setCode(code);
                    attributeTypeDescription.setWriteCode(code);
                }
            };
            newMethod.setModifiers(newMethod.getModifiers() | 0x100000000L);
            newMethod.setCode(attributeTypeDescription.getWriteCode());
            newMethod.setResultType(TypeFactory.getVoid());
            newMethod.setParent(parent);
            Argument arg = new Argument("value", atd.getResultType(), 1L);
            newMethod.setArguments(new Argument[]{arg});
            Collection<Variable> writeVariables = atd.asAttribute().getWriteVariables();
            for (Variable writeVariable : writeVariables) {
                newMethod.addVariable(writeVariable);
            }
        }
        return newMethod;
    }

    public void setSelection(Selection selection) {
    }
}

