/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import oracle.bpm.cil.MessageListener;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.designer.AbstractCilContainer;
import oracle.bpm.designer.IconFactory;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.model.processes.Method;
import oracle.bpm.type.Argument;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.Variable;
import oracle.bpm.ui.Image;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;

public class ObjectCilContainer
extends AbstractCilContainer {
    private MethodTypeDescription member;
    private TypeRef parent;
    public static String READ_ACCESS_CODE = "read_access_code_";
    public static String WRITE_ACCESS_CODE = "write_access_code_";

    public ObjectCilContainer(ObjectTypeDescription objectType) {
        if (objectType == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        if (objectType.getCatalog() == null) {
            throw new IllegalArgumentException("Specified objectType does not have catalog: " + objectType);
        }
        this.parent = objectType.getRef();
    }

    public ObjectCilContainer(MethodTypeDescription member) {
        this.member = member;
        if (this.member != null) {
            this.parent = this.member.getParent();
        }
    }

    @Override
    public Argument[] getArgumentVars(MethodTypeDescription script) {
        return this.member.getArguments();
    }

    @Override
    public String getCILName() {
        if (this.member != null && this.member.isSynthesized()) {
            String name = this.member.getName();
            if (name.startsWith(READ_ACCESS_CODE)) {
                String attributeName = name.substring(READ_ACCESS_CODE.length());
                return attributeName + " " + DesignerMsg.READ_ACCESS_CODE;
            }
            if (name.startsWith(WRITE_ACCESS_CODE)) {
                String attributeName = name.substring(WRITE_ACCESS_CODE.length());
                return attributeName + " " + DesignerMsg.WRITE_ACCESS_CODE;
            }
        }
        return null;
    }

    @Override
    public MethodTypeDescription[] getCilList() {
        int count = this.getObjectType().getMemberCount();
        ArrayList<MethodTypeDescription> members = new ArrayList<MethodTypeDescription>();
        for (int i = 0; i < count; ++i) {
            MethodTypeDescription member = this.getObjectType().getMember(i);
            if (member.isAttribute()) continue;
            members.add(member);
        }
        return members.toArray(new MethodTypeDescription[0]);
    }

    @Override
    public FuegoCompiler getCompiler(MessageListener listener) {
        ObjectTypeDescription parentClass = this.getObjectType();
        if (this.member != null) {
            parentClass = this.member.getParent().asObject();
        }
        FuegoCompiler xobjectCompiler = new FuegoCompiler();
        xobjectCompiler.setMessageListener(listener);
        xobjectCompiler.addObjectClass((TypeRef)parentClass);
        return xobjectCompiler;
    }

    public String getCurrentAccessorID() {
        if (this.member != null && this.member.isSynthesized()) {
            String name = this.member.getName();
            if (name.startsWith(READ_ACCESS_CODE)) {
                return DesignerMsg.READ_ACCESS_CODE.getCode();
            }
            if (name.startsWith(WRITE_ACCESS_CODE)) {
                return DesignerMsg.WRITE_ACCESS_CODE.getCode();
            }
        }
        return null;
    }

    public MethodTypeDescription getCurrentAttribute() {
        if (this.member != null && this.member.isSynthesized()) {
            String name = this.member.getName();
            String attributeName = null;
            if (name.startsWith(READ_ACCESS_CODE)) {
                attributeName = name.substring(READ_ACCESS_CODE.length());
            } else if (name.startsWith(WRITE_ACCESS_CODE)) {
                attributeName = name.substring(WRITE_ACCESS_CODE.length());
            }
            return this.member.getParent().findMember(attributeName);
        }
        return null;
    }

    public String getCurrentID() {
        if (this.member != null && this.member.isSynthesized()) {
            String name = this.member.getName();
            if (name.startsWith(READ_ACCESS_CODE)) {
                String attributeName = name.substring(READ_ACCESS_CODE.length());
                name = attributeName + " " + 8;
            } else if (name.startsWith(WRITE_ACCESS_CODE)) {
                String attributeName = name.substring(WRITE_ACCESS_CODE.length());
                name = attributeName + " " + 7;
            }
            name = this.member.getParent().getName() + "." + name;
            return name;
        }
        return null;
    }

    public int getCurrentPart() {
        int part = 0;
        if (this.member != null) {
            String name = this.member.getName();
            if (name.startsWith(READ_ACCESS_CODE)) {
                part = 8;
            } else if (name.startsWith(WRITE_ACCESS_CODE)) {
                part = 7;
            }
        }
        return part;
    }

    @Override
    public MethodTypeDescription[] getInstanceVariableList() {
        MethodTypeDescription[] instanceVars = this.getObjectType().getMembers(18, 0L, 0x2000000L);
        if (this.member != null && this.member.getParent() != this.parent && this.member.getParent() != null) {
            MethodTypeDescription[] groupInstanceVars = ((ObjectTypeDescription)this.member.getParent()).getMembers(18, 0L, 0x2000000L);
            MethodTypeDescription[] temp = new MethodTypeDescription[instanceVars.length + groupInstanceVars.length];
            System.arraycopy(instanceVars, 0, temp, 0, instanceVars.length);
            System.arraycopy(groupInstanceVars, 0, temp, instanceVars.length, groupInstanceVars.length);
            instanceVars = temp;
        }
        return instanceVars;
    }

    public void setMethod(MethodTypeDescription member) {
        this.member = member;
        super.setCurrentMethod(member);
    }

    public MethodTypeDescription getMethod() {
        return this.member;
    }

    @Override
    public void setModified(boolean b) {
    }

    @Override
    public ObjectTypeDescription getObjectType() {
        if (this.member != null) {
            return this.member.getParent().asObject();
        }
        return this.parent.get().asObject();
    }

    public FuegoProject getProject() {
        return FuegoProject.getFrom((TypeRef)this.getObjectType());
    }

    @Override
    public boolean isReadOnly() {
        return this.getTypeRepository().isReadOnly(this.getObjectType());
    }

    @Override
    public String getUniqueNameForCil(String s) {
        return null;
    }

    @Override
    public void addException(String s) {
    }

    @Override
    public boolean allowsStatic() {
        return true;
    }

    @Override
    public boolean canAddArgumentVars() {
        return this.member == null || !Modifier.isInherited(this.member.getModifiers()) && !this.member.isSynthesized() && (!this.member.isConstructor() || !this.member.getParent().isInnerType());
    }

    @Override
    public boolean canAddInstanceVars() {
        return true;
    }

    @Override
    public boolean canEdit(MethodTypeDescription var) {
        MethodTypeDescription method = this.getMethod();
        boolean canEdit = method == null || method != var;
        return canEdit && !XObjectTypeDescriptionHelper.isGroup((AttributeTypeDescription)var.asAttribute());
    }

    @Override
    public MethodTypeDescription copyCil(String cilName, MethodTypeDescription script) {
        return script;
    }

    @Override
    public Method.Mutable createCil(String name) {
        return null;
    }

    @Override
    public boolean requireStatic(MethodTypeDescription script) {
        return false;
    }

    @Override
    public void updateCil(MethodTypeDescription script) {
        block4: {
            String name;
            block5: {
                if (this.member == null || !this.member.isSynthesized()) break block4;
                name = this.member.getName();
                if (!name.startsWith(READ_ACCESS_CODE)) break block5;
                String attributeName = name.substring(READ_ACCESS_CODE.length());
                MethodTypeDescription attribute = this.member.getParent().findMember(attributeName);
                if (attribute == null || !attribute.isAttribute()) break block4;
                attribute.setCode(script.getCode());
                attribute.removeAllVariables();
                for (Variable variable : script.getVariables()) {
                    attribute.addVariable(variable);
                }
                break block4;
            }
            if (name.startsWith(WRITE_ACCESS_CODE)) {
                String attributeName = name.substring(WRITE_ACCESS_CODE.length());
                MethodTypeDescription attribute = this.member.getParent().findMember(attributeName);
                if (attribute != null && attribute.isAttribute()) {
                    attribute.asAttribute().setWriteCode(script.getCode());
                    attribute.asAttribute().removeAllWriteVariables();
                    for (Variable variable : script.getVariables()) {
                        attribute.asAttribute().addWriteVariable(variable);
                    }
                }
            }
        }
    }

    @Override
    public boolean useArgumentVars() {
        return true;
    }

    @Override
    public boolean useInstanceVars() {
        return true;
    }

    @Override
    public Image getIcon() {
        return IconFactory.getIconFor(this.getMethod());
    }

    @Override
    public MethodTypeDescription getInput() {
        return this.getMethod();
    }

    @Override
    public String getTitle() {
        MethodTypeDescription mtd = this.getMethod();
        String path = "";
        for (TypeDescription mtdParent = mtd.getParent(); mtdParent != null && mtdParent.isInnerType(); mtdParent = mtdParent.getParent()) {
            path = mtdParent.getName() + "." + path;
        }
        path = path + mtd.getName();
        return path;
    }

    @Override
    protected MethodTypeDescription getMember() {
        return this.getMethod();
    }

    private MutableComponentCatalog getTypeRepository() {
        return (MutableComponentCatalog)this.getObjectType().getCatalog();
    }
}

