/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.FlowFigureTypeRibbonItem;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureTypeProvider;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.RibbonItem;
import oracle.bpm.ui.RibbonSectionMultiple;
import oracle.bpm.ui.UiContainer;

public class NotificationRibbonSection
extends RibbonSectionMultiple {
    private RibbonItem defaultItem;
    private ProcessDomain domain;

    public NotificationRibbonSection(UiContainer parent, ProcessDomain domain) {
        super(parent);
        this.domain = domain;
        super.loadSection();
    }

    public Sequence<RibbonItem> loadItems() {
        ArrayList<FlowFigureTypeRibbonItem> list = new ArrayList<FlowFigureTypeRibbonItem>();
        FlowFigureType defaultValue = this.getDefaultType();
        for (FlowFigureType flowFigureType : FlowFigureTypeProvider.getNotificationActivities()) {
            FlowFigureTypeRibbonItem item = this.domain == null ? new FlowFigureTypeRibbonItem(null, flowFigureType) : new FlowFigureTypeRibbonItem(this.domain.getStateManager(), flowFigureType);
            if (flowFigureType.equals((Object)defaultValue)) {
                this.defaultItem = item;
            }
            list.add(item);
        }
        return CollectionUtils.asSequence(list);
    }

    public Msg getTitle() {
        return DesignerMsg.NOTIFICATION;
    }

    public RibbonItem getDefault() {
        if (this.defaultItem == null) {
            throw new ExceptionInInitializerError();
        }
        return this.defaultItem;
    }

    public void setDefault(RibbonItem defaultItem) {
        this.defaultItem = defaultItem;
        DesignerPreferences designerPreferences = DesignerPreferences.getPreferences();
        designerPreferences.setLastNotificationRibbonSection(((FlowFigureTypeRibbonItem)defaultItem).getType());
        designerPreferences.store();
    }

    private FlowFigureType getDefaultType() {
        DesignerPreferences designerPreferences = DesignerPreferences.getPreferences();
        FlowFigureType lastPreference = designerPreferences.getLastNotificationRibbonSection();
        if (lastPreference != null) {
            return lastPreference;
        }
        return FlowFigureType.NOTIFICATION_TASK_MAIL;
    }
}

