/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.net.URI;
import java.net.URISyntaxException;
import oracle.bpm.designer.activitiespanels.FeatureEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.features.NamespaceFeature;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.text.TextField;

public class NamespaceFeatureEditor
extends FeatureEditor<NamespaceFeature> {
    private TextField namespaceTextField;

    public NamespaceFeatureEditor(UiContainer parent, NamespaceFeature feature) {
        super(parent, feature, false, false);
        this.build();
    }

    @Override
    public void toFeature() {
        ((NamespaceFeature)this.getFeature()).setValue(this.namespaceTextField.getText());
    }

    @Override
    public void fromFeature() {
        this.namespaceTextField.setText(((NamespaceFeature)this.getFeature()).getValue());
    }

    public void checkValues() throws URISyntaxException {
        if ("".equals(this.namespaceTextField.getText().trim())) {
            throw new URISyntaxException("", "Invalid URI");
        }
        new URI(this.namespaceTextField.getText());
    }

    public void setNamespace(String s) {
        this.namespaceTextField.setText(s);
    }

    public void setEnabled(boolean enabled) {
        this.namespaceTextField.setEnabled(enabled);
    }

    private void build() {
        FormLayout form = new FormLayout("pref,5dlu, pref:grow", "pref");
        this.setLayout((Layout)form);
        CellConstraints cc = form.createCellConstraints();
        this.namespaceTextField = new TextField((UiContainer)this);
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.SERVICE_NAMESPACE), cc.xy(1, 1));
        this.add((UiComponent)this.namespaceTextField, cc.xy(3, 1));
    }
}

