/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.io.File;
import java.io.FileNotFoundException;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.ProjectTreeMember;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.utils.IconFactory;
import oracle.bpm.extensionpoint.metadata.TreeNodeMetadata;
import oracle.bpm.geom.Point;
import oracle.bpm.lang.Platform;
import oracle.bpm.processmodel.SchemaType;
import oracle.bpm.project.io.serializers.model.DefaultModelFormat;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.DragItem;
import oracle.bpm.ui.dnd.DropItem;
import oracle.bpm.ui.dnd.FileTransfer;
import oracle.bpm.ui.dnd.LocalObjectTransfer;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.util.FileUtils;

@TreeNodeMetadata(objectType=FolderContainer.class)
public class ModelContainerTreeNode
extends ProjectObjectTreeNode<FolderContainer>
implements ProjectTreeMember,
DragItem,
DropItem {
    private String displayName;

    public ModelContainerTreeNode(FolderContainer folderContainer) {
        this(folderContainer, folderContainer.getProject().equals(folderContainer.getParentObject()));
    }

    public ModelContainerTreeNode(FolderContainer dirNode, boolean root) {
        super((ProjectObject)dirNode);
        if (root) {
            this.setMsg(DesignerMsg.PROCESSES_TREE_NODE);
        }
    }

    public static Process importProcessFile(File sourceFile, FolderContainer modelContainer) throws FileNotFoundException, ProjectException {
        Project project = modelContainer.getProject();
        SchemaType type = SchemaType.getSchemaTypeFor(sourceFile);
        Process model = modelContainer.createModel("");
        DefaultModelFormat.load((Process)model, (File)sourceFile);
        model.setId(ModelUtils.nextNameForModel((Project)project, (String)model.getId()));
        if (project.findProcess(model.getId()) != null) {
            MessageDialog.showError((Msg)DesignerMsg.PROCESS_ID_EXISTS_TMSG(model.getDefaultLabel()));
            return null;
        }
        modelContainer.addChild((ProjectObject)model);
        ModelContainerTreeNode.fixRoles(project, model);
        return model;
    }

    public FolderContainer getModelContainer() {
        return (FolderContainer)this.getUserObject();
    }

    public void setDisplayName(String projectProcessesRootNodeName) {
        this.displayName = projectProcessesRootNodeName;
    }

    public FontStyle getFontModifiers() {
        boolean rootNode = this.getDisplayName().equals("processes");
        return rootNode ? FontStyle.BOLD : FontStyle.PLAIN;
    }

    @Override
    public Image resolveIcon() {
        Image icon = this.isProcessesRoot() ? Image.create((Msg)DesignerMsg.PROCESS_GROUP) : Image.create((Msg)DesignerMsg.FOLDER);
        return !this.isReadOnly() ? icon : IconFactory.createReadOnly(icon);
    }

    public boolean isReadOnly() {
        return ((FolderContainer)this.getProjectObject()).isReadOnly();
    }

    public boolean isProcessesRoot() {
        return this.getDisplayName().equals("processes");
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    public Transfer[] getTransfers() {
        return new Transfer[0];
    }

    public Object getObjectAs(Transfer transfer) {
        return null;
    }

    public void drop(Object data, Transfer transfer, Point point, DndAction dndAction) {
        if (transfer == FileTransfer.getInstance()) {
            String[] files = (String[])data;
            File targetFile = Platform.getAdapterService().adaptTo(this.getProjectObject(), File.class);
            for (String file : files) {
                FileUtils.copyFileOrDirectory(new File(file), targetFile);
            }
            ProjectWriter projectWriter = this.getProject().getWriter();
            try {
                projectWriter.refresh(this.getProjectObject());
            }
            catch (ProjectException e) {
                MessageDialog.showError((Throwable)e);
            }
            return;
        }
        if (transfer == LocalObjectTransfer.getInstance(Process.class) && data instanceof Process) {
            Process process = (Process)data;
            boolean isMove = process.getProject() == ((FolderContainer)this.getProjectObject()).getProject();
            ProjectObject container = process.getParentObject();
            if (container != null && this.getProjectObject() != container) {
                this.moveModel(process, isMove ? dndAction : DndAction.COPY);
            }
        }
    }

    public boolean canDrop(Object data, Transfer transfer, Point point, DndAction dndAction) {
        return true;
    }

    @Override
    protected String getName() {
        return ((FolderContainer)this.getProjectObject()).getId();
    }

    private static void fixRoles(Project project, Process process) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    private void moveModel(Process process, DndAction dndAction) {
        block7: {
            try {
                ProjectObjectContainer sourceContainer = (ProjectObjectContainer)process.getParentObject();
                FolderContainer targetModelContainer = (FolderContainer)this.getProjectObject();
                if (targetModelContainer.getProject() != sourceContainer.getProject() || dndAction.isCopy()) {
                    try {
                        File sourceProcessFile = Platform.getAdapterService().adaptTo(process, File.class);
                        ModelContainerTreeNode.importProcessFile(sourceProcessFile, targetModelContainer);
                        if (dndAction.isMove()) {
                            process.delete();
                        }
                        break block7;
                    }
                    catch (ProjectException e) {
                        MessageDialog.showError((Throwable)e);
                    }
                    catch (FileNotFoundException e) {
                        MessageDialog.showError((Throwable)e);
                    }
                    break block7;
                }
                process.delete();
                targetModelContainer.addChild((ProjectObject)process);
            }
            catch (ProjectException e) {
                MessageDialog.showError((Throwable)e);
            }
        }
    }

    private String getDisplayName() {
        return this.displayName == null ? ((FolderContainer)this.getProjectObject()).getId() : this.displayName;
    }
}

