/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.AbstractListDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;

public class MethodsListDialog
extends AbstractListDialog {
    protected MethodTypeDescription selectedMethod_d;
    private ObjectTypeDescription objectType;

    public MethodsListDialog(UiWindow parentFrame, ObjectTypeDescription objectType) {
        super(parentFrame, true);
        this.objectType = objectType;
        this.setup();
    }

    public MethodTypeDescription getSelectedMethod() {
        return this.selectedMethod_d;
    }

    public void accept() {
        this.setUserAccepted(true);
        this.setSelectedMethod((MethodTypeDescription)this.dataList.getSelectedValue());
        this.close();
    }

    @Override
    protected Msg getDialogMsg() {
        return DesignerMsg.ENTER_CIL_NAME;
    }

    @Override
    protected Object[] getListData() {
        ArrayList<MethodTypeDescription> memberList = new ArrayList<MethodTypeDescription>();
        List<MethodTypeDescription> members = this.objectType.getMethods();
        for (MethodTypeDescription member : members) {
            if (XObjectTypeDescriptionHelper.isValidValuesMethod((MethodTypeDescription)member)) continue;
            memberList.add(member);
        }
        return memberList.toArray();
    }

    @Override
    protected AbstractListDialog.TextFieldRenderer createTextFieldRenderer() {
        return new AbstractListDialog.TextFieldRenderer(){

            @Override
            public String getTextFieldValue(Object listValue) {
                MethodTypeDescription method = (MethodTypeDescription)listValue;
                return method == null ? "" : method.getName();
            }
        };
    }

    @Override
    protected LabelProvider createLabelProvider() {
        return new MethodsLabelProvider();
    }

    private void setSelectedMethod(MethodTypeDescription mtd) {
        this.selectedMethod_d = mtd;
    }

    static class MethodsLabelProvider
    extends LabelProvider.Default<MethodTypeDescription> {
        private Image methodIcon = Image.create((Msg)ProjectMsg.METHOD);

        public Image getIcon(MethodTypeDescription methodTypeDescription) {
            return this.methodIcon;
        }

        public String getText(MethodTypeDescription methodTypeDescription) {
            return methodTypeDescription.getText();
        }
    }
}

