/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.net.MalformedURLException;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.dialog.DesignerDialogFactory;
import oracle.bpm.designer.dialog.organization.RoleDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.RoleDynamicName;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Dimension;
import oracle.bpm.project.model.features.CustomizedImageFeature;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ColorPicker;
import oracle.bpm.ui.ColorTransformation;
import oracle.bpm.ui.CustomImageHelper;
import oracle.bpm.ui.EditionDialog;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.msg.UIMsg;

public class LanePropertiesDialog
extends EditionDialog {
    private ColorPicker backgroundColorPicker;
    private IconPicker iconPicker;
    private boolean includeAutomatic;
    private Lane lane;
    private String name;
    private RoleDynamicName nameField;
    private Process process;
    private static final ColorTransformation ALPHA_TRANSFORMATION = new ColorTransformation(){

        public Color eval(Color value) {
            return Color.valueOf((Color)value, (int)150);
        }
    };

    public LanePropertiesDialog(UiWindow parent, Lane lane, boolean includeAutomatic) {
        this(parent, lane.getProcess(), includeAutomatic, lane);
    }

    public LanePropertiesDialog(UiWindow parent, Process process, boolean includeAutomatic, Lane lane) {
        super(parent, DesignerMsg.ROLE_PROPERTIES);
        this.process = process;
        this.lane = lane;
        this.includeAutomatic = includeAutomatic;
        this.init();
    }

    public void cancel() {
        this.name = null;
        super.cancel();
    }

    public Process getModel() {
        return this.process;
    }

    public String getLaneName() {
        return this.name;
    }

    public Color getBackgroundColor() {
        return this.backgroundColorPicker.getColor();
    }

    public String getCustomImageId() {
        return this.iconPicker.getImageId();
    }

    public void ok() {
        String laneName = this.nameField.getName();
        if (laneName == null || "".equals(laneName)) {
            MessageDialog.showError((Msg)DesignerMsg.INVALID_NAME, (Msg)DesignerMsg.ROLE_NAME_NOT_EMPTY);
            return;
        }
        this.setObjectName(laneName);
        this.close();
    }

    private RoleDynamicName createInput(UiContainer parent) {
        return new RoleDynamicName(parent, this.getModel(), this.includeAutomatic);
    }

    private void setObjectName(String name) {
        this.name = name;
    }

    private void init() {
        Panel container = new Panel(this.getContentPane());
        container.setLayout((Layout)new MigLayout("ins 10, gap 5, fillx"));
        this.nameField = this.createInput((UiContainer)container);
        Button newButton = new Button((UiContainer)container, DesignerMsg.NEW);
        newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RoleDialog dialog = DesignerDialogFactory.createRoleDialog((UiWindow)LanePropertiesDialog.this, LanePropertiesDialog.this.getModel().getProject().getOrganization());
                dialog.setVisible(true);
                if (dialog.userAccepted()) {
                    LanePropertiesDialog.this.nameField.updateNames(((Role)dialog.getProjectObjectAdded()).getId());
                }
            }
        });
        Color color = Color.valueOf((int)-1761607681, (boolean)true);
        String imageValue = "";
        if (this.lane != null) {
            this.nameField.updateNames(this.lane.getRole());
            color = Color.valueOf((int)this.lane.getBackgroundColor(), (boolean)true);
            CustomizedImageFeature feature = (CustomizedImageFeature)this.lane.getFeature(CustomizedImageFeature.class);
            imageValue = feature.getValue();
        }
        this.backgroundColorPicker = new ColorPicker((UiContainer)container, UIMsg.TRANSLUCENT_BGROUND, color, ALPHA_TRANSFORMATION);
        container.add((UiComponent)Label.create((UiContainer)container, (Msg)UIMsg.NAME), (Object)"alignx right");
        container.add(this.nameField.getUiComponent(), (Object)"width 150::, growx");
        container.add((UiComponent)newButton, (Object)"wrap");
        container.add((UiComponent)Label.create((UiContainer)container, (Msg)UIMsg.TRANSLUCENT_BGROUND));
        container.add((UiComponent)this.backgroundColorPicker, (Object)"wrap");
        container.add((UiComponent)Label.create((UiContainer)container, (Msg)DesignerMsg.IMAGE));
        this.iconPicker = new IconPicker((UiContainer)container, imageValue);
        container.add((UiComponent)this.iconPicker);
        this.getContentPane().add((UiComponent)container, (Object)"Center");
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private static class IconPicker
    extends Panel {
        private Label iconLabel;
        private String image;

        private IconPicker(UiContainer parent, String image) {
            super(parent);
            this.image = image;
            this.buildUi();
            this.populateValues();
        }

        public void populateValues() {
            this.updateIcon();
        }

        public String getImageId() {
            return "".equals(this.image) ? null : this.image;
        }

        private void buildUi() {
            FormLayout form = new FormLayout("pref,2dlu,pref,2dlu,pref,0dlu:grow(0.5)", "pref,0dlu,pref,0dlu:grow");
            CellConstraints cc = form.createCellConstraints();
            this.setLayout((Layout)form);
            this.iconLabel = Label.create((UiContainer)this, (Msg)null);
            this.populateValues();
            this.iconLabel.setPreferredSize(Dimension.valueOf(50, 40));
            this.iconLabel.setMinimumSize(Dimension.valueOf(50, 40));
            this.iconLabel.setBorder(BorderFactory.createLineBorder((Color)Color.BLACK));
            this.add((UiComponent)this.iconLabel, cc.xy(1, 1));
            Button browseButton = Button.createBrowse((UiContainer)this);
            browseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String result = AbstractStudioWorkbench.getInstance().browseForImage((UiComponent)IconPicker.this.iconLabel);
                    if (result != null) {
                        IconPicker.this.image = result;
                        IconPicker.this.updateIcon();
                    }
                }
            });
            this.add((UiComponent)browseButton, cc.xy(3, 1));
            Button clearButton = Button.createIconic((UiContainer)this, (Msg)UIMsg.CLEAR);
            clearButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IconPicker.this.image = null;
                    IconPicker.this.updateIcon();
                }
            });
            this.add((UiComponent)clearButton, cc.xy(5, 1));
        }

        private void updateIcon() {
            Image icon = null;
            if (this.image != null && !"".equals(this.image)) {
                try {
                    icon = CustomImageHelper.getCustomImage((String)this.image);
                    icon = icon.getScaledToFitInstance(45, 35);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            this.iconLabel.setIcon(icon);
        }
    }
}

