/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.awt.Point;
import javax.swing.JWindow;
import oracle.bpm.designer.ImagePanel;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lang.LowResolutionTimer;
import oracle.bpm.lang.LowResolutionTimerListener;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.KeyAdapter;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.event.KeyListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.bpm.ui.peer.swing.event.SwingKeyListener;

public class ImageViewer
extends JWindow {
    private Image image_d;
    private ImagePanel panel_d;
    private LowResolutionTimer timer_d = new LowResolutionTimer(2);
    static final long serialVersionUID = -1593710425305211238L;
    static final long serialCheck = -3206885083135739547L;

    public ImageViewer(Image i, oracle.bpm.geom.Point location) {
        this.image_d = i;
        Panel container = new Panel((UiContainer)UiComponent.get((Object)this.getContentPane()));
        container.setLayout((Layout)new BorderLayout());
        container.setBorder(BorderFactory.createRaisedBevelBorder());
        container.add(Box.createHorizontalStrut((UiContainer)container, (int)2), (Object)"East");
        container.add(Box.createVerticalStrut((UiContainer)container, (int)2), (Object)"North");
        container.add(Box.createVerticalStrut((UiContainer)container, (int)2), (Object)"South");
        this.panel_d = new ImagePanel((UiContainer)container, i, UiComponent.get((Object)this));
        container.add((UiComponent)this.panel_d, (Object)"Center");
        this.getContentPane().add(container.asSwing());
        this.addKeyListener((java.awt.event.KeyListener)SwingKeyListener.get((KeyListener)new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.isEscape()) {
                    ImageViewer.this.hideView();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        }));
        this.timer_d.add(new LowResolutionTimerListener(){

            @Override
            public void timerFired(LowResolutionTimer timer) {
                ImageViewer.this.showViewNow();
            }
        });
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    public void hideView() {
        this.timer_d.stop();
        this.setVisible(false);
        this.dispose();
    }

    public void showView() {
        if (!this.isVisible()) {
            this.timer_d.stop();
            this.timer_d.start();
        } else {
            this.timer_d.stop();
        }
    }

    public void showViewNow() {
        this.timer_d.stop();
        this.timer_d = new LowResolutionTimer(2);
        this.timer_d.add(new LowResolutionTimerListener(){

            @Override
            public void timerFired(LowResolutionTimer timer) {
                ImageViewer.this.showViewNow();
            }
        });
        this.configureSizes();
        this.setVisible(true);
        this.toFront();
    }

    private void configureSizes() {
        int width = 0;
        int height = 0;
        width = this.image_d.getWidth();
        height = this.image_d.getHeight();
        this.setSize(width, height);
        this.panel_d.setSize(width, height);
        Dimension dimension = Ui.getToolkit().getScreenSize();
        oracle.bpm.geom.Point loc = AwtConverter.fromAwt((Point)this.getLocation());
        int x = 0;
        int y = 0;
        y = loc.getY() < Math.round(dimension.getHeight() / 2) ? loc.getY() : loc.getY() - height;
        x = loc.getX() < Math.round(dimension.getWidth() / 2) ? loc.getX() : loc.getX() - width;
        x = x < 0 ? 0 : x;
        y = y < 0 ? 0 : y;
        this.setLocation(x, y);
        width = width > dimension.getWidth() ? dimension.getWidth() : width;
        height = height > dimension.getHeight() ? dimension.getHeight() : height;
        this.setSize(width, height);
        this.panel_d.setSize(width, height);
        this.repaint();
    }
}

