/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.io.File;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.filechooser.FileView;

public class ImageFileView
extends FileView {
    private Hashtable fileDescriptions = new Hashtable(5);
    private Hashtable icons = new Hashtable(5);
    private Hashtable typeDescriptions = new Hashtable(5);

    @Override
    public String getDescription(File f) {
        return (String)this.fileDescriptions.get(f);
    }

    public String getExtension(File f) {
        String name = f.getName();
        if (name != null) {
            int extensionIndex = name.lastIndexOf(46);
            if (extensionIndex < 0) {
                return null;
            }
            return name.substring(extensionIndex + 1).toLowerCase();
        }
        return null;
    }

    public Boolean isHidden(File f) {
        String name = f.getName();
        if (name == null || name.equals("") || name.charAt(0) != '.') {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Icon getIcon(File f) {
        String extension = this.getExtension(f);
        if (extension != null) {
            return (Icon)this.icons.get(extension);
        }
        return null;
    }

    @Override
    public String getName(File f) {
        return null;
    }

    @Override
    public Boolean isTraversable(File f) {
        if (f.isDirectory()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public String getTypeDescription(File f) {
        return (String)this.typeDescriptions.get(this.getExtension(f));
    }

    public void putDescription(File f, String fileDescription) {
        this.fileDescriptions.put(fileDescription, f);
    }

    public void putIcon(String extension, Icon icon) {
        this.icons.put(extension, icon);
    }

    public void putTypeDescription(String extension, String typeDescription) {
        this.typeDescriptions.put(typeDescription, extension);
    }

    public void putTypeDescription(File f, String typeDescription) {
        this.putTypeDescription(this.getExtension(f), typeDescription);
    }
}

