/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.HighlightLevel;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Point;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Link;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.PopUpWindow;
import oracle.bpm.ui.Slider;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.EmptyBorder;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class HighlightSlider
extends Link {
    private SliderLabelsPanel labels;
    private Collection<SliderListener> listeners = new ArrayList<SliderListener>();
    private HighlightLevelSlider slider;
    private HighlightLevel value;
    private static final int SLIDER_HEIGHT = 110;
    private static final int EXTRA_INSETS = 3;
    private static final Border EMPTY = new EmptyBorder(1, 1, 1, 1);

    private HighlightSlider(@NotNull UiContainer parent, @NotNull HighlightLevel level) {
        super(parent);
        this.setMsg(HighlightSlider.msgFor(level));
        this.setIcon(level.getIcon());
        this.value = level;
        this.setFont(this.getFont().smaller(2));
        this.build();
    }

    public static HighlightSlider create(@NotNull UiContainer parent, @NotNull Image icon, @NotNull HighlightLevel level) {
        return new HighlightSlider(parent, level);
    }

    public void setValue(@NotNull HighlightLevel value) {
        if (this.value.equals((Object)value)) {
            return;
        }
        this.value = value;
        this.updateButton();
        this.fireSliderChanged(value);
    }

    public HighlightLevel getValue() {
        return this.value;
    }

    public void addSliderListener(@NotNull SliderListener sliderListener) {
        this.listeners.add(sliderListener);
    }

    public void removeSliderListener(@NotNull SliderListener sliderListener) {
        this.listeners.remove(sliderListener);
    }

    private static Msg msgFor(@NotNull HighlightLevel level) {
        return DesignerMsg.HIGHLIGHTING_LEVEL_DETAIL(level.getMsg().getString());
    }

    private void updateButton() {
        this.setMsg(HighlightSlider.msgFor(this.value));
        this.setIcon(this.value.getIcon());
    }

    private void fireSliderChanged(@NotNull HighlightLevel value) {
        for (SliderListener sliderListener : this.listeners) {
            sliderListener.sliderChanged(value);
        }
        this.updateSliderValue(value);
    }

    private void build() {
        this.setBorder(EMPTY);
        final PopUpWindow window = new PopUpWindow(this.getOwnerWindow(), false, false);
        final Panel content = new Panel((UiContainer)window, DesignerMsg.HIGHLIGHTING_LEVEL);
        content.setLayout((Layout)new MigLayout("fill, gap 5, ins 2"));
        window.add((UiComponent)content);
        this.slider = this.createHighlighSlider((UiContainer)content);
        content.add((UiComponent)this.slider, (Object)"growx, wrap");
        this.labels = new SliderLabelsPanel((UiContainer)content, this.value);
        content.add((UiComponent)this.labels, (Object)"growx");
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                Point screen = HighlightSlider.this.getLocationOnScreen();
                if (content.getWidth() == 0) {
                    window.show(5000, 5000);
                }
                window.show(screen.getX() - content.getWidth() + HighlightSlider.this.getWidth(), screen.getY());
            }
        });
    }

    private HighlightLevelSlider createHighlighSlider(UiContainer parent) {
        this.slider = new HighlightLevelSlider(parent, this.value);
        this.slider.setBackground(Color.FUEGO_LIGHT_BLUE);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                HighlightLevel newLevel = HighlightSlider.this.slider.getLevelValue();
                HighlightSlider.this.labels.updateLevel(newLevel);
                HighlightSlider.this.setValue(newLevel);
            }
        });
        return this.slider;
    }

    private void updateSliderValue(@NotNull HighlightLevel newLevel) {
        if (this.slider.getLevelValue() != newLevel) {
            this.slider.setLevelValue(newLevel);
        }
    }

    private static class SliderLabelsPanel
    extends Panel {
        private Label error;
        private Label none;
        private Label warn;

        public SliderLabelsPanel(UiContainer parent, @NotNull HighlightLevel level) {
            super(parent);
            this.build();
            this.updateLevel(level);
        }

        public void updateLevel(@NotNull HighlightLevel level) {
            this.error.setEnabled(level.isError() || level.isWarning());
            this.warn.setEnabled(level.isWarning());
        }

        private void build() {
            this.setLayout((Layout)new MigLayout("fillx"));
            this.none = Label.createWithNoColon((UiContainer)this, (Msg)ProjectMsg.NONE);
            this.error = Label.createWithNoColon((UiContainer)this, (Image)HighlightLevel.ERROR.getIcon());
            this.warn = Label.createWithNoColon((UiContainer)this, (Image)HighlightLevel.WARNING.getIcon());
            this.add((UiComponent)this.none, "west, width 30, alignx left");
            this.add((UiComponent)this.error, "center");
            this.add((UiComponent)this.warn, "east, width 30, alignx right");
        }
    }

    private static class HighlightLevelSlider
    extends Slider {
        public HighlightLevelSlider(@NotNull UiContainer parent, @NotNull HighlightLevel value) {
            super(parent, 0, 0, HighlightLevel.values().length - 1, value.ordinal());
            this.setMajorTickSpacing(1);
            this.setSnapToTicks(true);
            this.setPaintTicks(true);
        }

        private HighlightLevel getLevelValue() {
            return HighlightLevel.values()[this.getValue()];
        }

        private void setLevelValue(@NotNull HighlightLevel level) {
            super.setValue(level.ordinal());
        }
    }

    public static interface SliderListener {
        public void sliderChanged(@NotNull HighlightLevel var1);
    }
}

