/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.Collection;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.types.CILTypeComboBox;
import oracle.bpm.designer.types.TypeItem;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.geom.Insets;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.GridBagConstraints;
import oracle.bpm.ui.layout.GridBagLayout;
import oracle.bpm.ui.layout.Layout;

public class GenericVariableEditorPanel
extends Panel {
    protected ActionListener al_d;
    protected Button catalogTypesButton_d;
    protected CILTypeComboBox ctypeComboBox;
    protected IdentifierTextField nameTextField;
    private DataDeclaration[] allHolders;
    private DataDeclaration typeHolder;

    public GenericVariableEditorPanel(UiContainer parent, DataDeclaration var, Collection<? extends DataDeclaration> vars) {
        super(parent);
        this.typeHolder = var;
        this.allHolders = vars.toArray(new DataDeclaration[vars.size()]);
    }

    public Button getBrowseButton() {
        return this.catalogTypesButton_d;
    }

    public CILTypeComboBox getCILTypeComboBox() {
        return this.ctypeComboBox;
    }

    public void afterEdit() {
    }

    public void beforeEdit() {
        this.nameTextField.setSelectionStart(0);
        this.nameTextField.setSelectionEnd(this.nameTextField.getText().length());
    }

    public boolean check() {
        if (this.nameTextField.getText().equals("")) {
            MessageDialog.showError((Msg)DesignerMsg.VARIABLE_NAME_IS_NULL);
            return false;
        }
        for (DataDeclaration typeHolder : this.allHolders) {
            if (typeHolder == this.typeHolder || !typeHolder.getName().equals(this.typeHolder.getName())) continue;
            MessageDialog.showError((Msg)DesignerMsg.DUPLICATE_VARS);
            return false;
        }
        String typeText = ((TypeItem)this.ctypeComboBox.getSelectedItem()).toString();
        try {
            TypeFactory.forName(typeText, this.getTypeRepository());
        }
        catch (Exception ex) {
            MessageDialog.showError((Throwable)ex);
            return false;
        }
        return true;
    }

    public void init() {
        this.setLayout((Layout)new GridBagLayout());
        this.nameTextField = new IdentifierTextField((UiContainer)this, "", 20);
        this.ctypeComboBox = new CILTypeComboBox((UiContainer)this);
        this.catalogTypesButton_d = new Button((UiContainer)this, ProjectMsg.BROWSE){

            public void addActionListener(ActionListener l) {
                if (GenericVariableEditorPanel.this.al_d == null) {
                    GenericVariableEditorPanel.this.al_d = l;
                    super.addActionListener(GenericVariableEditorPanel.this.al_d);
                }
            }
        };
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)ProjectDrawMsg.NAME), this.getFldConstraints(0, 0));
        this.add((UiComponent)this.nameTextField, this.getFldConstraints(1, 0));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)CoreMsg.TYPE), this.getFldConstraints(0, 1));
        this.add((UiComponent)this.ctypeComboBox, this.getFldConstraints(1, 1));
        this.add((UiComponent)this.catalogTypesButton_d, this.getFldConstraints(2, 1));
    }

    public void panelToVar() {
        TypeRef type;
        String typeText = ((TypeItem)this.ctypeComboBox.getSelectedItem()).toString();
        try {
            type = TypeFactory.forName(typeText, this.getTypeRepository());
        }
        catch (Exception ex) {
            MessageDialog.showError((Throwable)ex);
            return;
        }
        this.typeHolder.setName(this.nameTextField.getText());
        this.typeHolder.setType(CatalogObjectImpl.get((TypeRef)type.get()));
    }

    public void varToPanel() {
        this.nameTextField.setText(this.typeHolder.getName());
        this.ctypeComboBox.setSelectedItem(this.typeHolder.getType());
    }

    protected GridBagConstraints getFldConstraints(int gridx, int gridy) {
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = gridx;
        constr.gridy = gridy;
        constr.fill = 0;
        constr.anchor = 17;
        constr.insets = new Insets(8, 10, 8, 10);
        return constr;
    }

    private ComponentCatalog getTypeRepository() {
        return this.typeHolder.getType().getDelegate().getCatalog();
    }
}

