/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ProcessGenerateEvents;
import oracle.bpm.project.model.processes.activities.ProcessGenerateEventsFeature;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;

public class GenerateEventFeatureEditor
extends Panel
implements EditableComponent<Process> {
    private RadioButton allActivitiesRadio;
    private RadioButton interactiveRadio;
    private ModificationListener modificationListener;
    private RadioButton noEventsRadio;
    private Process process;
    private RadioButton projectDefaultRadio;

    public GenerateEventFeatureEditor(UiContainer parent, Process process) {
        super(parent, ((ProcessGenerateEventsFeature)process.getFeature(ProcessGenerateEventsFeature.class)).getLabel());
        this.process = process;
        this.build();
    }

    @Override
    public void validateEditor() throws ProjectException {
    }

    @Override
    public void applyChanges() {
        ProcessGenerateEvents value = this.getSelectedFeature();
        this.getFeature().setValue((Enum)value);
    }

    @Override
    public void populateValues() {
        this.loadValues();
    }

    @Override
    public void loadValues() {
        ProcessGenerateEvents featureValue = (ProcessGenerateEvents)this.getFeature().getValue();
        switch (featureValue) {
            case DO_NOT_GENERATE_EVENTS: {
                this.noEventsRadio.setSelected(true);
                break;
            }
            case GENERATE_ALL_EVENTS: {
                this.allActivitiesRadio.setSelected(true);
                break;
            }
            case GENERATE_INTERACTIVE_EVENTS: {
                this.interactiveRadio.setSelected(true);
                break;
            }
            case PROJECT_DEFAULT: {
                this.projectDefaultRadio.setSelected(true);
            }
        }
    }

    @Override
    public String getHelpId() {
        return null;
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    @Override
    public Process getElement() {
        return this.process;
    }

    @Override
    public boolean isDirty() {
        return !((ProcessGenerateEvents)this.getFeature().getValue()).equals((Object)this.getSelectedFeature());
    }

    @Override
    public void setElement(Process element) {
        this.process = element;
    }

    public ModificationListener getModificationListener() {
        if (this.modificationListener == null) {
            this.modificationListener = new ModificationListener(){

                public void objectModified(ModificationEvent modificationEvent) {
                    GenerateEventFeatureEditor.this.applyChanges();
                }
            };
        }
        return this.modificationListener;
    }

    private ProcessGenerateEventsFeature getFeature() {
        return (ProcessGenerateEventsFeature)this.process.getFeature(ProcessGenerateEventsFeature.class);
    }

    private void build() {
        this.setLayout((Layout)new BorderLayout(5, 5));
        Panel radioPanel = new Panel((UiContainer)this);
        ButtonGroup group = new ButtonGroup();
        this.projectDefaultRadio = new RadioButton((UiContainer)radioPanel, ProcessGenerateEvents.PROJECT_DEFAULT.getMsg());
        this.projectDefaultRadio.setSelected(true);
        this.allActivitiesRadio = new RadioButton((UiContainer)radioPanel, DesignerMsg.GENERATE_EVENTS_ALL_ACTIVITIES);
        this.interactiveRadio = new RadioButton((UiContainer)radioPanel, DesignerMsg.GENERATE_EVENTS_INTERACTIVE_ACTIVITIES);
        this.noEventsRadio = new RadioButton((UiContainer)radioPanel, DesignerMsg.DO_NOT_GENERATE_EVENTS);
        group.add((AbstractButton)this.projectDefaultRadio);
        group.add((AbstractButton)this.allActivitiesRadio);
        group.add((AbstractButton)this.interactiveRadio);
        group.add((AbstractButton)this.noEventsRadio);
        this.populateValues();
        UiUtilities.layoutRadioButtonPanel((UiContainer)radioPanel, null, (RadioButton[])new RadioButton[]{this.projectDefaultRadio, this.interactiveRadio, this.allActivitiesRadio, this.noEventsRadio}, (boolean)false);
        if (!this.hasTitle()) {
            this.add((UiComponent)Label.create((UiContainer)this, (Msg)this.getFeature().getLabel()), "North");
        }
        this.add(Box.createHorizontalStrut((UiContainer)this, (int)10), "West");
        this.add((UiComponent)radioPanel, "Center");
    }

    private ProcessGenerateEvents getSelectedFeature() {
        ProcessGenerateEvents value = this.interactiveRadio.isSelected() ? ProcessGenerateEvents.GENERATE_INTERACTIVE_EVENTS : (this.allActivitiesRadio.isSelected() ? ProcessGenerateEvents.GENERATE_ALL_EVENTS : (this.noEventsRadio.isSelected() ? ProcessGenerateEvents.DO_NOT_GENERATE_EVENTS : ProcessGenerateEvents.PROJECT_DEFAULT));
        return value;
    }
}

