/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.DesignerStateManager;
import oracle.bpm.designer.controller.ControllerUtils;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.state.AbstractDesignerState;
import oracle.bpm.diagram.editor.state.AddingState;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.execution.Executable;
import oracle.bpm.ui.RibbonItem;
import org.jetbrains.annotations.NotNull;

public class FlowFigureTypeRibbonItem
extends RibbonItem {
    @NotNull
    private DesignerStateManager manager;
    private final FlowFigureType type;

    public FlowFigureTypeRibbonItem(DesignerStateManager manager, FlowFigureType type) {
        super(FlowFigureUtils.getNameForType((FlowFigureType)type), DesignerPreferences.getPreferences().getTheme().getImageFor(type, ImageType.ICON));
        this.manager = manager;
        this.type = type;
    }

    public FlowFigureType getType() {
        return this.type;
    }

    public void execute(final Executable callBack) {
        if (this.manager != null) {
            this.manager.getDomain().getCanvas().requestFocus();
            FlowElementController controller = ControllerUtils.createFlowElementControllerFromType(this.type, this.manager.getDomain());
            this.manager.getCurrentState().cancel();
            this.manager.setCurrentState((AbstractDesignerState)new AddingState(CapabilityType.ADD_NODE, controller){

                protected void stateFinished() {
                    callBack.execute();
                    super.stateFinished();
                }
            });
        }
    }
}

