/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.SortedMap;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import oracle.bpm.designer.TypeLabelProvider;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.List;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.event.KeyListener;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.text.TextField;

public final class FindComponentDialog
extends Dialog
implements ActionListener,
ListSelectionListener {
    private ComponentList componentsList;
    private CheckBox includeDefComponents;
    private String lastText = "";
    private DefaultListModel model;
    private Project project;
    private TypeRef typeRef;
    private TextField userDataText;

    public FindComponentDialog(UiWindow parent, Project project) {
        super(parent, DesignerMsg.LOOKING_FOR_COMPONENTS, true);
        this.project = project;
        this.init();
    }

    public String getQualifiedName() {
        TypeRef tRef = (TypeRef)this.componentsList.getSelectedValue();
        if (tRef != null) {
            return tRef.getText();
        }
        return "";
    }

    public TypeRef getSelectedType() {
        return this.typeRef;
    }

    public void accept() {
        if (!Str.isEmpty(this.userDataText.getText()) && this.componentsList.getSelectedValue() != null) {
            this.close();
        }
    }

    public void actionPerformed(ActionEvent event) {
        this.setVisible(false);
        this.dispose();
    }

    public void valueChanged(ListSelectionEvent e) {
    }

    void init() {
        if (this.project == null) {
            this.project = RepositoryService.getInstance().getActiveRepository().getDefaultProject();
        }
        this.getContentPane().setLayout((Layout)new BorderLayout());
        Panel userDataPanel = new Panel(this.getContentPane());
        userDataPanel.setLayout((Layout)new BoxLayout((UiContainer)userDataPanel, 1));
        Panel titlePanel = new Panel((UiContainer)userDataPanel);
        titlePanel.setLayout((Layout)new BoxLayout((UiContainer)titlePanel, 0));
        Label userDataLabel = Label.create((UiContainer)titlePanel, (Msg)DesignerMsg.ENTER_COMPONENT_NAME);
        this.includeDefComponents = CheckBox.create((UiContainer)titlePanel, (Msg)DesignerMsg.INCLUDE_DEFAULT_COMPONENTS);
        this.includeDefComponents.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindComponentDialog.this.userDataText.requestFocus();
                FindComponentDialog.this.lastText = null;
                FindComponentDialog.this.updateComponentsList(true);
            }
        });
        titlePanel.add((UiComponent)userDataLabel);
        titlePanel.add((UiComponent)this.includeDefComponents);
        this.includeDefComponents.setEnabled(false);
        this.includeDefComponents.setEnabled(true);
        this.userDataText = new TextField((UiContainer)userDataPanel, 40);
        this.userDataText.setForeground(Color.BLACK);
        this.userDataText.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.isAnyDown()) {
                    FindComponentDialog.this.componentsList.processKeyEvent(e);
                } else if (e.isEnter()) {
                    FindComponentDialog.this.accepted();
                } else {
                    UiUtilities.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            FindComponentDialog.this.updateComponentsList(false);
                        }
                    });
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        userDataPanel.add((UiComponent)titlePanel);
        userDataPanel.add((UiComponent)this.userDataText);
        userDataPanel.add(Box.createRigidArea((UiContainer)userDataPanel, (Dimension)Dimension.valueOf(0, 5)));
        this.model = new DefaultListModel();
        this.componentsList = new ComponentList(this.getContentPane(), this.model, ListSelectionMode.SINGLE_SELECTION);
        this.componentsList.addListSelectionListener(this);
        this.componentsList.setVisibleRowCount(10);
        this.componentsList.setLabelProvider((LabelProvider)new TypeLabelProvider());
        this.componentsList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClicked(MouseEvent e) {
                FindComponentDialog.this.accepted();
            }
        });
        this.componentsList.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.isEnter()) {
                    FindComponentDialog.this.accepted();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.componentsList.setBorder(BorderFactory.createCompoundBorder((Border)BorderFactory.createEmptyBorder((int)3, (int)6, (int)6, (int)6), (Border)BorderFactory.createEtchedBorder()));
        this.componentsList.setVisible(false);
        this.getContentPane().add((UiComponent)userDataPanel, (Object)"North");
        this.getContentPane().add((UiComponent)this.componentsList, (Object)"Center");
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
        this.userDataText.requestFocus();
    }

    private void accepted() {
        this.typeRef = (TypeRef)this.componentsList.getSelectedValue();
        this.setUserAccepted(true);
        this.close();
    }

    private boolean setTypes(SortedMap<String, ? extends TypeRef> types) {
        this.model.removeAllElements();
        for (TypeRef typeRef : types.values()) {
            if (typeRef.get().isSynthesized()) continue;
            this.model.addElement(typeRef);
        }
        return this.model.getSize() != 0;
    }

    private void markNotFound() {
        this.userDataText.setForeground(Color.RED);
        this.componentsList.setVisible(false);
        this.pack();
    }

    private void updateComponentsList(boolean force) {
        if (!this.userDataText.hasFocus() && !force) {
            return;
        }
        String text = this.userDataText.getText();
        if (Str.isEmpty(text)) {
            this.model.clear();
            this.componentsList.removeAll();
        } else if (!text.equals(this.lastText) || force) {
            this.lastText = text;
            if (this.updateListModel(text)) {
                this.componentsList.setSelectedIndex(0);
                this.componentsList.ensureIndexIsVisible(0);
                UiUtilities.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FindComponentDialog.this.componentsList.setVisible(true);
                        FindComponentDialog.this.pack();
                    }
                });
            } else {
                this.markNotFound();
            }
        }
    }

    private boolean updateListModel(String text) {
        if (Str.isEmpty(text)) {
            this.model.removeAllElements();
            return false;
        }
        SortedMap<String, ? extends TypeRef> types = this.project.getComponentCatalog().findByPartialName(text, this.includeDefComponents.isSelected());
        if (types != null && !types.isEmpty()) {
            this.userDataText.setForeground(Color.BLACK);
            return this.setTypes(types);
        }
        this.model.removeAllElements();
        return false;
    }

    private static class ComponentList
    extends List {
        public ComponentList(UiContainer parent, DefaultListModel model) {
            super(parent, (ListModel)model);
            this.setFocusable(false);
        }

        public ComponentList(UiContainer parent, DefaultListModel model, ListSelectionMode selectionMode) {
            super(parent, (ListModel)model, selectionMode);
            this.setFocusable(false);
        }

        public void processKeyEvent(KeyEvent e) {
            if (this.getModel().getSize() > 0 && this.isVisible()) {
                if (e.isUp()) {
                    this.selectPrevious();
                } else if (e.isDown()) {
                    this.selectNext();
                }
            }
        }
    }
}

