/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.List;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.ExceptionHandlingType;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.preferences.ProjectPreferencesImpl;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Constraint;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;

class ExceptionHandlingPreferencesPanel
extends Panel {
    private CardLayout cardLayout;
    private boolean dirty;
    private ComboBox exceptionHandlingTypeCombo;
    private CheckBox generateInteractiveRoleCheckBox;
    private ComboBox interactiveRolesCombo;
    private ProjectPreferencesImpl preferences;
    private Project project;

    public ExceptionHandlingPreferencesPanel(UiContainer parent, Project project) {
        super(parent, DesignerMsg.EXCEPTION_HANDLING);
        this.project = project;
        this.build();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.interactiveRolesCombo.setEnabled(enabled);
        this.exceptionHandlingTypeCombo.setEnabled(enabled);
        this.generateInteractiveRoleCheckBox.setEnabled(enabled);
    }

    public void toPreferences() {
        Object roleId = this.interactiveRolesCombo.getSelectedItem();
        this.preferences.setInteractiveRole(roleId != null ? roleId.toString() : "");
        this.preferences.setGeneratesInteractiveRole(this.generateInteractiveRoleCheckBox.isSelected());
        this.preferences.setExceptionHandlingType((ExceptionHandlingType)this.exceptionHandlingTypeCombo.getSelectedItem());
    }

    private void addListeners() {
        this.interactiveRolesCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ExceptionHandlingPreferencesPanel.this.setDirty(true);
            }
        });
        this.exceptionHandlingTypeCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ExceptionHandlingPreferencesPanel.this.setDirty(true);
            }
        });
        this.generateInteractiveRoleCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ExceptionHandlingPreferencesPanel.this.setDirty(true);
            }
        });
    }

    private void build() {
        this.preferences = (ProjectPreferencesImpl)this.project.getPreferences();
        this.exceptionHandlingTypeCombo = UiFactory.createComboBox((UiContainer)this, (Object[])ExceptionHandlingType.values());
        this.cardLayout = new CardLayout();
        final Panel cardPanel = new Panel((UiContainer)this);
        cardPanel.setLayout((Layout)this.cardLayout);
        this.exceptionHandlingTypeCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ExceptionHandlingType selectedItem = (ExceptionHandlingType)ExceptionHandlingPreferencesPanel.this.exceptionHandlingTypeCombo.getSelectedItem();
                if (selectedItem != null) {
                    ExceptionHandlingPreferencesPanel.this.cardLayout.show((UiContainer)cardPanel, selectedItem.name());
                }
            }
        });
        cardPanel.add((UiComponent)this.buildEmptyPanel((UiContainer)cardPanel), (Object)"empty");
        cardPanel.add((UiComponent)this.buildIgnoreExceptionsPanel((UiContainer)cardPanel), (Object)ExceptionHandlingType.PROPAGATE.name());
        cardPanel.add((UiComponent)this.buildHandleExceptionPanel((UiContainer)cardPanel), (Object)ExceptionHandlingType.HANDLE_EXCEPTIONS.name());
        ExceptionHandlingType selectedItem = (ExceptionHandlingType)this.exceptionHandlingTypeCombo.getSelectedItem();
        if (selectedItem != null) {
            this.cardLayout.show((UiContainer)cardPanel, selectedItem.name());
        }
        this.exceptionHandlingTypeCombo.setSelectedItem((Object)this.preferences.getExceptionHandlingType());
        if (this.preferences.getExceptionHandlingType() == null) {
            this.cardLayout.show((UiContainer)cardPanel, "empty");
        }
        RelativeLayout relativeLayout = new RelativeLayout();
        this.setLayout((Layout)relativeLayout);
        LabelMultiline descTextArea = new LabelMultiline((UiContainer)this, DesignerMsg.EXCEPTION_HANDLING_POLICY_DESC);
        this.add((UiComponent)descTextArea, "desc");
        this.add((UiComponent)this.exceptionHandlingTypeCombo, "exCombo");
        this.add((UiComponent)cardPanel, "cardPanel");
        oracle.bpm.ui.utils.Layout.fixTopDown((RelativeLayout)relativeLayout, (String[])new String[]{"desc", "exCombo", "cardPanel"});
        this.addListeners();
    }

    private Panel buildEmptyPanel(UiContainer parent) {
        return new Panel(parent);
    }

    private Panel buildHandleExceptionPanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        RelativeLayout relativeLayout = new RelativeLayout();
        panel.setLayout((Layout)relativeLayout);
        LabelMultiline descTextArea = new LabelMultiline((UiContainer)panel, DesignerMsg.HANDLE_EXCEPTION_DSC);
        LabelMultiline generateRoleTextArea = new LabelMultiline((UiContainer)panel, DesignerMsg.GENERATE_ROLE);
        StringList roles = StringList.create();
        for (Role role : this.project.getOrganization().getRoles()) {
            roles.add(role.getId());
        }
        this.interactiveRolesCombo = UiFactory.createComboBox((UiContainer)panel, (List)roles.sort());
        this.interactiveRolesCombo.setSelectedItem((Object)this.preferences.getInteractiveRole());
        this.generateInteractiveRoleCheckBox = new CheckBox((UiContainer)panel);
        this.generateInteractiveRoleCheckBox.setSelected(this.preferences.getGeneratesInteractiveRole());
        this.generateInteractiveRoleCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ExceptionHandlingPreferencesPanel.this.updateRoleCombo();
            }
        });
        this.updateRoleCombo();
        panel.add((UiComponent)descTextArea, (Object)"desc");
        panel.add((UiComponent)this.generateInteractiveRoleCheckBox, (Object)"checkBox");
        panel.add((UiComponent)generateRoleTextArea, (Object)"roleDesc");
        panel.add((UiComponent)this.interactiveRolesCombo, (Object)"roleCombo");
        relativeLayout.addConstraint("desc", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 2));
        relativeLayout.addConstraint("desc", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 2));
        relativeLayout.addConstraint("desc", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT, -2));
        relativeLayout.addConstraint("checkBox", AttributeType.TOP, (Constraint)new AttributeConstraint("desc", AttributeType.BOTTOM, 10));
        relativeLayout.addConstraint("checkBox", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        relativeLayout.addConstraint("roleDesc", AttributeType.TOP, (Constraint)new AttributeConstraint("checkBox", AttributeType.TOP, 2));
        relativeLayout.addConstraint("roleDesc", AttributeType.LEFT, (Constraint)new AttributeConstraint("checkBox", AttributeType.RIGHT, 2));
        relativeLayout.addConstraint("roleDesc", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT));
        relativeLayout.addConstraint("roleCombo", AttributeType.TOP, (Constraint)new AttributeConstraint("roleDesc", AttributeType.BOTTOM, 4));
        relativeLayout.addConstraint("roleCombo", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 2));
        relativeLayout.addConstraint("roleCombo", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT, -2));
        if (roles.isEmpty()) {
            this.generateInteractiveRoleCheckBox.setEnabled(false);
            this.interactiveRolesCombo.setEnabled(false);
        }
        return panel;
    }

    private Panel buildIgnoreExceptionsPanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        RelativeLayout relativeLayout = new RelativeLayout();
        panel.setLayout((Layout)relativeLayout);
        LabelMultiline descTextArea = new LabelMultiline((UiContainer)panel, DesignerMsg.IGNORE_EXCEPTIONS_DSC);
        panel.add((UiComponent)descTextArea, (Object)"desc");
        relativeLayout.addConstraint("desc", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 2));
        relativeLayout.addConstraint("desc", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 2));
        relativeLayout.addConstraint("desc", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT, -2));
        return panel;
    }

    private void updateRoleCombo() {
        if (this.generateInteractiveRoleCheckBox.isSelected()) {
            this.interactiveRolesCombo.setEnabled(true);
        } else {
            this.interactiveRolesCombo.setEnabled(false);
        }
    }
}

