/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.FlowFigureTypeRibbonItem;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureTypeProvider;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.RibbonItem;
import oracle.bpm.ui.RibbonSectionMultiple;
import oracle.bpm.ui.UiContainer;

public class EventRibbonSection
extends RibbonSectionMultiple {
    private RibbonItem defaultItem;
    private ProcessDomain domain;

    public EventRibbonSection(UiContainer parent, ProcessDomain domain) {
        super(parent);
        this.domain = domain;
        super.loadSection();
    }

    public Sequence<RibbonItem> loadItems() {
        ArrayList<FlowFigureTypeRibbonItem> list = new ArrayList<FlowFigureTypeRibbonItem>();
        for (FlowFigureType flowFigureType : FlowFigureTypeProvider.getNonDefaultCatchEvents()) {
            FlowFigureTypeRibbonItem item = this.domain == null ? new FlowFigureTypeRibbonItem(null, flowFigureType) : new FlowFigureTypeRibbonItem(this.domain.getStateManager(), flowFigureType);
            if (flowFigureType.getType().equals((Object)BpmnType.CATCH_INTERMEDIATE_EVENT)) {
                this.defaultItem = item;
            }
            list.add(item);
        }
        return CollectionUtils.asSequence(list);
    }

    public Msg getTitle() {
        return DesignerMsg.TEXT_RIBBON_EVENTS_LABEL;
    }

    public RibbonItem getDefault() {
        if (this.defaultItem == null) {
            throw new ExceptionInInitializerError();
        }
        return this.defaultItem;
    }

    public void setDefault(RibbonItem defaultItem) {
        this.defaultItem = defaultItem;
    }
}

