/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bpm.adapter.AdapterService;
import oracle.bpm.cil.CilException;
import oracle.bpm.cil.MessageListener;
import oracle.bpm.compiler.CodeDebugger;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.designer.context.QuerySource;
import oracle.bpm.designer.context.StudioContext;
import oracle.bpm.editor.CodeFixHandler;
import oracle.bpm.lang.Platform;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.compile.CompilationError;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.ProjectException;

public class ErrorList
implements ProjectMessageListener,
MessageListener,
CodeDebugger.ErrorListener {
    private CodeFixHandler fixHandler;
    private boolean hasErrors = false;
    private boolean hasWarnings = false;
    private ArrayList<CompilationError> list = null;
    private QuerySource querySource;

    public ErrorList() {
    }

    public ErrorList(StudioContext designerContent) {
    }

    public boolean isEmpty() {
        return this.list == null || this.list.isEmpty();
    }

    public void setFixHandler(CodeFixHandler fixHandler) {
        this.fixHandler = fixHandler;
    }

    public CodeFixHandler getFixHandler() {
        return this.fixHandler;
    }

    public List<CompilationError> getList() {
        if (this.list != null) {
            return this.list;
        }
        return Collections.emptyList();
    }

    public void setQuerySource(QuerySource querySource) {
        this.querySource = querySource;
    }

    public QuerySource getQuerySource() {
        return this.querySource;
    }

    public void clear() {
        if (this.list != null) {
            this.list.clear();
        }
        this.hasErrors = false;
        this.hasWarnings = false;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public boolean hasWarnings() {
        return this.hasWarnings;
    }

    public void report(Object source, Exception msg, boolean warning) {
        CompilationError compilationError = new CompilationError();
        if (source == null) {
            return;
        }
        if (source instanceof ProjectObject) {
            compilationError.setSource((ProjectObject)source);
        }
        compilationError.setType(warning ? CoreMsg.WARNING : CoreMsg.ERROR);
        compilationError.setException(msg);
        if (warning && !this.hasWarnings) {
            this.hasWarnings = warning;
        }
        if (!warning && !this.hasErrors) {
            boolean bl = this.hasErrors = !warning;
        }
        if (this.list == null) {
            this.list = new ArrayList();
        }
        this.list.add(compilationError);
    }

    @Override
    public void reportError(CilException e) {
        CompilationError compilationError = new CompilationError();
        AdapterService adapterService = Platform.getAdapterService();
        ProjectObject querySource = adapterService.adaptTo(e.getMember(), ProjectObject.class);
        compilationError.setType(CoreMsg.ERROR);
        compilationError.setException((Exception)e);
        this.hasErrors = true;
        if (this.list == null) {
            this.list = new ArrayList();
        }
        this.list.add(compilationError);
    }

    public void reportError(ProjectObject source, ProjectException e) {
        this.report(source, (Exception)((Object)e), false);
    }

    public void reportException(ExecutionException e) {
    }

    @Override
    public void reportWarning(CilException e) {
        String msg = e.getMessage();
        if (msg.toLowerCase().indexOf("exception") != -1 && msg.toLowerCase().indexOf("autodeclared") != -1) {
            return;
        }
        CompilationError compilationError = new CompilationError();
        compilationError.setType(CoreMsg.WARNING);
        compilationError.setException((Exception)e);
        if (!this.hasWarnings) {
            this.hasWarnings = true;
        }
        if (this.list == null) {
            this.list = new ArrayList();
        }
        this.list.add(compilationError);
    }

    public void reportWarning(ProjectObject source, ProjectException e) {
        this.report(source, (Exception)((Object)e), true);
    }
}

