/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.command.Command;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.ZoomInAction;
import oracle.bpm.designer.ZoomOutAction;
import oracle.bpm.designer.action.RemoveObjectsAction;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.designer.selection.SelectionUtils;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.Domain;
import oracle.bpm.diagram.editor.DomainStateManager;
import oracle.bpm.diagram.editor.state.AbstractDesignerState;
import oracle.bpm.diagram.editor.state.PointerState;
import oracle.bpm.project.command.design.CopyPasteHelper;
import oracle.bpm.project.model.features.ViewScaleFeature;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.ui.ModelObjectSelection;
import oracle.bpm.ui.selection.Selection;
import org.jetbrains.annotations.NotNull;

public class DesignerStateManager
extends DomainStateManager {
    public DesignerStateManager(@NotNull ProcessDomain domain) {
        super((Domain)domain);
    }

    public ProcessDomain getDomain() {
        return (ProcessDomain)super.getDomain();
    }

    public void setDefaultState() {
        this.setCurrentState((AbstractDesignerState)new PointerState(){

            protected List<Controller> filterSelection(List<Controller> controllers) {
                Collection<FlowElement> normalized = new ArrayList();
                List result = super.filterSelection(controllers);
                boolean hasSubflow = false;
                for (Controller next : result) {
                    Object object = next.getModelObject();
                    if (!(object instanceof FlowElement)) continue;
                    FlowElement object1 = (FlowElement)object;
                    normalized.add(object1);
                    if (!(object instanceof FlowNode) || !ModelUtils.isSubprocess((FlowNode)((FlowNode)object))) continue;
                    hasSubflow = true;
                }
                if (hasSubflow) {
                    normalized = CopyPasteHelper.normalizeForCut(normalized);
                    Iterator it = result.iterator();
                    while (it.hasNext()) {
                        Controller next;
                        next = (Controller)it.next();
                        if (normalized.contains(next.getModelObject())) continue;
                        it.remove();
                    }
                }
                return result;
            }
        });
    }

    public void deletePressed() {
        ModelObjectSelection selection = SelectionUtils.asModelObjectSelection(this.getSelection());
        if (!selection.isEmpty()) {
            RemoveObjectsAction objectsAction = new RemoveObjectsAction();
            objectsAction.runWithSelection((Selection)selection);
            this.getDomain().getSelectionProvider().clear();
        }
    }

    public float zoomOut() {
        new ZoomOutAction(this.getDomain()).run();
        return ((ViewScaleFeature)this.getDomain().getDomainElement().getFeature(ViewScaleFeature.class)).getValue().floatValue();
    }

    public float zoomIn() {
        new ZoomInAction(this.getDomain()).run();
        return ((ViewScaleFeature)this.getDomain().getDomainElement().getFeature(ViewScaleFeature.class)).getValue().floatValue();
    }

    public void scaleChanged() {
        DesignerPreferences preferences = DesignerPreferences.getPreferences();
        preferences.setGridSize((Integer)this.getDomain().getGrid().getSize().get());
        preferences.store();
    }

    public void runCommand(@NotNull Command command) {
        ActionRunner.getInstance().run(command);
    }

    public boolean isSimulating() {
        return AbstractStudioWorkbench.getInstance().isSimulating();
    }

    private Selection getSelection() {
        return this.getDomain().getSelectionProvider().getSelection();
    }
}

