/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.BpaService;
import oracle.bpm.designer.DesignerMode;
import oracle.bpm.designer.ProcessUsagesAction;
import oracle.bpm.designer.action.ProcessReportAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.extensionpoint.metadata.ActionGroupMetadata;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.ActionGroupFactory;
import oracle.bpm.ui.action.BaseAction;

@ActionGroupMetadata(target=Process.class)
public class DesignerProcessActions
implements ActionGroupFactory {
    private static List<BaseAction> convertActions = new ArrayList<BaseAction>();

    public static void addConvertAction(BaseAction action) {
        convertActions.add(action);
    }

    public ActionGroup create(Adaptable context) {
        ActionGroup result = new ActionGroup(DesignerMsg.EDIT, DesignerMode.getCurrentMode().getActionValidator());
        if (!convertActions.isEmpty()) {
            result.addSeparator();
            ActionGroup exportActionsGroup = new ActionGroup(DesignerMsg.CONVERT);
            for (BaseAction exportAction : convertActions) {
                exportActionsGroup.add(exportAction);
            }
            result.add((BaseAction)exportActionsGroup);
        }
        result.add((BaseAction)new ProcessReportAction());
        BpaService service = AbstractStudioWorkbench.getInstance().getBpaService();
        if (service != null) {
            BaseAction action = service.createBpaRefreshAction();
            result.add(action);
        }
        result.add((BaseAction)new ProcessUsagesAction());
        return result;
    }
}

