/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JFrame;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.AppInfo;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.DesignerInitializer;
import oracle.bpm.designer.Initializer;
import oracle.bpm.designer.StudioApplicationInfo;
import oracle.bpm.designer.StudioGlassPane;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.BoolMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AboutDialog;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Splash;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.Utilities;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.tips.TipOfTheDayFactory;
import oracle.bpm.ui.toolbar.CustomToolBar;
import oracle.bpm.util.CommonPreferences;
import oracle.bpm.util.Locales;

public class DesignerApplication
extends Frame {
    private List<DesignerAction> afterVisibleActions = new ArrayList<DesignerAction>();
    private StudioGlassPane glassPane;
    private Initializer initializer;
    private boolean setupCompleted;
    private static final Image ABOUT_ICON = Image.create((Msg)UIMsg.SPLASH);
    private static final String UPDATE_DISABLED = "fuego.update.disabled";
    private static final int DO_NOT_CHECK = 0;
    private static final int SILENT_CHECK = 1;
    private static final int CHECK = 2;
    private static DesignerApplication instance;
    private static boolean isMainApplication;

    public DesignerApplication(StringList arguments, Splash splash) {
        this(DesignerMsg.FRAME_TITLE(""), arguments, splash);
    }

    public DesignerApplication(Msg title, StringList arguments, Splash splash) {
        super(title, false, splash);
        assert (Ui.isSwing()) : "DesignerApplication only in Swing";
        instance = this;
        isMainApplication = true;
        Utilities.setSharedOwnerFrame((Frame)this);
        if (AppInfo.getCurrent() == null) {
            AppInfo.setCurrent(new StudioApplicationInfo());
        }
        this.registerFileSystemStore();
    }

    private DesignerApplication() {
        super(DesignerMsg.FRAME_TITLE(""), false, null);
        instance = this;
        Initializer ini = this.getInitializer();
        ini.register();
        DesignerPreferences.setPreferences(ini.loadPreferences());
        AbstractStudioWorkbench.setEnvironment(ini.createEnvironment());
        Utilities.setSharedOwnerFrame((Frame)this);
    }

    public static DesignerApplication getInstance() {
        if (instance == null) {
            try {
                instance = new DesignerApplication();
            }
            catch (RuntimeException e) {
                instance = null;
                throw e;
            }
        }
        return instance;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public static boolean isMainApplication() {
        return isMainApplication;
    }

    public void closeApplication() {
        System.exit(0);
    }

    public boolean isSetUpCompleted() {
        return this.setupCompleted;
    }

    public void setShowSplash(boolean show) {
        this.showSplash = show;
    }

    public void setUpFinished() {
        if (!this.isSetUpCompleted()) {
            this.getSplash().endSplash();
            this.glassPane = new StudioGlassPane();
            JFrame frame = (JFrame)this.getNative();
            frame.setGlassPane(this.glassPane);
            this.setVisible(true);
            for (DesignerAction next : this.afterVisibleActions) {
                next.doIt();
            }
            this.afterVisibleActions.clear();
            this.setupCompleted = true;
            this.validate();
            if (CommonPreferences.getInstance().getShowTipsOnStartup()) {
                TipOfTheDayFactory.showTipsDialog((UiWindow)Ui.getRoot(), (Locale)Locales.getDefaultLocale(), (boolean)CommonPreferences.getInstance().getShowTipsOnStartup());
            }
        }
    }

    public Image getAboutMsg() {
        return ABOUT_ICON;
    }

    public void setTitlePart(String info) {
        this.setMsg(DesignerMsg.FRAME_TITLE(info));
    }

    public void enableUserInput(boolean enable) {
        if (this.glassPane != null) {
            this.glassPane.setVisible(!enable);
        }
    }

    public void openLastProject() {
        try {
            this.setUpFinished();
        }
        catch (Throwable t) {
            this.setUpFinished();
            MessageDialog.showError((Throwable)t);
        }
    }

    public void showAbout(Image aboutIcon) {
        AboutDialog aboutDialog = new AboutDialog((Frame)this, this.getAboutMsg());
        aboutDialog.setVisible(true);
    }

    public void showSplashWindow() {
        this.setShowSplash(true);
        this.showSplash();
    }

    public void translate() {
        super.translate();
    }

    protected Initializer getInitializer() {
        if (this.initializer == null) {
            this.initializer = this.createInitializer();
        }
        return this.initializer;
    }

    protected Initializer createInitializer() {
        return new DesignerInitializer();
    }

    protected ToolBar createToolBar() {
        final CustomToolBar toolBar = new CustomToolBar((UiContainer)this);
        if (toolBar.getNative() instanceof JComponent) {
            toolBar.asSwing().addPropertyChangeListener("oracle.bpm.toolbar.custom.actions", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    DesignerPreferences.getPreferences().setCustomToolBarActions(toolBar.getVisibleActionCodes());
                }
            });
        }
        return toolBar;
    }

    protected void hideSplash() {
    }

    protected void updateLocale() {
        super.updateLocale();
        Locales.setDefaultLocale(Locale.getDefault());
    }

    private static int mustCheckForUpdates(Msg appMsg) {
        int result = 0;
        if (!Boolean.getBoolean(UPDATE_DISABLED)) {
            CommonPreferences commonPrefs = CommonPreferences.getInstance();
            if (commonPrefs.getAutomaticallyCheckForUpdates()) {
                result = 1;
            } else if (commonPrefs.getShowCheckForUpdates()) {
                BoolMsg msg = new BoolMsg(false, CoreMsg.DO_NOT_SHOW_THIS_MESSAGE);
                boolean check = MessageDialog.showQuestion((UiContainer)null, (Msg)CoreMsg.WARNING, (Msg)DesignerMsg.CHECK_FOR_UPDATES_OPTION(appMsg), null, (int)6, (BoolMsg)msg) == 2;
                commonPrefs.setShowCheckForUpdates(!msg.value);
                if (msg.value) {
                    commonPrefs.setAutomaticallyCheckForUpdates(check);
                }
                commonPrefs.store();
                if (check) {
                    result = 2;
                }
            }
        }
        return result;
    }

    private void registerFileSystemStore() {
    }
}

