/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.Locale;
import javax.swing.Action;
import oracle.bpm.designer.Context;
import oracle.bpm.designer.DesignerMode;
import oracle.bpm.designer.StudioPreferencesDialog;
import oracle.bpm.designer.action.ClosePanelAction;
import oracle.bpm.designer.action.CloseProjectAction;
import oracle.bpm.designer.action.DelegateAction;
import oracle.bpm.designer.action.ExportProjectAction;
import oracle.bpm.designer.action.ImportObjectAction;
import oracle.bpm.designer.action.ImportProjectAction;
import oracle.bpm.designer.action.ModelActionSet;
import oracle.bpm.designer.action.ProjectPreferencesAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBoxMenuItem;
import oracle.bpm.ui.CustomFuegoAction;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.tips.TipOfTheDayFactory;
import oracle.bpm.ui.utils.FrameDecorators;
import oracle.bpm.util.CommonPreferences;
import oracle.bpm.util.Locales;

public class DesignerActions {
    public static BaseAction refreshAction;
    public static DelegateAction methodListAction;
    public static DelegateAction nextMemberAction;
    public static DelegateAction previousMemberAction;
    public static BaseAction showMessagesAction;
    private static boolean initialized;
    protected static BaseAction importEnumerationAction;
    protected static BaseAction importFuegoObjectAction;
    public static BaseAction pageDialogAction_d;
    public static BaseAction importProjectAction;
    protected static BaseAction exportProjectAction;
    protected static BaseAction showTipsDialog;
    protected static BaseAction optionsAction;
    public static CloseProjectAction closeProjectAction;
    public static DelegateAction cutAction;
    public static DelegateAction pasteAction;
    public static DelegateAction copyAction;
    protected static BaseAction projectPreferencesAction;
    public static DesignerActions instance;
    public static BaseAction closePanelAction_d;
    public static BaseAction fullScreenAction;

    public DesignerActions() {
        instance = this;
        this.setActions();
    }

    public static void setInitialized(boolean initialized) {
        DesignerActions.initialized = initialized;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setActions() {
        Class<DesignerActions> clazz = DesignerActions.class;
        synchronized (DesignerActions.class) {
            if (DesignerActions.isInitialized()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            DesignerActions.setInitialized(true);
            fullScreenAction = FrameDecorators.createDefaultFrameMaximizer((Frame)((Frame)Ui.getRoot()), (Msg)UIMsg.FULL_SCREEN);
            importEnumerationAction = ImportObjectAction.getImportEnumerationAction();
            importFuegoObjectAction = ImportObjectAction.getImportFuegoObjectAction();
            importProjectAction = new ImportProjectAction();
            refreshAction = new BaseAction(DesignerMsg.SYNCHRONIZE_PROJECT){

                public void run() {
                    try {
                        RepositoryService.getInstance().getActiveRepository().refresh(Context.getProject());
                    }
                    catch (ProjectException e) {
                        MessageDialog.showError((Throwable)e);
                    }
                }
            };
            optionsAction = new CustomFuegoAction(UIMsg.PREFERENCES){

                public void run() {
                    DesignerActions.this.optionsDialog();
                }
            };
            pageDialogAction_d.setEnabled(false);
            closePanelAction_d = new ClosePanelAction();
            closePanelAction_d.setEnabled(false);
            closeProjectAction = new CloseProjectAction();
            exportProjectAction = new ExportProjectAction();
            projectPreferencesAction = new ProjectPreferencesAction();
            cutAction = new DelegateAction(UIMsg.CUT);
            cutAction.setEnabled(false);
            copyAction = new DelegateAction(UIMsg.COPY);
            copyAction.setEnabled(false);
            pasteAction = new DelegateAction(UIMsg.PASTE);
            pasteAction.setEnabled(false);
            previousMemberAction = new DelegateAction(DesignerMsg.OPEN_PREVIOUS_MEMBER);
            nextMemberAction = new DelegateAction(DesignerMsg.OPEN_NEXT_MEMBER);
            methodListAction = new DelegateAction(DesignerMsg.CIL_LIST);
            DesignerMode.setVisibility((Action)((Object)methodListAction), 2);
            showMessagesAction = new ShowMessageAction(DesignerMsg.SHOWMESSAGE);
            showTipsDialog = new ShowTipsAction(DesignerMsg.TIPS);
            ModelActionSet.get();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void optionsDialog() {
        StudioPreferencesDialog dialog = new StudioPreferencesDialog(Ui.getRoot());
        dialog.setVisible(true);
        this.updatePreferences();
    }

    private void updatePreferences() {
    }

    private static final class ShowTipsAction
    extends BaseAction {
        private ShowTipsAction(Msg msg) {
            super(msg);
        }

        public void run() {
            TipOfTheDayFactory.showTipsDialog((UiWindow)Ui.getRoot(), (Locale)Locales.getDefaultLocale(), (boolean)CommonPreferences.getInstance().getShowTipsOnStartup());
        }
    }

    private static final class ShowMessageAction
    extends BaseAction {
        private ShowMessageAction(Msg msg) {
            super(msg);
        }

        public void actionPerformed(ActionEvent e) {
            CheckBoxMenuItem item = (CheckBoxMenuItem)e.getSource();
            Context.showMessages(item.isSelected());
        }
    }
}

