/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import oracle.bpm.collections.Sequence;
import oracle.bpm.command.Command;
import oracle.bpm.designer.ActivityCloner;
import oracle.bpm.designer.DesignerUtils;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.AddLaneCommand;
import oracle.bpm.project.command.design.AddTransitionCommand;
import oracle.bpm.project.command.design.ChangeTransitionTargetCommand;
import oracle.bpm.project.command.design.InsertLaneCommand;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.activities.NodeAssociationFeature;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.ui.ModelObjectSelection;

public class DesignPaste {
    private boolean connectToFlow;
    private FlowNode firstNode;
    private FlowNode lastNode;
    private HashMap<String, ActivityPasteInfo> pastedActivities = new HashMap();
    private TreeMap<Integer, LanePasteInfo> pastedLanes = new TreeMap();
    private ModelObjectSelection selection;
    private Point targetLocation;
    private Process targetModel;

    public DesignPaste(Process targetProcess, Point targetLocation, ModelObjectSelection selectionRectangle) {
        this.targetModel = targetProcess;
        this.targetLocation = targetLocation;
        this.selection = selectionRectangle;
        this.build();
    }

    public Process getTargetModel() {
        return this.targetModel;
    }

    public MultipleCommand getCommand() {
        SequenceFlow closestTransition;
        MultipleCommand multipleCommand = new MultipleCommand(new ProjectObject[0]){

            public String getName() {
                return DesignerMsg.PASTE.getString();
            }

            public ProjectObject getAffectedObject() {
                return DesignPaste.this.targetModel;
            }
        };
        Collection<LanePasteInfo> lanePasteInfos = this.pastedLanes.values();
        Point location = this.targetLocation;
        boolean first = true;
        for (LanePasteInfo lanePasteInfo : lanePasteInfos) {
            Lane lane = lanePasteInfo.getLane();
            int width = LaneUtils.calculateMinimunLaneSize((Lane)lane, (int)lane.getSize());
            if (first) {
                multipleCommand.addCommand((Command)new InsertLaneCommand(this.targetModel, lane.getRole(), lane.getBackgroundColor(), location.getX(), width));
                first = false;
            } else {
                multipleCommand.addCommand((Command)new AddLaneCommand(this.targetModel, lane.getRole(), lane.getBackgroundColor(), location.getX(), width));
            }
            ArrayList<ActivityPasteInfo> list = lanePasteInfo.getActivities();
            for (ActivityPasteInfo activityPasteInfo : list) {
                ActivityCloner activityCloner = activityPasteInfo.getActivityCloner();
                multipleCommand.addCommand(activityCloner.getPasteCommand(new Point(location.getX() + activityPasteInfo.getRelativeLocation().getX(), activityPasteInfo.getRelativeLocation().getY())));
            }
            location = new Point(location.getX() + width, 0);
        }
        if (this.connectToFlow && (closestTransition = ModelUtils.getClosestTransition((Process)this.targetModel, (int)this.targetLocation.getX(), (int)this.targetLocation.getY())) != null) {
            FlowNode to = closestTransition.getTarget();
            if (this.firstNode != null && ModelUtils.shouldHaveIncomingSequenceFlow((FlowNode)this.firstNode)) {
                multipleCommand.addCommand((Command)new ChangeTransitionTargetCommand(closestTransition, this.firstNode));
            }
            if (this.lastNode != null && ModelUtils.shouldHaveOutgoingSequenceFlow((FlowNode)this.lastNode)) {
                multipleCommand.addCommand((Command)new AddTransitionCommand(this.lastNode.getParentObject(), this.lastNode, to));
            }
        }
        return multipleCommand;
    }

    public void setConnectToFlow(boolean connectToFlow) {
        this.connectToFlow = connectToFlow;
    }

    private void build() {
        this.addActivitiesAndLanes();
        this.setFirstAndLastActivities();
        this.addTransitions();
    }

    private void addActivitiesAndLanes() {
        List<FlowElement> list = this.getAllActivities();
        for (FlowElement node : new ArrayList<FlowElement>(list)) {
            if (!node.is(FlowNode.class)) continue;
            FlowNode flowNode = (FlowNode)node;
            this.addActivity(flowNode);
        }
    }

    private void addActivity(FlowNode node) {
        String relatedActivityId;
        ActivityPasteInfo relatedAct;
        ActivityCloner clonedActivity = new ActivityCloner(node, node.copy());
        Lane lane = node.getLane();
        Point relativeLocation = new Point(node.getX() - lane.getOffset(), node.getY());
        LanePasteInfo info = this.pastedLanes.get(lane.getOffset());
        if (info == null) {
            info = new LanePasteInfo(lane);
            this.pastedLanes.put(lane.getOffset(), info);
        }
        ActivityPasteInfo pasteInfo = new ActivityPasteInfo(clonedActivity, relativeLocation, lane.getRole());
        this.pastedActivities.put(node.getId(), pasteInfo);
        NodeAssociationFeature feature = (NodeAssociationFeature)clonedActivity.getTargetActivity().getFeature(NodeAssociationFeature.class);
        if (feature != null && (relatedAct = this.pastedActivities.get(relatedActivityId = feature.getValue())) != null) {
            ((NodeAssociationFeature)relatedAct.getActivityCloner().getTargetActivity().getFeature(NodeAssociationFeature.class)).setValue(clonedActivity.getTargetActivity().getId());
            feature.setValue(relatedAct.getActivityCloner().getTargetActivity().getId());
        }
        info.addActivity(pasteInfo);
    }

    private List<FlowElement> getAllActivities() {
        ArrayList<FlowElement> result = new ArrayList<FlowElement>();
        for (FlowElement modelObject : this.selection) {
            result.add(modelObject);
        }
        return result;
    }

    private void addTransitions() {
        Sequence transitions = this.selection.getTransitions((Collection)this.selection.getObjects());
        for (SequenceFlow transition : transitions) {
            ActivityPasteInfo from = this.pastedActivities.get(transition.getSource().getId());
            ActivityPasteInfo to = this.pastedActivities.get(transition.getTarget().getId());
        }
    }

    private void setFirstAndLastActivities() {
        FlowNode first = DesignerUtils.getFirstActivity(this.selection);
        FlowNode last = DesignerUtils.getLastActivity(this.selection);
        this.firstNode = first != null ? this.pastedActivities.get(first.getId()).getActivityCloner().getTargetActivity() : null;
        this.lastNode = last != null ? this.pastedActivities.get(last.getId()).getActivityCloner().getTargetActivity() : null;
    }

    static class LanePasteInfo {
        private ArrayList<ActivityPasteInfo> activities = new ArrayList();
        private Lane lane;

        public LanePasteInfo(Lane lane) {
            this.lane = lane;
        }

        public ArrayList<ActivityPasteInfo> getActivities() {
            return this.activities;
        }

        public Lane getLane() {
            return this.lane;
        }

        public void addActivity(ActivityPasteInfo pasteInfo) {
            this.activities.add(pasteInfo);
        }
    }

    static class ActivityPasteInfo {
        private ActivityCloner activityCloner;
        private String lane;
        private Point relativeLocation;

        public ActivityPasteInfo(ActivityCloner activityCloner, Point relativeLocation, String lane) {
            this.activityCloner = activityCloner;
            this.relativeLocation = relativeLocation;
            this.lane = lane;
        }

        public ActivityCloner getActivityCloner() {
            return this.activityCloner;
        }

        public Point getRelativeLocation() {
            return this.relativeLocation;
        }

        public String getLane() {
            return this.lane;
        }
    }
}

