/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.command.Command;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.CopyPasteHelper;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Positional;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.ui.msg.UIMsg;

public class Clipboard {
    private DesignerHelper helper;
    private final List<ClipboardListener> listeners = new ArrayList<ClipboardListener>();
    private Collection<FlowElement> objects = new ArrayList<FlowElement>();
    private static Clipboard instance;

    private Clipboard() {
    }

    public static Clipboard getInstance() {
        if (instance == null) {
            instance = new Clipboard();
        }
        return instance;
    }

    public boolean isEmpty() {
        return this.objects == null || this.objects.isEmpty();
    }

    public Collection<FlowElement> getObjects() {
        return this.objects;
    }

    public void setObjects(Collection<FlowElement> collection) {
        this.objects = collection;
        this.helper = new DesignerHelper();
        this.helper.setProcess((NodeContainer)collection.iterator().next().getProcess());
        this.helper.copyElements(collection);
        this.notifyChange();
    }

    public boolean contains(Positional object) {
        return this.objects.contains(object);
    }

    public int size() {
        return this.objects != null ? this.objects.size() : 0;
    }

    public String toString() {
        return "Clipboard: " + this.objects;
    }

    public boolean canPaste() {
        return !this.isEmpty();
    }

    public void clear() {
        this.objects.clear();
        this.notifyChange();
    }

    public void addClipboardListener(ClipboardListener listener) {
        this.listeners.add(listener);
    }

    public void removeClipboardListener(ClipboardListener listener) {
        this.listeners.remove(listener);
    }

    public Command getPasteNodesCommand(final Process destinationContent, final Point destination) {
        return new Command(){
            public MultipleCommand unDoCommand;

            @Override
            public String getName() {
                return UIMsg.PASTE.toString();
            }

            @Override
            public Object getAffectedObject() {
                return destinationContent;
            }

            @Override
            public void undo() {
                this.unDoCommand.undo();
            }

            @Override
            public Object execute() throws ExecutionException {
                Clipboard.this.helper.setProcess((NodeContainer)destinationContent);
                Clipboard.this.helper.pasteElements(null, destination);
                this.unDoCommand = Clipboard.this.helper.command;
                return null;
            }
        };
    }

    private boolean containsActivities() {
        if (this.objects != null) {
            for (FlowElement modelObject : this.objects) {
                if (!(modelObject instanceof FlowNode)) continue;
                return true;
            }
        }
        return false;
    }

    private void notifyChange() {
        for (ClipboardListener listener : this.listeners) {
            listener.clipboardChanged();
        }
    }

    private static class DesignerHelper
    extends CopyPasteHelper {
        private MultipleCommand command;
        private NodeContainer process;

        private DesignerHelper() {
        }

        public void setProcess(NodeContainer process) {
            this.process = process;
        }

        protected void addExecutedCommand(MultipleCommand pasteCommand) {
            this.command = pasteCommand;
        }

        protected void addErrorMessage(Exception e) {
        }

        protected NodeContainer getCurrentProcess() {
            return this.process;
        }

        protected void syncWithClient(List<FlowNode> realCopiedElements, List<SequenceFlow> newTransitions, List<SequenceFlow> reconnections, List<Lane> newLanes, List<TextAnnotation> textAnnotations, List<Measurement> measurements) throws ProjectException {
        }
    }

    public static interface ClipboardListener {
        public void clipboardChanged();
    }
}

