/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.io.File;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.designer.ProcessPreviewer;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.geom.Insets;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.command.design.AddTransitionCommand;
import oracle.bpm.project.command.design.InsertActivityInTransitionCommand;
import oracle.bpm.project.io.fs.FileProjectRepository;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.algorithms.KoreanLayoutAlgorithm;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.ExclusiveGateway;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ReceiveTask;
import oracle.bpm.project.model.processes.ScriptTask;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiType;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;

public class AutoLayoutTester {
    private Process process;
    private Project project;

    public static void main(String[] args) throws ProjectException {
        AutoLayoutTester tester = new AutoLayoutTester();
        tester.initialize();
        tester.model();
        tester.preview();
    }

    private void model() {
        try {
            this.process = this.createNoneEventProcess();
            Role roleOne = this.project.getOrganization().createRole("Role Something One", "Role Something One");
            this.project.getOrganization().addChild((ProjectObject)roleOne);
            Lane one = this.process.createLane(roleOne.getId());
            one.setOffset(0);
            one.setSize(200);
            this.process.addChild((ProjectObject)one);
            Role roleTwo = this.project.getOrganization().createRole("Role Something Two", "Role Something Two");
            this.project.getOrganization().addChild((ProjectObject)roleTwo);
            Lane two = this.process.createLane(roleTwo.getId());
            two.setOffset(200);
            two.setSize(200);
            this.process.addChild((ProjectObject)two);
            UserTask userTwo = this.process.createActivity().toUserTask();
            userTwo.setDefaultLabel("User Task Two");
            userTwo.setLocation(LaneUtils.getLocationFor((Lane)two, (double)0.5, (int)150));
            this.process.addChild((ProjectObject)userTwo);
            UserTask userOne = this.process.createActivity().toUserTask();
            userOne.setDefaultLabel("User Task One");
            userOne.setLocation(LaneUtils.getLocationFor((Lane)one, (double)0.5, (int)150));
            this.process.addChild((ProjectObject)userOne);
            ExclusiveGateway exclusive = this.process.createExclusiveGateway();
            exclusive.setDefaultLabel("Exclusive");
            exclusive.setLocation(LaneUtils.getLocationFor((Lane)two, (double)0.5, (int)150));
            this.process.addChild((ProjectObject)exclusive);
            ScriptTask scriptOne = this.process.createActivity().toScriptTask();
            scriptOne.setDefaultLabel("Script Task One");
            scriptOne.setLocation(LaneUtils.getLocationFor((Lane)two, (double)0.5, (int)170));
            this.process.addChild((ProjectObject)scriptOne);
            ScriptTask scriptTwo = this.process.createActivity().toScriptTask();
            scriptTwo.setDefaultLabel("Script Task Two");
            scriptTwo.setLocation(LaneUtils.getLocationFor((Lane)two, (double)0.5, (int)170));
            this.process.addChild((ProjectObject)scriptTwo);
            ReceiveTask outOfFlowOne = this.process.createActivity().toReceiveTask();
            outOfFlowOne.setDefaultLabel("Out of Flow One");
            this.process.addChild((ProjectObject)outOfFlowOne);
            ReceiveTask outOfFlowTwo = this.process.createActivity().toReceiveTask();
            outOfFlowTwo.setDefaultLabel("Out of Flow Two");
            this.process.addChild((ProjectObject)outOfFlowTwo);
            ReceiveTask outOfFlowThree = this.process.createActivity().toReceiveTask();
            outOfFlowThree.setDefaultLabel("Out of Flow Three");
            this.process.addChild((ProjectObject)outOfFlowThree);
            StartEvent startOne = this.process.createStartEvent(EventTriggerType.MESSAGE);
            startOne.setDefaultLabel("Alternative Start One");
            this.process.addChild((ProjectObject)startOne);
            StartEvent startTwo = this.process.createStartEvent(EventTriggerType.MESSAGE);
            startTwo.setDefaultLabel("Alternative Start Two");
            this.process.addChild((ProjectObject)startTwo);
            EndEvent end = this.process.createEndEvent(EventTriggerType.MESSAGE);
            end.setDefaultLabel("Alternative End");
            this.process.addChild((ProjectObject)end);
            EventBasedGateway gateway = this.process.createEventBasedGateway();
            gateway.setInstantiate(true);
            gateway.setDefaultLabel("Another Start");
            this.process.addChild((ProjectObject)gateway);
            Subprocess eventSubprocess = this.createSubprocess("Event Subprocess One", true, true);
            eventSubprocess.setLocation(LaneUtils.getLocationFor((Lane)two, (double)0.5, (int)350));
            Subprocess eventSubprocess3 = this.createSubprocess("Event Subprocess Three", true, true);
            eventSubprocess3.setLocation(LaneUtils.getLocationFor((Lane)one, (double)0.5, (int)350));
            Subprocess regularSubprocess = this.createSubprocess("Regular Subprocess", false, false);
            Subprocess interactiveSubprocess = this.createSubprocess("Interactive Subprocess", true, false);
            BoundaryEvent boundaryOne = this.process.createBoundaryEvent(EventTriggerType.MESSAGE, (Activity)regularSubprocess);
            this.process.addChild((ProjectObject)boundaryOne);
            BoundaryEvent boundaryTwo = this.process.createBoundaryEvent(EventTriggerType.TIMER, (Activity)regularSubprocess);
            this.process.addChild((ProjectObject)boundaryTwo);
            BoundaryEvent boundaryThree = this.process.createBoundaryEvent(EventTriggerType.MESSAGE, (Activity)interactiveSubprocess);
            this.process.addChild((ProjectObject)boundaryThree);
            BoundaryEvent boundaryFour = this.process.createBoundaryEvent(EventTriggerType.TIMER, (Activity)interactiveSubprocess);
            this.process.addChild((ProjectObject)boundaryFour);
            BoundaryEvent boundaryFive = this.process.createBoundaryEvent(EventTriggerType.ERROR, (Activity)interactiveSubprocess);
            this.process.addChild((ProjectObject)boundaryFive);
            SequenceFlow startToEnd = (SequenceFlow)CollectionUtils.first(this.process.getSequenceFlows());
            new InsertActivityInTransitionCommand((FlowNode)userOne, startToEnd).execute();
            SequenceFlow oneToEnd = (SequenceFlow)CollectionUtils.first(userOne.getOutgoingSequenceFlows());
            new InsertActivityInTransitionCommand((FlowNode)exclusive, oneToEnd).execute();
            SequenceFlow exclusiveToEnd = (SequenceFlow)CollectionUtils.first(exclusive.getOutgoingSequenceFlows());
            new InsertActivityInTransitionCommand((FlowNode)userTwo, exclusiveToEnd).execute();
            SequenceFlow exclusiveToScriptOne = this.process.createSequenceFlow((FlowNode)exclusive, (FlowNode)scriptOne);
            new AddTransitionCommand((SequenceFlow)exclusiveToScriptOne.toConditionalFlow()).execute();
            SequenceFlow scriptOneToInteractiveSubprocess = this.process.createSequenceFlow((FlowNode)scriptOne, (FlowNode)interactiveSubprocess);
            new AddTransitionCommand(scriptOneToInteractiveSubprocess).execute();
            SequenceFlow interactiveSubprocessToAlternativeEnd = this.process.createSequenceFlow((FlowNode)interactiveSubprocess, (FlowNode)end);
            new AddTransitionCommand(interactiveSubprocessToAlternativeEnd).execute();
            SequenceFlow alternativeStartOneToSubprocess = this.process.createSequenceFlow((FlowNode)startOne, (FlowNode)regularSubprocess);
            new AddTransitionCommand(alternativeStartOneToSubprocess).execute();
            SequenceFlow regularSubprocessToScriptTwo = this.process.createSequenceFlow((FlowNode)regularSubprocess, (FlowNode)scriptTwo);
            new AddTransitionCommand(regularSubprocessToScriptTwo).execute();
            SequenceFlow scriptTwoToUserTwo = this.process.createSequenceFlow((FlowNode)scriptTwo, (FlowNode)userTwo);
            new AddTransitionCommand(scriptTwoToUserTwo).execute();
            SequenceFlow alternativeStartTwoToExclusive = this.process.createSequenceFlow((FlowNode)startTwo, (FlowNode)exclusive);
            new AddTransitionCommand(alternativeStartTwoToExclusive).execute();
            SequenceFlow outOfFLowOneToOutOfFlowTwo = this.process.createSequenceFlow((FlowNode)outOfFlowOne, (FlowNode)outOfFlowTwo);
            new AddTransitionCommand(outOfFLowOneToOutOfFlowTwo).execute();
            SequenceFlow exclusiveToAlternativeEnd = this.process.createSequenceFlow((FlowNode)exclusive, (FlowNode)end);
            new AddTransitionCommand(exclusiveToAlternativeEnd).execute();
            SequenceFlow exclusiveToInteractiveSubprocess = this.process.createSequenceFlow((FlowNode)exclusive, (FlowNode)interactiveSubprocess);
            new AddTransitionCommand(exclusiveToInteractiveSubprocess).execute();
            SequenceFlow boundaryOneToUserTwo = this.process.createSequenceFlow((FlowNode)boundaryOne, (FlowNode)userTwo);
            new AddTransitionCommand(boundaryOneToUserTwo).execute();
            SequenceFlow boundaryTwoToScriptTwo = this.process.createSequenceFlow((FlowNode)boundaryTwo, (FlowNode)scriptTwo);
            new AddTransitionCommand(boundaryTwoToScriptTwo).execute();
            SequenceFlow interactiveSubprocessToUserOne = this.process.createSequenceFlow((FlowNode)interactiveSubprocess, (FlowNode)userOne);
            new AddTransitionCommand(interactiveSubprocessToUserOne).execute();
            SequenceFlow boundaryThreeToUserOne = this.process.createSequenceFlow((FlowNode)boundaryThree, (FlowNode)userOne);
            new AddTransitionCommand(boundaryThreeToUserOne).execute();
            SequenceFlow boundaryFourToScriptOne = this.process.createSequenceFlow((FlowNode)boundaryFour, (FlowNode)scriptOne);
            new AddTransitionCommand(boundaryFourToScriptOne).execute();
            SequenceFlow boundaryFiveToAlternativeEnd = this.process.createSequenceFlow((FlowNode)boundaryFive, (FlowNode)end);
            new AddTransitionCommand(boundaryFiveToAlternativeEnd).execute();
            SequenceFlow eventBasedToRegularSubprocess = this.process.createSequenceFlow((FlowNode)gateway, (FlowNode)regularSubprocess);
            Measurement measurement = this.process.createMeasurement("measurement1");
            measurement.setDefaultLabel("Ud. no dude jamas");
            measurement.setLocation(new Point(500, 500));
            measurement.setTransition(interactiveSubprocessToUserOne);
            this.process.addChild((ProjectObject)measurement);
        }
        catch (ProjectException e) {
            e.printStackTrace();
        }
    }

    private Subprocess createSubprocess(String name, boolean interactive, boolean event) throws ProjectException {
        Subprocess subprocess = this.process.createSubprocess(event);
        subprocess.setDefaultLabel(name);
        subprocess.setWidth(240);
        subprocess.setHeight(240);
        this.process.addChild((ProjectObject)subprocess);
        StartEvent start = subprocess.createStartEvent(interactive ? EventTriggerType.MESSAGE : EventTriggerType.NONE);
        subprocess.addChild((ProjectObject)start);
        Activity middle = interactive ? subprocess.createActivity().toUserTask() : subprocess.createActivity();
        middle.setDefaultLabel("Middle " + name);
        subprocess.addChild((ProjectObject)middle);
        EndEvent end = subprocess.createEndEvent(EventTriggerType.NONE);
        subprocess.addChild((ProjectObject)end);
        SequenceFlow startToMiddle = subprocess.createSequenceFlow((FlowNode)start, (FlowNode)middle);
        new AddTransitionCommand(startToMiddle).execute();
        SequenceFlow middleToEnd = subprocess.createSequenceFlow((FlowNode)middle, (FlowNode)end);
        new AddTransitionCommand(middleToEnd).execute();
        return subprocess;
    }

    private void preview() {
        Ui.initialize((UiType)UiType.SWING);
        Frame frame = new Frame("Before - After Visual Layout Tester");
        Panel panel = new Panel((UiContainer)frame);
        panel.setLayout((Layout)new BorderLayout());
        final ProcessPreviewer previewer = new ProcessPreviewer((UiContainer)panel);
        Button button = new Button((UiContainer)panel, new BaseAction(Msg.QUOTE("Re-run Autolayout!")){

            public void run() {
                try {
                    AutoLayoutTester.this.autolayout();
                    previewer.setProcessToRender(AutoLayoutTester.this.process);
                    previewer.repaint();
                }
                catch (ProjectException e) {
                    e.printStackTrace();
                }
            }
        });
        previewer.setProcessToRender(this.process);
        previewer.getDrawableProcess().setInsets(Insets.valueOf(8));
        Rectangle bounds = previewer.getDrawableProcess().getBounds();
        previewer.setSize(bounds.getWidth(), bounds.getHeight());
        panel.add((UiComponent)previewer, (Object)"Center");
        panel.add((UiComponent)button, (Object)"South");
        frame.add((UiComponent)panel);
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private void autolayout() throws ProjectException {
        KoreanLayoutAlgorithm.layoutModel((NodeContainer)this.process, (int)1, (boolean)DesignerPreferences.getPreferences().isOptimizeLanesOnAutoLayout());
    }

    private void initialize() {
        File dir = new File("/Users/pedrocolunga/Desktop/tmp/autolayout");
        if (dir.exists()) {
            dir.delete();
        }
        dir.mkdir();
        FileProjectRepository repository = FileProjectRepository.create((File)dir);
        try {
            this.project = repository.create("autolayout");
        }
        catch (ProjectException e) {
            e.printStackTrace();
        }
    }

    private Process createNoneEventProcess() throws ProjectException {
        Process result = this.project.getModelsRoot().createNoneEventModel("AutoLayout-Process");
        this.project.addProcess(result);
        return result;
    }
}

