/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.net.URL;
import java.util.ArrayList;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.DefaultRibbonItem;
import oracle.bpm.designer.MeasurmentRibbonItem;
import oracle.bpm.designer.NoteRibbonItem;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.RibbonItem;
import oracle.bpm.ui.RibbonSectionMultiple;
import oracle.bpm.ui.SVGImage;
import oracle.bpm.ui.UiContainer;

public class ArtifactRibbonSection
extends RibbonSectionMultiple {
    private RibbonItem defaultItem;
    private ProcessDomain domain;

    public ArtifactRibbonSection(UiContainer parent, ProcessDomain domain) {
        super(parent);
        this.domain = domain;
        super.loadSection();
    }

    public Sequence<RibbonItem> loadItems() {
        ArrayList<RibbonItem> list = new ArrayList<RibbonItem>();
        DefaultRibbonItem item = new DefaultRibbonItem(DesignerMsg.SEQUENCE_FLOW, SVGImage.create((URL)DesignerMsg.NEW_SEQUENCEFLOW_NORMAL.getImageResource()).getScaledInstance(30, 16, 0), this.domain);
        list.add(item);
        MeasurmentRibbonItem item2 = new MeasurmentRibbonItem(FlowFigureUtils.getNameForType((FlowFigureType)FlowFigureType.MEASUREMENT), SVGImage.create((URL)DesignerMsg.NEW_MEASURMENT_NORMAL.getImageResource()).getScaledInstance(30, 16, 0), this.domain);
        list.add(item2);
        NoteRibbonItem item3 = new NoteRibbonItem(ProjectModelMsg.TEXT_ANNOTATION, SVGImage.create((URL)DesignerMsg.NEW_NOTE_NORMAL.getImageResource()).getScaledInstance(30, 16, 0), this.domain);
        list.add(item3);
        String defaultItem = this.getDefaultType();
        this.defaultItem = defaultItem.equals(ProjectModelMsg.TEXT_ANNOTATION.getString()) ? item3 : (defaultItem.equals(FlowFigureUtils.getNameForType((FlowFigureType)FlowFigureType.MEASUREMENT).getString()) ? item2 : item);
        return CollectionUtils.asSequence(list);
    }

    public Msg getTitle() {
        return DesignerMsg.ARTIFACTS;
    }

    public RibbonItem getDefault() {
        if (this.defaultItem == null) {
            throw new ExceptionInInitializerError();
        }
        return this.defaultItem;
    }

    public void setDefault(RibbonItem defaultItem) {
        this.defaultItem = defaultItem;
        DesignerPreferences designerPreferences = DesignerPreferences.getPreferences();
        designerPreferences.setLastArtifactsRibbonSection(defaultItem.getTitle().getString());
        designerPreferences.store();
    }

    private String getDefaultType() {
        DesignerPreferences designerPreferences = DesignerPreferences.getPreferences();
        String lastPreference = designerPreferences.getLastArtifactsRibbonSection();
        if (lastPreference != null) {
            return lastPreference;
        }
        return DesignerMsg.SEQUENCE_FLOW.getString();
    }
}

