/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.Collection;
import java.util.Locale;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.designer.DesignerException;
import oracle.bpm.designer.DesignerResources;
import oracle.bpm.designer.ProcessInfoPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lang.Str;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.ExternalDocumentImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.processes.ApplicationInfo;
import oracle.bpm.project.model.processes.ExternalDocument;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextComponent;
import oracle.bpm.ui.text.TextField;

class ApplicationPanelBuilder
extends ProcessInfoPanel.InnerPanelBuilder {
    private TextField categoryField;
    private LocaleStringMap categoryMap;
    private TextArea descriptionArea;
    private LocaleStringMap descriptionMap;
    private DocumentsTable documentsTable;
    private TextField linkNameField;
    private LocaleStringMap linkNameMap;
    private TagsTable tagsTable;

    public ApplicationPanelBuilder(Process process) {
        super(process);
    }

    public void build(Panel panelToBuild) {
        Process process = this.getProcess();
        Project project = process.getProject();
        ApplicationInfo appInfo = process.getApplicationInfo();
        panelToBuild.setLayout((Layout)new MigLayout("fill, gapx 5, ins 5"));
        this.linkNameField = new TextField((UiContainer)panelToBuild, appInfo.getLinkName(), 30);
        this.linkNameMap = appInfo.getLinkNames().clone();
        panelToBuild.add((UiComponent)Label.create((UiContainer)panelToBuild, (Msg)DesignerMsg.LINK_NAME));
        panelToBuild.add((UiComponent)this.linkNameField, (Object)"growx, pushx");
        panelToBuild.add((UiComponent)DesignerResources.buildLocalizationButton(project, (UiContainer)panelToBuild, this.linkNameMap, (TextComponent)this.linkNameField, DesignerMsg.LOCALIZE_LABEL.getString()), (Object)"wrap");
        this.descriptionArea = new TextArea((UiContainer)panelToBuild);
        this.descriptionArea.setText(appInfo.getDescription());
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setColumns(30);
        this.descriptionArea.setRows(3);
        this.descriptionArea.setWrapStyleWord(true);
        this.descriptionMap = appInfo.getDescriptions().clone();
        panelToBuild.add((UiComponent)Label.create((UiContainer)panelToBuild, (Msg)DesignerMsg.DESCRIPTION));
        panelToBuild.add((UiComponent)this.descriptionArea, (Object)"growx");
        panelToBuild.add((UiComponent)DesignerResources.buildLocalizationButton(project, (UiContainer)panelToBuild, this.descriptionMap, (TextComponent)this.descriptionArea, DesignerMsg.LOCALIZE_LABEL.getString(), true), (Object)"aligny top, wrap");
        this.categoryField = new TextField((UiContainer)panelToBuild, appInfo.getCategory(), 30);
        this.categoryMap = appInfo.getCategories().clone();
        panelToBuild.add((UiComponent)Label.create((UiContainer)panelToBuild, (Msg)UIMsg.CATEGORY));
        panelToBuild.add((UiComponent)this.categoryField, (Object)"growx, pushx");
        panelToBuild.add((UiComponent)DesignerResources.buildLocalizationButton(project, (UiContainer)panelToBuild, this.categoryMap, (TextComponent)this.categoryField, DesignerMsg.LOCALIZE_LABEL.getString()), (Object)"wrap");
        this.tagsTable = new TagsTable((UiContainer)panelToBuild, appInfo.getTags());
        panelToBuild.add((UiComponent)this.tagsTable, (Object)"spanx 3, growx, growy 50, wrap");
        this.documentsTable = new DocumentsTable((UiContainer)panelToBuild, appInfo.getExternalDocuments());
        panelToBuild.add((UiComponent)this.documentsTable, (Object)"spanx 3, growx, growy 50, wrap");
    }

    @Override
    public void checkValues(Process model) throws DesignerException {
        Collection<ExternalDocument> documents = this.documentsTable.getExternalDocuments();
        for (ExternalDocument doc : documents) {
            if (!Str.isEmpty(doc.getName())) continue;
            throw new DesignerException(DesignerMsg.DOCUMENT_NAME_CANNOT_BE_EMPTY);
        }
        if (Str.isEmpty(this.linkNameField.getText())) {
            throw new DesignerException(DesignerMsg.LINK_NAME_CANNOT_BE_EMPTY);
        }
    }

    @Override
    public void objectToPanel(Process process) {
    }

    @Override
    public void panelToObject(Process process) {
        ProjectPreferences preferences = process.getProject().getPreferences();
        Locale locale = preferences.getDefaultLanguage();
        ApplicationInfo appInfo = process.getApplicationInfo();
        LocaleStringMap linkNames = appInfo.getLinkNames();
        linkNames.clear();
        this.linkNameMap.put(locale, this.linkNameField.getText());
        linkNames.putAll(this.linkNameMap);
        LocaleStringMap descriptions = appInfo.getDescriptions();
        descriptions.clear();
        this.descriptionMap.put(locale, this.descriptionArea.getText());
        descriptions.putAll(this.descriptionMap);
        LocaleStringMap categories = appInfo.getCategories();
        categories.clear();
        this.categoryMap.put(locale, this.categoryField.getText());
        categories.putAll(this.categoryMap);
        appInfo.clearTags();
        Collection<String> tags = this.tagsTable.getTags();
        for (String tag : tags) {
            appInfo.addTag(tag);
        }
        appInfo.clearExternalDocuments();
        Collection<ExternalDocument> documents = this.documentsTable.getExternalDocuments();
        for (ExternalDocument doc : documents) {
            appInfo.addExternalDocument(doc);
        }
    }

    private static class TagsTable
    extends BaseTablePanel {
        public TagsTable(UiContainer parent, Sequence<String> values) {
            super(parent, DesignerMsg.TAGS, DesignerMsg.TAGS, (TableModel)new TagsTableModel(values), BaseTablePanel.Style.TOOLBAR_TOP);
        }

        public Dimension getMinimumSize() {
            return Dimension.valueOf(300, 120);
        }

        protected void addAction() {
            String value;
            do {
                String s;
                if ((s = MessageDialog.showInput((UiWindow)this.getOwnerWindow(), (Msg)DesignerMsg.CREATE_TAG, (Msg)DesignerMsg.TAG)) == null) {
                    return;
                }
                value = s.trim();
                if (!this.wasAlreadyAdded(value)) continue;
                MessageDialog.showError((UiContainer)this.getParentWindow(), (Msg)DesignerMsg.CREATE_TAG, (Msg)DesignerMsg.DUPLICATED_TAG(value));
            } while (this.wasAlreadyAdded(value));
            if (!Str.isEmpty(value)) {
                this.getModel().insertRow(value);
            }
        }

        protected TagsTableModel getModel() {
            return (TagsTableModel)super.getModel();
        }

        Collection<String> getTags() {
            return this.getModel().getTags();
        }

        private boolean wasAlreadyAdded(String value) {
            return this.getModel().getRowIndex(value.toLowerCase()) > -1 || this.getModel().getRowIndex(value.toUpperCase()) > -1;
        }

        public static class TagsTableModel
        extends ProviderTableModel<String> {
            TagsTableModel(Sequence<String> values) {
                super(MsgList.create(DesignerMsg.TAG));
                this.setValues(values);
            }

            public boolean isCellEditable(int row, int column) {
                return false;
            }

            public Object getValueAt(int row, int column) {
                return this.getRow(row);
            }

            Collection<String> getTags() {
                return this.getData();
            }

            void insertRow(String value) {
                this.addRow(value);
            }

            private void setValues(Sequence<String> values) {
                this.removeAllElements();
                for (String value : values) {
                    this.insertRow(value);
                }
            }
        }
    }

    private static class DocumentsTable
    extends BaseTablePanel {
        public DocumentsTable(UiContainer parent, Sequence<ExternalDocument> values) {
            super(parent, DesignerMsg.EXTERNAL_DOCUMENTS, DesignerMsg.EXTERNAL_DOCUMENTS, (TableModel)new DocumentTableModel(values), BaseTablePanel.Style.TOOLBAR_TOP);
        }

        public Dimension getMinimumSize() {
            return Dimension.valueOf(300, 120);
        }

        protected void addAction() {
            ExternalDocumentDialog dialog = new ExternalDocumentDialog(this.getOwnerWindow());
            dialog.setVisible(true);
            if (dialog.userAccepted()) {
                ExternalDocument document = dialog.getExternalDocument();
                this.getModel().insertRow(document);
            }
        }

        protected DocumentTableModel getModel() {
            return (DocumentTableModel)super.getModel();
        }

        Collection<ExternalDocument> getExternalDocuments() {
            return this.getModel().getExternalDocuments();
        }

        private static class ExternalDocumentDialog
        extends OkCancelDialog {
            private TextField linkTextField;
            private TextField nameTextField;

            public ExternalDocumentDialog(UiWindow parent) {
                super(parent, ProjectUiMsg.CREATE((Msg)DesignerMsg.EXTERNAL_DOCUMENT), true);
                this.init();
            }

            public void ok() {
                this.setUserAccepted(true);
                this.close();
            }

            public ExternalDocument getExternalDocument() {
                return ExternalDocumentImpl.create((String)this.nameTextField.getText(), (String)this.linkTextField.getText());
            }

            private void init() {
                UiContainer container = this.getContentPane();
                container.setLayout((Layout)new MigLayout("fill, gapy 10px"));
                this.nameTextField = new TextField(container, 40);
                this.linkTextField = new TextField(container, 40);
                DocumentListener.Default listener = new DocumentListener.Default(){

                    public void anyUpdate(DocumentEvent e) {
                        ExternalDocumentDialog.this.enableOk(!Str.isEmpty(ExternalDocumentDialog.this.nameTextField.getText()) && !Str.isEmpty(ExternalDocumentDialog.this.linkTextField.getText()));
                    }
                };
                this.nameTextField.addDocumentListener((DocumentListener)listener);
                this.linkTextField.addDocumentListener((DocumentListener)listener);
                this.enableOk(false);
                container.add((UiComponent)Label.create((UiContainer)container, (Msg)DesignerMsg.NAME));
                container.add((UiComponent)this.nameTextField, (Object)"growx, wrap");
                container.add((UiComponent)Label.create((UiContainer)container, (Msg)CoreMsg.LINK));
                container.add((UiComponent)this.linkTextField, (Object)"growx, wrap");
                this.pack();
                this.setLocationRelativeTo((UiComponent)this.getParent());
            }
        }

        private static class DocumentTableModel
        extends ProviderTableModel<ExternalDocument> {
            private static final int NAME_COLUMN = 0;
            private static final int LINK_COLUMN = 1;

            DocumentTableModel(Sequence<ExternalDocument> values) {
                super(MsgList.create(DesignerMsg.NAME, CoreMsg.LINK));
                this.setValues(values);
            }

            public boolean isCellEditable(int row, int column) {
                return false;
            }

            public Object getValueAt(int row, int column) {
                ExternalDocument doc = (ExternalDocument)this.getRow(row);
                switch (column) {
                    case 0: {
                        return doc.getName();
                    }
                    case 1: {
                        return doc.getLink();
                    }
                }
                return "";
            }

            Collection<ExternalDocument> getExternalDocuments() {
                return this.getData();
            }

            void insertRow(ExternalDocument value) {
                this.addRow(value);
            }

            private void setValues(Sequence<ExternalDocument> values) {
                this.removeAllElements();
                for (ExternalDocument value : values) {
                    this.insertRow(value);
                }
            }
        }
    }
}

