/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import fuego.simulation.Simulation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.BusinessRuleService;
import oracle.bpm.designer.CustomizeService;
import oracle.bpm.designer.DesignerApplication;
import oracle.bpm.designer.FabricService;
import oracle.bpm.designer.HumanTaskService;
import oracle.bpm.designer.ProcessCanvas;
import oracle.bpm.designer.ProcessEditor;
import oracle.bpm.designer.ProcessPanel;
import oracle.bpm.designer.ProjectNavigatorTree;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.SOASchemaBrowserDialog;
import oracle.bpm.designer.SpringWsdlInterface;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.WorkbenchListener;
import oracle.bpm.designer.identity.LookupMembersService;
import oracle.bpm.designer.identity.LookupOUService;
import oracle.bpm.designer.identity.LookupService;
import oracle.bpm.designer.simulation.SimulationListener;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.Editor;
import oracle.bpm.extensionpoint.metadata.OutlineProjectFilter;
import oracle.bpm.extensionpoint.metadata.OutlineRootNode;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.DefaultEnvironment;
import oracle.bpm.lang.Environment;
import oracle.bpm.lang.Platform;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.selection.DefaultSelectionProvider;
import oracle.bpm.ui.selection.SelectionProvider;
import oracle.bpm.ui.tree.TreeNode;
import oracle.ide.Ide;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractStudioWorkbench
implements StudioWorkbench {
    protected List<WorkbenchListener> workbenchListeners = new ArrayList<WorkbenchListener>();
    private ProjectNavigatorTree projectTree;
    private boolean screenFlowSimulating;
    private SelectionProvider selectionProvider;
    private Simulation simulation;
    private List<SimulationListener> simulationListeners = new ArrayList<SimulationListener>();
    private static Collection<EngineListener> listeners = new ArrayList<EngineListener>();
    private static Environment environment;
    private static StudioWorkbench instance;

    protected AbstractStudioWorkbench() {
        this.selectionProvider = new DefaultSelectionProvider();
    }

    public abstract void setFocusOnActiveEditor();

    @Override
    public abstract SelectionProvider getEditorAreaSelectionProvider();

    public static void setInstance(StudioWorkbench workbench) {
        instance = workbench;
    }

    public static StudioWorkbench getInstance() {
        return instance;
    }

    public static void repaintAllDesigns() {
        Sequence<ProcessEditor> editors = AbstractStudioWorkbench.getInstance().getEditorsByClass(ProcessEditor.class);
        for (ProcessEditor editor : editors) {
            ProcessPanel panel;
            if (editor == null || (panel = editor.getProcessPanel()) == null) continue;
            ProcessCanvas canvas = panel.getProcessDomain().getCanvas();
            panel.repaint();
            canvas.repaint();
            canvas.revalidate();
        }
    }

    public static void setEnvironment(Environment environment) {
        AbstractStudioWorkbench.environment = environment;
    }

    public static Environment getEnvironment() {
        if (environment == null && Ui.isSwing()) {
            environment = DesignerApplication.getInstance().getInitializer().createEnvironment();
        }
        if (environment == null) {
            environment = new DefaultEnvironment();
        }
        return environment;
    }

    public static void addEngineListener(EngineListener listener) {
        listeners.add(listener);
    }

    public static void removeEngineListener(EngineListener listener) {
        listeners.remove(listener);
    }

    public static void storeProjectObjectIfNecessary(ProjectObject projectObject) throws ProjectException {
        Project project;
        StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
        StudioEditor editor = workbench.findEditorByObject(projectObject);
        if (editor == null && (project = projectObject.getProject()) != null) {
            project.getWriter().write(new ProjectObject[]{projectObject});
        }
    }

    public static boolean isApplicationOpen() {
        return Ide.getActiveWorkspace() != null;
    }

    @Override
    public BusinessRuleService getBusinessRuleService() {
        return null;
    }

    @Override
    public HumanTaskService getHumanTaskService() {
        return null;
    }

    @Override
    public LookupMembersService getLookupMembersService() {
        return null;
    }

    @Override
    public LookupOUService getLookupOUService() {
        return null;
    }

    @Override
    public LookupService getLookupService() {
        return null;
    }

    @Override
    public CustomizeService getCustomizeService() {
        return null;
    }

    @Override
    public SpringWsdlInterface getSpringService() {
        return null;
    }

    @Override
    public boolean isBusinessAnalyst() {
        return false;
    }

    @Override
    public boolean closeProject(Project project) {
        this.closeAllEditors();
        try {
            project.getRepository().close(project);
        }
        catch (ProjectException e) {
            Log.logWarning(e);
        }
        return true;
    }

    @Override
    public void addWorkbenchListener(WorkbenchListener listener) {
        this.workbenchListeners.add(listener);
    }

    @Override
    public void removeWorkbenchListener(WorkbenchListener listener) {
        this.workbenchListeners.remove(listener);
    }

    public void fireEngineStarted(Project project) {
        for (EngineListener listener : new ArrayList<EngineListener>(listeners)) {
            listener.engineStarted(project);
        }
    }

    public void fireEngineStopped(Project project) {
        for (EngineListener listener : listeners) {
            listener.engineStopped(project);
        }
    }

    @Override
    public SelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    @Override
    public ProjectRepository getRepository() {
        return RepositoryService.getInstance().getActiveRepository();
    }

    @Override
    public final Sequence<StudioEditor> getEditors() {
        return this.getAllEditors();
    }

    @Override
    public final <T extends StudioEditor> Sequence<T> getEditorsByClass(Class<T> clazz) {
        return this.getAllEditors().selectInstanceOf(clazz);
    }

    @Override
    public final void setProjectTree(ProjectNavigatorTree tree) {
        this.projectTree = tree;
    }

    @Override
    public final ProjectNavigatorTree getProjectTree() {
        return this.projectTree;
    }

    @Override
    public boolean isSimulating() {
        return this.simulation != null || this.screenFlowSimulating;
    }

    @Override
    public void setScreenflowSimulating(boolean value) {
        this.screenFlowSimulating = value;
    }

    @Override
    public void setSimulation(Simulation simulation) {
        Simulation prevValue = this.simulation;
        this.simulation = simulation;
        if (simulation == null) {
            this.fireSimulationStopped(prevValue);
        } else {
            this.fireSimulationStarted(simulation);
        }
    }

    @Override
    public void addSimulationListener(SimulationListener simulationListener) {
        this.simulationListeners.add(simulationListener);
    }

    @Override
    public void removeSimulationListener(SimulationListener simulationListener) {
        this.simulationListeners.remove(simulationListener);
    }

    @Override
    public Simulation getSimulation() {
        return this.simulation;
    }

    @Override
    public final void activateEditorForInput(Object input) {
        StudioEditor editor = this.findEditorByObject(input);
        if (editor != null) {
            this.activateEditor(editor);
        }
    }

    @Override
    public final void closeEditorForInput(Object input) {
        StudioEditor editor = this.findEditorByObject(input);
        if (editor != null) {
            this.closeEditor(editor);
        }
    }

    @Override
    public final StudioEditor findEditorByObject(Object object) {
        assert (!(object instanceof TypeRef)) : object;
        StudioEditor result = null;
        for (StudioEditor editor : this.getAllEditors()) {
            if (!Any.equals(editor.getInput(), object)) continue;
            result = editor;
            break;
        }
        return result;
    }

    @Override
    public StudioEditor openEditorForObject(Object object) {
        StudioEditor editor = this.findEditorByObject(object);
        if (editor == null) {
            editor = this.createEditor(object);
        }
        if (editor != null) {
            this.activateEditor(editor);
        }
        return editor;
    }

    @Override
    public StudioEditor openEditorForObject(Object object, Object part) {
        StudioEditor editor = this.openEditorForObject(object);
        editor.openPart(part);
        return editor;
    }

    @Override
    public Class findEditorClass(Object input) {
        Class<?> inputClass = input.getClass();
        Class result = null;
        ExtensionService service = Platform.getExtensionService();
        List<Extension<Editor>> editors = service.getExtensionsByPoint(Editor.class);
        for (Extension<Editor> editor : editors) {
            Editor metadata = editor.getMetadata();
            if (!metadata.objectClass().isAssignableFrom(inputClass)) continue;
            try {
                result = editor.instanceType();
                break;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public StudioEditor createEditor(Object input) {
        return this.createEditor(this.findEditorClass(input), input);
    }

    @Override
    public StudioEditor createEditor(Object input, ToolBar toolbar) {
        return this.createEditor(this.findEditorClass(input), input, toolbar);
    }

    @Override
    public TreeNode findOutlineRootNodeForObject(Object object) {
        ProjectFilter outlineProjectFilter;
        ExtensionService extensionService;
        Extension<OutlineRootNode> extension;
        TreeNode result = null;
        if (object != null && (extension = this.findOutlineExtension(object, extensionService = Platform.getExtensionService())) != null) {
            result = this.instantiateOutline(object, extension);
        }
        if (result != null && result instanceof ProjectObjectTreeNode && (outlineProjectFilter = this.findOutlineRootNodeProjectFilter(result)) != null) {
            ((ProjectObjectTreeNode)result).setFilter(outlineProjectFilter);
        }
        return result;
    }

    @Override
    public SOASchemaBrowserDialog getSOASchemaBrowserDialog(@NotNull Project project) {
        return null;
    }

    @Override
    public FabricService getFabricService() {
        return null;
    }

    protected abstract StudioEditor createEditor(Class var1, Object var2);

    protected abstract Sequence<StudioEditor> getAllEditors();

    protected StudioEditor instantiateEditor(Class editorClass, Object input, UiContainer parent) {
        return this.instantiateEditor(editorClass, input, parent, null);
    }

    protected StudioEditor instantiateEditor(Class editorClass, Object input, UiContainer parent, ToolBar toolbar) {
        StudioEditor editor;
        try {
            Method[] methods;
            Method create = null;
            for (Method method : methods = editorClass.getMethods()) {
                if (!method.getName().equals("create")) continue;
                create = method;
                break;
            }
            if (create != null) {
                editor = (StudioEditor)create.invoke(null, parent, input);
            } else {
                Constructor<?>[] constructors;
                Constructor<?> constructor = null;
                for (Constructor<?> current : constructors = editorClass.getConstructors()) {
                    Class<?>[] parameterTypes = current.getParameterTypes();
                    if (parameterTypes.length != 2) continue;
                    Class<?> paramType1 = parameterTypes[0];
                    Class<?> paramType2 = parameterTypes[1];
                    if (paramType1 != UiContainer.class || input != null && !paramType2.isAssignableFrom(input.getClass())) continue;
                    constructor = current;
                    break;
                }
                if (constructor == null) {
                    String inputClassName = input != null ? input.getClass().getName() : "<any>";
                    throw new IllegalArgumentException("Cannot find a constructor for arguments [ UiContainer.class, " + inputClassName + "] in class: " + editorClass);
                }
                editor = (StudioEditor)constructor.newInstance(parent, input);
            }
            if (editor != null) {
                editor.setToolBar(toolbar);
                editor.init();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return editor;
    }

    protected StudioEditor[] toEditorArray(List<StudioEditor> editors) {
        StudioEditor[] result = new StudioEditor[editors.size()];
        editors.toArray(result);
        return result;
    }

    private ProjectFilter findOutlineRootNodeProjectFilter(TreeNode treeNode) {
        ExtensionService extensionService;
        Extension<OutlineProjectFilter> extension;
        ProjectFilter result = null;
        if (treeNode != null && (extension = this.findOutlineProjectFilterExtension(treeNode, extensionService = Platform.getExtensionService())) != null) {
            result = this.instantiateOutlineProjectFilter(treeNode, extension);
        }
        return result;
    }

    private Extension<OutlineProjectFilter> findOutlineProjectFilterExtension(TreeNode treeNode, ExtensionService extensionService) {
        Extension<OutlineProjectFilter> result = null;
        List<Extension<OutlineProjectFilter>> outlineNodeExtensions = extensionService.getExtensionsByPoint(OutlineProjectFilter.class);
        for (Extension<OutlineProjectFilter> extension : outlineNodeExtensions) {
            Class objectClass = extension.getMetadata().rootNodeClass();
            if (!objectClass.isAssignableFrom(treeNode.getClass())) continue;
            result = extension;
            break;
        }
        return result;
    }

    private ProjectFilter instantiateOutlineProjectFilter(TreeNode treeNode, Extension<OutlineProjectFilter> extension) {
        ProjectFilter result;
        try {
            Class projectFilterClass = extension.instanceType();
            Constructor nodeConstructor = projectFilterClass.getConstructor(extension.getMetadata().rootNodeClass());
            result = (ProjectFilter)nodeConstructor.newInstance(treeNode);
        }
        catch (InstantiationException e) {
            throw ProgramException.wrap("There was a problem while trying to get the outline project filter for: " + treeNode.getClass(), e);
        }
        catch (SecurityException e) {
            throw ProgramException.wrap("There was a problem while trying to get the outline project filter for: " + treeNode.getClass(), e);
        }
        catch (NoSuchMethodException e) {
            throw ProgramException.wrap("There was a problem while trying to get the outline project filter for: " + treeNode.getClass(), e);
        }
        catch (IllegalArgumentException e) {
            throw ProgramException.wrap("There was a problem while trying to get the outline project filter for: " + treeNode.getClass(), e);
        }
        catch (IllegalAccessException e) {
            throw ProgramException.wrap("There was a problem while trying to get the outline project filter for: " + treeNode.getClass(), e);
        }
        catch (InvocationTargetException e) {
            throw ProgramException.wrap("There was a problem while trying to get the outline project filter for: " + treeNode.getClass(), e);
        }
        return result;
    }

    private TreeNode instantiateOutline(Object object, Extension<OutlineRootNode> extension) {
        TreeNode result;
        try {
            Class outlineNodeClass = extension.instanceType();
            Constructor nodeConstructor = outlineNodeClass.getConstructor(extension.getMetadata().objectClass());
            result = (TreeNode)nodeConstructor.newInstance(object);
        }
        catch (InstantiationException e) {
            throw ProgramException.wrap("There was a problem while trying to get the outline node for: " + object.getClass(), e);
        }
        catch (SecurityException e) {
            throw ProgramException.wrap("There was a problem while trying to get the outline node for: " + object.getClass(), e);
        }
        catch (NoSuchMethodException e) {
            throw ProgramException.wrap("There was a problem while trying to get the outline node for: " + object.getClass(), e);
        }
        catch (IllegalArgumentException e) {
            throw ProgramException.wrap("There was a problem while trying to get the outline node for: " + object.getClass(), e);
        }
        catch (IllegalAccessException e) {
            throw ProgramException.wrap("There was a problem while trying to get the outline node for: " + object.getClass(), e);
        }
        catch (InvocationTargetException e) {
            throw ProgramException.wrap("There was a problem while trying to get the outline node for: " + object.getClass(), e);
        }
        return result;
    }

    private Extension<OutlineRootNode> findOutlineExtension(Object object, ExtensionService extensionService) {
        Extension<OutlineRootNode> result = null;
        List<Extension<OutlineRootNode>> outlineNodeExtensions = extensionService.getExtensionsByPoint(OutlineRootNode.class);
        for (Extension<OutlineRootNode> extension : outlineNodeExtensions) {
            Class objectClass = extension.getMetadata().objectClass();
            if (!objectClass.isAssignableFrom(object.getClass())) continue;
            result = extension;
            break;
        }
        return result;
    }

    private void fireSimulationStopped(Simulation simulation) {
        for (SimulationListener simulationListener : this.simulationListeners) {
            simulationListener.simulationStopped(simulation);
        }
    }

    private void fireSimulationStarted(Simulation simulation) {
        for (SimulationListener simulationListener : this.simulationListeners) {
            simulationListener.simulationStarted(simulation);
        }
    }

    public static interface EngineListener {
        public void engineStarted(Project var1);

        public void engineStopped(Project var1);
    }
}

