/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ToolTipManager;
import oracle.bpm.draw.Color;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.List;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.KeyAdapter;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.event.KeyListener;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.text.TextField;

public abstract class AbstractListDialog
extends Dialog {
    protected List dataList;
    protected TextField userDataTextField;
    private boolean inUpdate;
    private TextFieldRenderer textFieldRenderer;

    public AbstractListDialog(UiWindow owner, boolean modal) {
        super(owner, modal);
    }

    public TextFieldRenderer getTextFieldRenderer() {
        return this.textFieldRenderer;
    }

    public String getSelectedValue() {
        return this.userDataTextField.getText();
    }

    public void setup() {
        ToolTipManager.sharedInstance().setEnabled(true);
        Object[] listData = this.getListData();
        this.getContentPane().setLayout((Layout)new BorderLayout());
        Panel userDataPanel = new Panel(this.getContentPane());
        userDataPanel.setLayout((Layout)new BoxLayout((UiContainer)userDataPanel, 1));
        Panel labelPanel = new Panel((UiContainer)userDataPanel);
        labelPanel.setLayout((Layout)new BoxLayout((UiContainer)labelPanel, 0));
        Label userDataLabel = Label.create((UiContainer)labelPanel, (Msg)this.getDialogMsg());
        labelPanel.add((UiComponent)userDataLabel);
        labelPanel.setBorder(BorderFactory.createEmptyBorder((int)2, (int)1, (int)2, (int)1));
        this.userDataTextField = new TextField((UiContainer)userDataPanel, 40);
        this.userDataTextField.addDocumentListener(this.createTextListener());
        this.userDataTextField.addKeyListener(this.createDataKeyListener());
        userDataPanel.add((UiComponent)labelPanel);
        userDataPanel.add((UiComponent)this.userDataTextField);
        int visibleRows = listData.length > 10 ? 10 : listData.length;
        this.dataList = new List(this.getContentPane(), ListSelectionMode.SINGLE_SELECTION);
        this.setTextFieldRenderer(this.createTextFieldRenderer());
        this.dataList.setLabelProvider(this.createLabelProvider());
        this.dataList.setListData(this.getListData());
        this.dataList.setVisibleRowCount(visibleRows);
        this.dataList.addMouseListener((MouseListener)this.createMouseListener());
        this.dataList.addKeyListener((KeyListener)this.createListKeyListener());
        this.dataList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && !AbstractListDialog.this.inUpdate) {
                    Object value = AbstractListDialog.this.dataList.getSelectedValue();
                    String fieldValue = AbstractListDialog.this.getTextFieldRenderer().getTextFieldValue(value);
                    AbstractListDialog.this.userDataTextField.setText(fieldValue);
                }
            }
        });
        this.getContentPane().add((UiComponent)userDataPanel, (Object)"North");
        this.getContentPane().add((UiComponent)this.dataList, (Object)"Center");
        this.setLocationRelativeTo((UiComponent)this.getOwner());
        this.userDataTextField.requestFocus();
        this.pack();
    }

    protected abstract LabelProvider createLabelProvider();

    protected abstract Msg getDialogMsg();

    protected abstract Object[] getListData();

    protected abstract TextFieldRenderer createTextFieldRenderer();

    protected void updateDataList() {
        if (!this.userDataTextField.hasFocus()) {
            return;
        }
        TextFieldRenderer textFieldRenderer = this.getTextFieldRenderer();
        String userData = this.userDataTextField.getText();
        if (userData == null || userData.equals("")) {
            this.pack();
            return;
        }
        this.inUpdate = true;
        userData = userData.toLowerCase();
        int size = this.dataList.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            Object element = this.dataList.getModel().getElementAt(i);
            String fieldValue = textFieldRenderer.getTextFieldValue(element);
            if (fieldValue.toLowerCase().startsWith(userData)) {
                this.userDataTextField.setForeground(Color.BLACK);
                this.dataList.setSelectedIndex(i);
                this.dataList.ensureIndexIsVisible(i);
                break;
            }
            this.userDataTextField.setForeground(Color.RED);
        }
        this.inUpdate = false;
    }

    void setTextFieldRenderer(TextFieldRenderer fieldRenderer) {
        this.textFieldRenderer = fieldRenderer;
    }

    private KeyListener createDataKeyListener() {
        return new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.isEnter()) {
                    AbstractListDialog.this.accept();
                    AbstractListDialog.this.setUserAccepted(true);
                    AbstractListDialog.this.close();
                } else if (e.isDown() && AbstractListDialog.this.dataList.getModel().getSize() > 0) {
                    AbstractListDialog.this.dataList.requestFocus();
                    ActionMap actionMap = AbstractListDialog.this.dataList.getActionMap();
                    Action action = actionMap.get("selectNextRow");
                    action.actionPerformed(new ActionEvent((Object)AbstractListDialog.this.dataList, "").asSwing());
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        };
    }

    private KeyAdapter createListKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.isUp()) {
                    if (AbstractListDialog.this.dataList.getSelectedIndex() == 0) {
                        AbstractListDialog.this.userDataTextField.grabFocus();
                    }
                } else if (e.isEnter() && AbstractListDialog.this.dataList.getSelectedIndex() >= 0) {
                    Object value = AbstractListDialog.this.dataList.getSelectedValue();
                    String fieldValue = AbstractListDialog.this.getTextFieldRenderer().getTextFieldValue(value);
                    AbstractListDialog.this.userDataTextField.setText(fieldValue);
                    AbstractListDialog.this.accept();
                    AbstractListDialog.this.setUserAccepted(true);
                    AbstractListDialog.this.close();
                }
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }
        };
    }

    private MouseAdapter createMouseListener() {
        return new MouseAdapter(){

            public void mouseDoubleClicked(MouseEvent e) {
                AbstractListDialog.this.accept();
                AbstractListDialog.this.setUserAccepted(true);
                AbstractListDialog.this.close();
            }

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    AbstractListDialog.this.accept();
                    AbstractListDialog.this.setUserAccepted(true);
                    AbstractListDialog.this.close();
                }
            }
        };
    }

    private DocumentListener createTextListener() {
        return new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                AbstractListDialog.this.updateDataList();
            }

            public void changedUpdate(DocumentEvent e) {
                AbstractListDialog.this.updateDataList();
            }

            public void insertUpdate(DocumentEvent e) {
                AbstractListDialog.this.updateDataList();
            }
        };
    }

    static interface TextFieldRenderer {
        public String getTextFieldValue(Object var1);
    }
}

