/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.DesignerMode;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.ExternalEditorSupport;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.log.Log;
import oracle.bpm.print.Printable;
import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.compiler.CompilationOptions;
import oracle.bpm.project.compiler.ProjectCompilationListener;
import oracle.bpm.project.compiler.ProjectCompiler;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.ProjectRunnable;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.RepositoryAdapter;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.Transactable;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectEventSet;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.events.RepositoryListener;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Cursor;
import oracle.bpm.ui.EditionPanel;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiRunnableDecorator;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.EventListenerList;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.event.UiListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.SelectionListener;

public abstract class AbstractEditor<E extends ProjectObject>
extends EditionPanel
implements StudioEditor {
    protected boolean objectReplaced;
    protected List<ProjectListener> projectListeners = new ArrayList<ProjectListener>();
    private List<CloseListener> closeListeners;
    private boolean compilationNeeded;
    private Timer compilationTimer;
    private Map<ProjectObject, List<ProjectException>> currentErrors = Collections.emptyMap();
    private Map<ProjectObject, List<ProjectException>> currentWarnings = Collections.emptyMap();
    private boolean deleted;
    private boolean disposed = false;
    private boolean editable = true;
    private ChangeEvent event;
    private ExternalEditorSupport externalEditorSupport;
    private EventListenerList listenerList = new EventListenerList();
    private UiContainer mainPanel;
    private ModificationListener modificationListener;
    private Class<E> objectType;
    private ProjectListenerAdapter<ProjectPreferences> preferencesListener;
    private E projectObject;
    private ProjectRepository projectRepository;
    private boolean readOnly;
    private ArrayList<ChangeListener> rebuildListeners;
    private boolean reload;
    private RepositoryListener repositoryListener;
    private boolean reverting;
    private List<SelectionListener> selectionListeners = new ArrayList<SelectionListener>();
    private String title = "";
    private boolean updating = false;
    protected static int LENGTH_TEXT = 35;
    private static final boolean STUDIO_DEBUG_MODE = System.getProperty("fuego.studio.debug") != null;

    public AbstractEditor(UiContainer parent) {
        this(parent, null, null, null);
    }

    public AbstractEditor(UiContainer parent, E projectObject, Class<E> objectType) {
        this(parent, projectObject, objectType, null);
    }

    public AbstractEditor(UiContainer parent, E projectObject, Class<E> objectType, Msg title) {
        super(parent, title);
        this.setProjectObject(projectObject);
        this.objectType = objectType;
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                AbstractEditor.this.onActivation();
            }

            public void focusLost(FocusEvent e) {
            }
        });
    }

    @Override
    public abstract EditorType getEditorType();

    @Override
    public void onActivation() {
        this.setCompilationNeeded(true);
    }

    @Override
    public void setToolBar(ToolBar toolbar) {
    }

    public boolean isUpdating() {
        return this.updating;
    }

    @Override
    public String getHelpId() {
        return this.getDefaultHelpId();
    }

    public Map<ProjectObject, List<ProjectException>> getCurrentErrors() {
        return this.currentErrors;
    }

    public Map<ProjectObject, List<ProjectException>> getCurrentWarnings() {
        return this.currentWarnings;
    }

    public boolean hasErrors() {
        return !this.getCurrentErrors().isEmpty();
    }

    public void startModelCompiling() {
        this.setCompilationNeeded(true);
        if (this.compilationTimer == null) {
            this.compilationTimer = new Timer();
            this.compilationTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        AbstractEditor.this.triggerCompilation();
                    }
                    catch (Throwable unexpected) {
                        if (STUDIO_DEBUG_MODE) {
                            unexpected.printStackTrace();
                        }
                        Log.logSevere(unexpected);
                    }
                }
            }, 0L, 1000L);
        }
    }

    public void stopModelCompiling() {
        if (this.compilationTimer != null) {
            this.compilationTimer.cancel();
            this.compilationTimer = null;
        }
    }

    public void compile(final ProjectMessageListener listener) {
        E object = this.getProjectObject();
        ProjectCompiler compiler = ProjectCompiler.createDefault((Project)object.getProject());
        CompilationOptions options = new CompilationOptions();
        options.setFullBuild(false);
        options.setEmitCode(false);
        compiler.addCompilationListener(new ProjectCompilationListener(){

            public void onError(ProjectException exception) {
                listener.reportError(exception.getProjectObject(), exception);
            }

            public void onWarning(ProjectException exception) {
                listener.reportWarning(exception.getProjectObject(), exception);
            }

            public void onInfo(ProjectException exception) {
            }

            public void onCheckStarted(ProjectObject projectObject) {
            }

            public void onCheckFinished(ProjectObject projectObject) {
            }

            public boolean onInterruptionCheck() {
                return false;
            }
        });
        compiler.compileProjectObject(object, options);
    }

    @Override
    public void openPart(Object part) {
        throw new IllegalArgumentException("Editor '" + this.getClass().getName() + "' does not support opening " + part);
    }

    @Override
    public void disposeEditor() {
        if (this.disposed || this.getProject() == null) {
            return;
        }
        this.stopModelCompiling();
        this.disposed = true;
        this.removeProjectListeners();
        this.onDispose();
        this.mainPanel.removeAll();
        if (this.repositoryListener != null) {
            this.projectRepository.removeRepositoryListener(this.repositoryListener);
        }
        if (!this.deleted) {
            this.replaceObject();
        }
        this.fireClose();
    }

    @Override
    public void init() {
        this.build();
        this.internalObjectToEditor();
    }

    @Override
    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    @Override
    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    @Override
    public void refresh() {
    }

    @Override
    public boolean isPrintable() {
        return false;
    }

    @Override
    public Printable getPrintable() {
        return null;
    }

    @Override
    public void setExternalEditorSupport(ExternalEditorSupport support) {
        this.externalEditorSupport = support;
    }

    public ExternalEditorSupport getExternalEditorSupport() {
        return this.externalEditorSupport;
    }

    public UiComponent getEditor() {
        return this;
    }

    @Override
    public String getTitle() {
        return this.getProjectObject().getId();
    }

    @Override
    public Object getInput() {
        return this.getProjectObject();
    }

    public UiComponent getDefaultComponent() {
        return this.getFirstComponent();
    }

    @Override
    public final void setDirty() {
        this.setDirty(true);
    }

    public void setDirty(boolean dirty) {
        assert (!this.disposed) : this;
        this.fireChanged();
        if (dirty) {
            this.setCompilationNeeded(true);
        }
    }

    @Override
    public boolean isDirty() {
        return ((ResourceObject)this.getProjectObject()).isDirty();
    }

    public UiComponent getFirstComponent() {
        return this;
    }

    public final boolean isOpened() {
        StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
        return workbench.isOpen(this);
    }

    public void setPanelId(String title) {
        this.title = title;
    }

    public String getPanelId() {
        return this.title;
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly != this.readOnly) {
            this.readOnly = readOnly;
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String getTabName() {
        return super.getName();
    }

    public boolean accept(UiComponent component) {
        return true;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, (UiListener)l);
    }

    public boolean checkPanelData() {
        return false;
    }

    public boolean close() {
        boolean opened = this.isOpened();
        if (opened) {
            if (this.deleted && !this.reload) {
                AbstractStudioWorkbench.getInstance().closeEditorAfterDelete(this);
            } else {
                AbstractStudioWorkbench.getInstance().closeEditor(this);
            }
        }
        this.fireClose();
        return opened;
    }

    public boolean doUpdate() {
        return true;
    }

    public void focusLost(FocusEvent e) {
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, (UiListener)l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean save() {
        try {
            this.setCursor(Cursor.get((Cursor.CursorType)Cursor.CursorType.WAIT_CURSOR));
            this.stopEdition();
            if (!this.doUpdate()) {
                boolean bl = false;
                return bl;
            }
            this.store();
            boolean bl = true;
            return bl;
        }
        finally {
            this.setCursor(Cursor.get((Cursor.CursorType)Cursor.CursorType.DEFAULT_CURSOR));
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public E getProjectObject() {
        return this.projectObject;
    }

    public void addCloseListener(CloseListener closeListener) {
        this.getCloseListeners().add(closeListener);
    }

    public void removeCloseListener(CloseListener closeListener) {
        this.getCloseListeners().remove(closeListener);
    }

    @Override
    public ToolBar getToolBar() {
        return null;
    }

    @Override
    public UiComponent getStatusBar() {
        return null;
    }

    @Override
    public UiComponent getMiniToolBar() {
        return null;
    }

    @Override
    public void addReloadListener(ChangeListener changeListener) {
        if (this.rebuildListeners == null) {
            this.rebuildListeners = new ArrayList();
        }
        this.rebuildListeners.add(changeListener);
    }

    public void addProjectListener(ProjectListener projectListener) {
        if (this.getProject() != null) {
            this.projectListeners.add(projectListener);
            this.getProject().addListener(projectListener);
        }
    }

    public void setCompilationNeeded(boolean compilationNeeded) {
        this.compilationNeeded = compilationNeeded;
    }

    public void setUpdating(boolean b) {
        this.updating = b;
    }

    protected abstract void buildUI(UiContainer var1);

    protected abstract void editorToObject();

    protected abstract void objectToEditor();

    protected void rebuild() {
        this.stopModelCompiling();
        this.mainPanel.removeAll();
        this.removeProjectListeners();
        if (this.repositoryListener != null) {
            this.projectRepository.removeRepositoryListener(this.repositoryListener);
        }
        this.init();
        this.mainPanel.revalidate();
        this.fireRebuild();
    }

    protected String getDefaultHelpId() {
        return "Editor." + this.getProjectObject().getRawClass().getSimpleName();
    }

    protected void onCompilationCompleted(Map<ProjectObject, List<ProjectException>> errors, Map<ProjectObject, List<ProjectException>> warnings) {
    }

    protected UiComponent buildNorthUi(UiContainer parent) {
        return null;
    }

    protected UiComponent buildWestUi(UiContainer parent) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceObject() {
        if (this.isDirty()) {
            try {
                this.reverting = true;
                ProjectLoader loader = this.getProject().getLoader();
                if (loader != null) {
                    loader.replaceProjectObject(this.getProjectObject());
                }
            }
            catch (ProjectException e) {
                MessageDialog.showError((Throwable)e);
            }
            finally {
                this.reverting = false;
            }
        }
    }

    protected UiContainer createMainPanel() {
        this.setLayout((Layout)new BorderLayout());
        ScrollPane scrollPane = new ScrollPane((UiContainer)this);
        Panel panel = new Panel((UiContainer)scrollPane);
        this.add((UiComponent)scrollPane, "Center");
        scrollPane.setView((UiComponent)panel);
        return panel;
    }

    protected void fireSelectionChanged(ProjectObject ... objects) {
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.selectionChanged(DefaultSelection.createMultiple((Object[])objects));
        }
    }

    protected void fireSelectionChanged(ProjectObject object) {
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.selectionChanged(DefaultSelection.createSingle((Object)object));
        }
    }

    protected final boolean isReverting() {
        return this.reverting;
    }

    protected Project getProject() {
        return this.getProjectObject().getProject();
    }

    protected void stopEdition() {
    }

    protected final void fireChanged() {
        for (ChangeListener l : this.listenerList.getListenersByType(ChangeListener.class)) {
            l.stateChanged(this.getChangeEvent());
        }
    }

    protected void setProjectObject(E projectObject) {
        this.projectObject = projectObject;
    }

    protected void setEditable(boolean editable) {
        this.editable = editable;
    }

    protected void showError(final Exception e) {
        if (UiUtilities.isEventDispatchThread()) {
            MessageDialog.showError((Throwable)e);
        } else {
            try {
                UiUtilities.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.showError((Throwable)e);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void check() throws ProjectException {
    }

    protected void objectHasChanged() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalObjectToEditor() {
        this.updating = true;
        try {
            this.removeModificationListener(this.getModificationListener());
            this.objectToEditor();
            this.objectHasChanged();
            this.addModificationListener(this.getModificationListener());
        }
        finally {
            this.updating = false;
        }
    }

    private void fireRebuild() {
        for (ChangeListener l : this.rebuildListeners) {
            l.stateChanged(this.getChangeEvent());
        }
    }

    private void triggerCompilation() {
        if (this.compilationNeeded) {
            final HashMap<ProjectObject, List<ProjectException>> errors = new HashMap<ProjectObject, List<ProjectException>>();
            final HashMap<ProjectObject, List<ProjectException>> warnings = new HashMap<ProjectObject, List<ProjectException>>();
            final ProjectMessageListener listener = new ProjectMessageListener(){

                public void reportError(ProjectObject object, ProjectException exception) {
                    ArrayList<ProjectException> list = (ArrayList<ProjectException>)errors.get(object);
                    if (list == null) {
                        list = new ArrayList<ProjectException>();
                        errors.put(object, list);
                    }
                    list.add(exception);
                }

                public void reportWarning(ProjectObject object, ProjectException exception) {
                    ArrayList<ProjectException> list = (ArrayList<ProjectException>)warnings.get(object);
                    if (list == null) {
                        list = new ArrayList<ProjectException>();
                        warnings.put(object, list);
                    }
                    list.add(exception);
                }
            };
            ProjectObjectImpl impl = (ProjectObjectImpl)this.getProjectObject();
            try {
                impl.run(new ProjectRunnable(){

                    public void run() throws ProjectException {
                        AbstractEditor.this.compile(listener);
                    }
                });
                impl.run(new ProjectRunnable(){

                    public void run() throws ProjectException {
                        AbstractEditor.this.setErrors(errors, warnings);
                    }
                });
            }
            catch (ProjectException e) {
                Log.logSevere(e);
            }
            this.setCompilationNeeded(false);
            this.onCompilationCompleted(errors, warnings);
            this.repaint();
        }
    }

    private void setErrors(Map<ProjectObject, List<ProjectException>> errors, Map<ProjectObject, List<ProjectException>> warnings) {
        ProjectObjectImpl impl;
        for (Map.Entry<ProjectObject, List<ProjectException>> entry : errors.entrySet()) {
            if (!(entry.getKey() instanceof ProjectObjectImpl)) continue;
            impl = (ProjectObjectImpl)entry.getKey();
            impl.setErrors(entry.getValue());
        }
        for (Map.Entry<ProjectObject, List<ProjectException>> entry : warnings.entrySet()) {
            if (!(entry.getKey() instanceof ProjectObjectImpl)) continue;
            impl = (ProjectObjectImpl)entry.getKey();
            impl.setWarnings(entry.getValue());
        }
        for (ProjectObject po : this.currentErrors.keySet()) {
            if (errors.containsKey(po) || !(po instanceof ProjectObjectImpl)) continue;
            impl = (ProjectObjectImpl)po;
            impl.setErrors(Collections.emptyList());
        }
        for (ProjectObject po : this.currentWarnings.keySet()) {
            if (warnings.containsKey(po) || !(po instanceof ProjectObjectImpl)) continue;
            impl = (ProjectObjectImpl)po;
            impl.setWarnings(Collections.emptyList());
        }
        this.currentErrors = errors;
        this.currentWarnings = warnings;
    }

    private void removeProjectListeners() {
        for (ProjectListener projectListener : this.projectListeners) {
            this.getProject().removeListener(projectListener);
        }
        this.getProject().getPreferences().removeListener(this.preferencesListener);
    }

    private void store() {
        Project project = this.getProjectObject().getProject();
        ProjectRepository repository = project.getRepository();
        if (repository.isOpen(project)) {
            ProjectWriter projectWriter = project.getWriter();
            try {
                projectWriter.write(new ProjectObject[]{this.getProjectObject()});
                this.setDirty(false);
            }
            catch (ProjectException e) {
                MessageDialog.showError((Throwable)e);
            }
        }
    }

    private void build() {
        UiComponent left;
        DesignerMode.setVisibility((UiComponent)this, 2);
        this.mainPanel = this.createMainPanel();
        this.buildUI(this.mainPanel);
        UiComponent top = this.buildNorthUi((UiContainer)this);
        if (top != null) {
            this.add(top, "North");
        }
        if ((left = this.buildWestUi((UiContainer)this)) != null) {
            this.add(left, "West");
        }
        this.addModificationListener(this.getModificationListener());
        this.addProjectObjectListener();
        this.projectRepository = this.getProject().getRepository();
        this.projectRepository.addRepositoryListener(this.getRepositoryListener());
    }

    private RepositoryListener getRepositoryListener() {
        if (this.repositoryListener == null) {
            this.repositoryListener = new RepositoryAdapter(){

                public void projectDeleted(Project project) {
                    if (AbstractEditor.this.getProjectObject().getProject() == project && !AbstractEditor.this.reload) {
                        AbstractEditor.this.deleted = true;
                        if (UiUtilities.isEventDispatchThread()) {
                            AbstractEditor.this.close();
                        } else {
                            try {
                                UiUtilities.invokeLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        AbstractEditor.this.close();
                                    }
                                });
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }

                public void preProjectClose(Project project) {
                    if (AbstractEditor.this.getProjectObject().getProject() == project && !AbstractEditor.this.reload) {
                        if (UiUtilities.isEventDispatchThread()) {
                            AbstractEditor.this.close();
                        } else {
                            UiUtilities.invokeAndWait((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    AbstractEditor.this.close();
                                }
                            });
                        }
                    }
                }

                public void projectReload(Project project) {
                    if (AbstractEditor.this.getProjectObject().getProject() == project) {
                        AbstractEditor.this.reload = true;
                        if (UiUtilities.isEventDispatchThread()) {
                            AbstractStudioWorkbench.getInstance().closeEditorAfterDelete(AbstractEditor.this);
                        } else {
                            try {
                                UiUtilities.invokeLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        AbstractStudioWorkbench.getInstance().closeEditorAfterDelete(AbstractEditor.this);
                                    }
                                });
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
            };
        }
        return this.repositoryListener;
    }

    private void addProjectObjectListener() {
        ProjectListenerAdapter projectListener = new ProjectListenerAdapter<E>(this.objectType){

            public void processPostEvents(ProjectEventSet events) {
                boolean objectChanged = false;
                for (ProjectEvent projectEvent : events) {
                    if (projectEvent.getProjectObject() != AbstractEditor.this.getProjectObject()) continue;
                    ProjectEvent.Type eventType = projectEvent.getType();
                    if (eventType == ProjectEvent.Type.REPLACE || eventType == ProjectEvent.Type.POST_REMOVE) {
                        try {
                            projectEvent.replay((ProjectListener)this);
                        }
                        catch (ProjectException e) {}
                        continue;
                    }
                    objectChanged = true;
                }
                if (objectChanged) {
                    new UiRunnableDecorator(0, new Runnable(){

                        @Override
                        public void run() {
                            if (!AbstractEditor.this.isUpdating() && !AbstractEditor.this.isReverting()) {
                                AbstractEditor.this.internalObjectToEditor();
                                AbstractEditor.this.setDirty();
                            }
                        }
                    }).run();
                }
            }

            public void preObjectRemoved(E object, ProjectObject parent) throws ProjectException {
                if (AbstractEditor.this.getProjectObject().isDescendantOf(object)) {
                    AbstractEditor.this.deleted = true;
                }
            }

            public void postObjectRemoved(E object, ProjectObject parent) {
                if (AbstractEditor.this.getProjectObject().isDescendantOf(object)) {
                    AbstractEditor.this.deleted = true;
                    new UiRunnableDecorator(0, new Runnable(){

                        @Override
                        public void run() {
                            AbstractEditor.this.close();
                        }
                    }).run();
                }
            }

            public void objectReplaced(E oldObject, E newObject) {
                new UiRunnableDecorator(0, new Runnable((ProjectObject)oldObject, (ProjectObject)newObject){
                    final /* synthetic */ ProjectObject val$oldObject;
                    final /* synthetic */ ProjectObject val$newObject;
                    {
                        this.val$oldObject = projectObject;
                        this.val$newObject = projectObject2;
                    }

                    @Override
                    public void run() {
                        if (!AbstractEditor.this.isUpdating() && this.val$oldObject == AbstractEditor.this.getProjectObject()) {
                            AbstractEditor.this.setProjectObject(this.val$newObject);
                            AbstractEditor.this.objectReplaced = true;
                            AbstractEditor.this.internalObjectToEditor();
                            AbstractEditor.this.objectReplaced = false;
                        }
                    }
                }).run();
            }
        };
        this.addProjectListener((ProjectListener)projectListener);
        this.preferencesListener = new ProjectListenerAdapter<ProjectPreferences>(ProjectPreferences.class){

            public void objectChanged(ProjectPreferences projectObject, ProjectEvent event) {
                AbstractEditor.this.setCompilationNeeded(true);
            }
        };
        this.getProject().getPreferences().addListener(this.preferencesListener);
    }

    private ChangeEvent getChangeEvent() {
        if (this.event == null) {
            this.event = new ChangeEvent((Object)this);
        }
        return this.event;
    }

    private ModificationListener getModificationListener() {
        if (this.modificationListener == null) {
            this.modificationListener = new ModificationListener(){

                public void objectModified(ModificationEvent event) {
                    if (!AbstractEditor.this.updating && !AbstractEditor.this.reverting) {
                        AbstractEditor.this.internalEditorToObject();
                        AbstractEditor.this.setDirty(true);
                    }
                    AbstractEditor.this.setCompilationNeeded(true);
                }
            };
        }
        return this.modificationListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalEditorToObject() {
        Transactable txn = (Transactable)this.getProjectObject();
        try {
            this.updating = true;
            try {
                txn.run(new ProjectRunnable(){

                    public void run() throws ProjectException {
                        AbstractEditor.this.check();
                        AbstractEditor.this.editorToObject();
                        AbstractEditor.this.doUpdate();
                        AbstractEditor.this.resetModified();
                    }
                });
            }
            catch (ProjectException e) {
                Log.logSevere(e);
            }
        }
        finally {
            this.updating = false;
        }
    }

    private void fireClose() {
        ArrayList<CloseListener> list = new ArrayList<CloseListener>(this.getCloseListeners());
        for (CloseListener closeListener : list) {
            closeListener.editorClosed(this);
        }
    }

    private List<CloseListener> getCloseListeners() {
        if (this.closeListeners == null) {
            this.closeListeners = new ArrayList<CloseListener>();
        }
        return this.closeListeners;
    }

    public static interface CloseListener {
        public void editorClosed(AbstractEditor var1);
    }
}

