/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.mds.utils;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.metadata.mds.MdsTransaction;
import oracle.mds.core.MDSInstance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MdsTransactionUtil {
    private static final Object lock = new Object();
    private static final ThreadLocal<Map<MDSInstance, MdsTransaction>> context = new ThreadLocal();

    private MdsTransactionUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MdsTransaction getCurrentTransaction(@Nullable MDSInstance mdsInstance, @Nullable String label) {
        MdsTransaction mdsTransaction;
        Map<MDSInstance, MdsTransaction> txs = context.get();
        Object object = lock;
        synchronized (object) {
            if (txs == null) {
                txs = new HashMap<MDSInstance, MdsTransaction>();
                context.set(txs);
            }
            if ((mdsTransaction = txs.get(mdsInstance)) == null) {
                mdsTransaction = new MdsTransaction(mdsInstance, label);
                txs.put(mdsInstance, mdsTransaction);
            }
        }
        return mdsTransaction;
    }

    public static MdsTransaction getCurrentTransaction(@Nullable MDSInstance mdsInstance) {
        return MdsTransactionUtil.getCurrentTransaction(mdsInstance, null);
    }

    public static void releaseCurrentTransaction(@NotNull MDSInstance mdsInstance, boolean force) {
        MdsTransaction mdsTransaction;
        if (mdsInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsTransactionUtil.releaseCurrentTransaction must not be null");
        }
        Map<MDSInstance, MdsTransaction> txs = context.get();
        if (txs != null && (mdsTransaction = txs.get(mdsInstance)) != null && (force || mdsTransaction.isCommited() || mdsTransaction.isRollback())) {
            context.remove();
        }
    }

    public static void releaseCurrentTransaction(@NotNull MDSInstance mdsInstance) {
        if (mdsInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsTransactionUtil.releaseCurrentTransaction must not be null");
        }
        MdsTransactionUtil.releaseCurrentTransaction(mdsInstance, false);
    }
}

