/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.mds.persistence;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.bpm.collections.Predicate;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.CopyOnWriteFS;
import oracle.bpm.io.fs.MdsDraftProjectRepository;
import oracle.bpm.io.fs.MdsProjectRepository;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.io.fs.mds.MdsFileSystem;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.MdTree;
import oracle.bpm.metadata.artifact.jaxb.CowFilesystem;
import oracle.bpm.metadata.artifact.jaxb.Filesystem;
import oracle.bpm.metadata.artifact.jaxb.MetadataType;
import oracle.bpm.metadata.artifact.jaxb.PendingToDeployMetadata;
import oracle.bpm.metadata.artifact.jaxb.ProjectType;
import oracle.bpm.metadata.artifact.jaxb.PublicShareMetadata;
import oracle.bpm.metadata.artifact.jaxb.Topology;
import oracle.bpm.metadata.entity.DraftProject;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.entity.ProjectToDeploy;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.TemplateProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.exception.MetadataExceptionFactory;
import oracle.bpm.metadata.impl.DraftProjectImpl;
import oracle.bpm.metadata.impl.MetadataArtifactBuilder;
import oracle.bpm.metadata.impl.MetadataArtifactHelper;
import oracle.bpm.metadata.impl.ProjectArtifactFactory;
import oracle.bpm.metadata.impl.PublicShareProjectExt;
import oracle.bpm.metadata.lock.jaxb.LockType;
import oracle.bpm.metadata.mds.MdsTransaction;
import oracle.bpm.metadata.mds.persistence.MdQueryHelper;
import oracle.bpm.metadata.mds.utils.MdsTransactionUtil;
import oracle.bpm.metadata.mds.utils.Utils;
import oracle.bpm.metadata.persistence.MdPersistence;
import oracle.bpm.metadata.persistence.PersistenceException;
import oracle.bpm.metadata.update.PropertyKeys;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.util.HashUtils;
import oracle.mds.core.MDSInstance;
import oracle.mds.query.DocumentResult;
import oracle.mds.query.QueryResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MdsMdPersistence
implements MdPersistence {
    private MDSInstance mdsInstance;
    private Map<ProjectType, MdsProjectRepository> repositories;

    public MdsMdPersistence(@NotNull MDSInstance instance) {
        if (instance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.<init> must not be null");
        }
        this.repositories = new HashMap<ProjectType, MdsProjectRepository>();
        this.mdsInstance = instance;
        this.repositories.put(ProjectType.TEMPLATE, new MdsProjectRepository(instance, MetadataArtifactHelper.getRelativePathFrom(ProjectType.TEMPLATE)));
        this.repositories.put(ProjectType.PUBLIC_SHARED, new MdsProjectRepository(instance, MetadataArtifactHelper.getRelativePathFrom(ProjectType.PUBLIC_SHARED)));
        this.repositories.put(ProjectType.DEPLOY, new MdsProjectRepository(instance, MetadataArtifactHelper.getRelativePathFrom(ProjectType.DEPLOY)));
        this.repositories.put(ProjectType.DRAFT, new MdsDraftProjectRepository(instance, MetadataArtifactHelper.getRelativePathFrom(ProjectType.DRAFT)));
        this.repositories.put(ProjectType.PENDING_TO_DEPLOY, new MdsProjectRepository(instance, MetadataArtifactHelper.getRelativePathFrom(ProjectType.PENDING_TO_DEPLOY)));
    }

    @Override
    public <T extends MdProject, K extends ProjectArtifact> T findProjectByName(final @NotNull Class<T> mdType, @Nullable LocalRef<K> parent, final @NotNull String name, boolean includeFolders) throws PersistenceException {
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.findProjectByName must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.findProjectByName must not be null");
        }
        MdQueryHelper.FindFilter<DocumentResult> filter = new MdQueryHelper.FindFilter<DocumentResult>(){

            @Override
            public boolean accept(@NotNull DocumentResult document) throws PersistenceException {
                boolean result = false;
                LinkedList parts = VFileUtils.canonicalDecomposition((String)document.getDocumentName().getAbsoluteName());
                if (parts.size() > 3 && DraftProjectImpl.class.equals((Object)mdType) || parts.size() > 2) {
                    String projectName;
                    parts.removeLast();
                    if (mdType.isAssignableFrom(DraftProjectImpl.class)) {
                        parts.removeLast();
                    }
                    if ((projectName = (String)parts.removeLast()).length() > 1 && projectName.endsWith("/")) {
                        projectName = projectName.substring(0, projectName.length() - 1);
                    }
                    result = name.equals(projectName);
                }
                return result;
            }
        };
        Collection<DocumentResult> documentList = MdQueryHelper.findMdProject(this.mdsInstance, mdType, parent, filter, includeFolders, true);
        T result = null;
        if (documentList.size() == 1) {
            DocumentResult documentResult = documentList.iterator().next();
            String documentLocation = documentResult.getResourceName().getPackageName();
            String relativePath = this.getRelativePath(mdType, documentLocation);
            result = this.documentToMetadata(mdType, relativePath);
        }
        return result;
    }

    @Override
    public DraftProject createDraftProject(@NotNull PublicShareProject publicShareProject, @NotNull String username) throws PersistenceException {
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.createDraftProject must not be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.createDraftProject must not be null");
        }
        MetadataType parentMetadata = this.loadMetadataArtifact(PublicShareProject.class, publicShareProject.getFolder().get());
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        String relativeDraftLocation = publicShareProject.getFolder().get().getLocation();
        try {
            tx.begin();
            String baseLocation = MetadataArtifactHelper.getRelativePathFrom(ProjectType.DRAFT);
            String draftLocation = relativeDraftLocation + "/" + HashUtils.generateMd5((String)username);
            String absoluteProjectLocation = baseLocation + "/" + draftLocation;
            MetadataType metadataArtifact = MetadataArtifactBuilder.create(parentMetadata, absoluteProjectLocation);
            MdsFileSystem draftFileSystem = new MdsFileSystem(this.mdsInstance, absoluteProjectLocation);
            this.saveMetadataArtifact(DraftProject.class, draftFileSystem, metadataArtifact);
            DraftProjectImpl draftProject = new DraftProjectImpl(this, draftLocation, metadataArtifact);
            draftFileSystem.flush();
            tx.commit();
            return draftProject;
        }
        catch (PersistenceException e) {
            tx.rollback();
            throw e;
        }
        catch (MetadataException e) {
            tx.rollback();
            throw PersistenceException.createIOException(e);
        }
        catch (IOException e) {
            tx.rollback();
            throw PersistenceException.createIOException(e);
        }
    }

    @Override
    public <T extends MdProject> MetadataType saveMdProject(@NotNull Class<T> type, @NotNull String name, @Nullable String description, @NotNull String absoluteLocation, @NotNull Project sourceProject, @NotNull VFileSystem targetFs) throws PersistenceException {
        MetadataType metadataArtifact;
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.saveMdProject must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.saveMdProject must not be null");
        }
        if (absoluteLocation == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.saveMdProject must not be null");
        }
        if (sourceProject == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.saveMdProject must not be null");
        }
        if (targetFs == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.saveMdProject must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            ProjectLoader loader = sourceProject.getLoader();
            assert (loader != null);
            VFileSystem sourceFilesystem = loader.getProjectFileSystem().getDataFileSystem();
            Utils.copyFs(sourceFilesystem, targetFs);
            metadataArtifact = MetadataArtifactBuilder.create(name, description, absoluteLocation);
            ProjectType projectType = MetadataArtifactHelper.getProjectType(type);
            metadataArtifact.setProjectType(projectType);
            this.saveMetadataArtifact(type, targetFs, metadataArtifact);
            Utils.writeJprFile(sourceProject, name, targetFs);
            tx.commit();
        }
        catch (PersistenceException e) {
            tx.rollback();
            throw e;
        }
        catch (MetadataException e) {
            tx.rollback();
            throw PersistenceException.createIOException(e);
        }
        catch (IOException e) {
            tx.rollback();
            throw PersistenceException.createIOException(e);
        }
        return metadataArtifact;
    }

    @Override
    public PublicShareProject createPublicShareProject(@NotNull PublicShareProject publicShare, @NotNull String absoluteLocation, @NotNull VFileSystem targetFs, @Nullable PublicShareMetadata baseMetadataArtifact) throws PersistenceException {
        PublicShareProjectExt ret;
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.createPublicShareProject must not be null");
        }
        if (absoluteLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.createPublicShareProject must not be null");
        }
        if (targetFs == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.createPublicShareProject must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            Project project = publicShare.getProject().get();
            ProjectLoader loader = project.getLoader();
            assert (loader != null);
            VFileSystem vFileSystem = loader.getProjectFileSystem().getDataFileSystem();
            Utils.copyFs(vFileSystem, targetFs);
            Utils.writeCompositeFile(publicShare.getName(), targetFs);
            Utils.writeJprFile(project, publicShare.getName(), targetFs);
            PublicShareMetadata metadataArtifact = MetadataArtifactBuilder.create(publicShare, absoluteLocation);
            if (baseMetadataArtifact != null) {
                MetadataArtifactBuilder.deepCopy(baseMetadataArtifact, metadataArtifact);
            }
            this.saveMetadataArtifact(PublicShareProject.class, targetFs, metadataArtifact);
            String relativeLocation = this.getRelativePath(PublicShareProject.class, absoluteLocation);
            ret = new PublicShareProjectExt(this, relativeLocation, metadataArtifact);
            ret.setUpToDateFromBaseTemplate(true);
            tx.commit();
        }
        catch (PersistenceException e) {
            tx.rollback();
            throw e;
        }
        catch (MetadataException e) {
            tx.rollback();
            throw PersistenceException.createIOException(e);
        }
        catch (IOException e) {
            tx.rollback();
            throw PersistenceException.createIOException(e);
        }
        return ret;
    }

    @Override
    public <T extends MdProject> boolean existsFolder(@NotNull Class<T> context, @NotNull ProjectFolder location) throws PersistenceException {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.existsFolder must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.existsFolder must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        String basePath = MetadataArtifactHelper.getRelativePathFrom(MetadataArtifactHelper.getProjectType(context));
        String path = basePath + "/" + location.getLocation();
        return tx.existsPackage(path);
    }

    @Override
    public <T extends MdProject> boolean existsProject(@NotNull Class<T> mdType, @NotNull ProjectFolder projectPath) throws PersistenceException {
        Collection<DocumentResult> documentList;
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.existsProject must not be null");
        }
        if (projectPath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.existsProject must not be null");
        }
        try {
            String location = MetadataArtifactHelper.getRelativePathFrom(MetadataArtifactHelper.getProjectType(mdType));
            if (!location.endsWith("/") && !projectPath.getLocation().startsWith("/")) {
                location = location + "/";
            }
            location = location + projectPath.getLocation();
            final ProjectFolder locationFolder = ProjectFolder.create(location);
            MdQueryHelper.FindFilter<DocumentResult> filter = new MdQueryHelper.FindFilter<DocumentResult>(){

                @Override
                public boolean accept(@NotNull DocumentResult document) throws PersistenceException {
                    ProjectFolder folder = ProjectFolder.create(document.getDocumentName().getPackageName());
                    return locationFolder.equals(folder);
                }
            };
            documentList = MdQueryHelper.findMdProject(this.mdsInstance, mdType, projectPath.getLocalRef(), filter, true, true);
        }
        catch (MetadataException e) {
            throw new PersistenceException(e);
        }
        return !documentList.isEmpty();
    }

    @Override
    public <T extends MdProject> void createFolder(@NotNull Class<T> context, @NotNull ProjectFolder location) throws PersistenceException {
        String basePath;
        String path;
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.createFolder must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.createFolder must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        if (tx.existsPackage(path = (basePath = MetadataArtifactHelper.getRelativePathFrom(MetadataArtifactHelper.getProjectType(context))) + "/" + location.getLocation())) {
            throw PersistenceException.createPackageAlreadyExists(location.getLocation());
        }
        tx.createPackage(path);
    }

    @Override
    public <T extends MdProject> void removeFolder(@NotNull Class<T> mdType, @NotNull ProjectFolder folder, boolean recursive) throws PersistenceException {
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.removeFolder must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.removeFolder must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        String absoluteLocation = this.folderToLocation(MetadataArtifactHelper.getProjectType(mdType), folder);
        String normalizePath = VFileUtils.getCanonicalPath((String)absoluteLocation);
        tx.deletePackage(normalizePath, recursive);
    }

    @Override
    public <T extends MdProject> void removeProject(@NotNull Class<T> context, @NotNull ProjectFolder location, @NotNull MetadataType metadata) throws PersistenceException {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.removeProject must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.removeProject must not be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.removeProject must not be null");
        }
        this.removeFolder(context, location, true);
        this.releaseFromCache(metadata);
    }

    @Override
    public void commitChanges(@NotNull MetadataType metadata) throws PersistenceException {
        if (metadata == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.commitChanges must not be null");
        }
        try {
            Topology topology = metadata.getTopology();
            Filesystem filesystem = topology.getFilesystem();
            VFileSystem vfs = Utils.createVFileSystem(this.mdsInstance, filesystem);
            if (vfs instanceof CopyOnWriteFS) {
                CopyOnWriteFS cowFilesystem = (CopyOnWriteFS)vfs;
                VFileSystem readFS = cowFilesystem.getReadFileSystem();
                VFileSystem writeFS = cowFilesystem.getWriteFileSystem();
                Utils.copyFs(writeFS, readFS);
                Collection deletedFiles = cowFilesystem.getDeletedFiles();
                for (VFile file : deletedFiles) {
                    VFile targetFile = readFS.createFile(file.getCanonicalPath());
                    targetFile.delete();
                }
            }
        }
        catch (IOException e) {
            throw PersistenceException.createIOException(e);
        }
    }

    @Override
    public void releaseFromCache(@NotNull MetadataType metadata) throws PersistenceException {
        if (metadata == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.releaseFromCache must not be null");
        }
        try {
            MdsProjectRepository repository = this.getRepository(metadata.getProjectType());
            Project project = repository.getProject(metadata.getName());
            if (project != null) {
                repository.delete(project);
            }
        }
        catch (ProjectException e) {
            throw PersistenceException.createProjectException(metadata.getName(), e);
        }
    }

    @Override
    public void saveMdProject(@NotNull MdProject mdProject, @NotNull ProjectType projectType) throws PersistenceException {
        Project project;
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.saveMdProject must not be null");
        }
        if (projectType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.saveMdProject must not be null");
        }
        try {
            project = mdProject.getProject().get();
        }
        catch (MetadataException e) {
            throw (PersistenceException)e;
        }
        MdsProjectRepository repository = this.getRepository(projectType);
        try {
            repository.flushChanges(project.getName());
        }
        catch (ProjectException e) {
            ProjectFolder folder = mdProject.getFolder().get();
            throw PersistenceException.createProjectException(folder.getLocation(), e);
        }
    }

    @Override
    public LocalRef<Project> loadProject(@NotNull MetadataType metadata) throws MetadataException {
        if (metadata == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.loadProject must not be null");
        }
        ProjectType projectType = metadata.getProjectType();
        assert (projectType != null);
        MdsProjectRepository repository = this.getRepository(projectType);
        Project project = repository.getProject(metadata.getName());
        if (project == null) {
            try {
                project = repository.loadProject(metadata);
            }
            catch (ProjectException e) {
                throw PersistenceException.createProjectException(metadata.getName(), e);
            }
        }
        return new LocalRef<Project>(metadata.getName(), project);
    }

    @Override
    public void prepareProjectToDeploy(@NotNull PublicShareProject publicShare, @NotNull String workflowTicket, @NotNull ProjectFolder folder) throws PersistenceException {
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.prepareProjectToDeploy must not be null");
        }
        if (workflowTicket == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.prepareProjectToDeploy must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.prepareProjectToDeploy must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            String normalizedUrl = VFileUtils.getCanonicalPath((String)this.folderToLocation(ProjectType.PENDING_TO_DEPLOY, folder));
            Project project = publicShare.getProject().get();
            ProjectLoader loader = project.getLoader();
            assert (loader != null);
            VFileSystem vFileSystem = loader.getProjectFileSystem().getDataFileSystem();
            VFileSystem filesystem = Utils.copyProjectToLocation(this.mdsInstance, vFileSystem, normalizedUrl);
            PendingToDeployMetadata pendingToDeployMetadata = MetadataArtifactBuilder.create(publicShare.getName(), publicShare.getDescription(), normalizedUrl, workflowTicket);
            this.saveMetadataArtifact(ProjectToDeploy.class, filesystem, pendingToDeployMetadata);
            filesystem.flush();
            tx.commit();
        }
        catch (PersistenceException e) {
            tx.rollback();
            throw e;
        }
        catch (MetadataException e) {
            tx.rollback();
            throw PersistenceException.createIOException(e);
        }
        catch (IOException e) {
            tx.rollback();
            throw PersistenceException.createIOException(e);
        }
    }

    @Override
    public void acquireLock(@NotNull VFileSystem fileSystem, @NotNull LockType lockType) throws PersistenceException {
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.acquireLock must not be null");
        }
        if (lockType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.acquireLock must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            MetadataArtifactBuilder.saveArtifact(fileSystem, "project.lock", lockType);
            fileSystem.flush();
            tx.commit();
        }
        catch (IOException e) {
            tx.rollback();
            throw PersistenceException.createIOException(e);
        }
    }

    @Override
    public void releaseLock(@NotNull PublicShareProject publicShareProject) throws PersistenceException {
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.releaseLock must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        try {
            tx.begin();
            Project project = publicShareProject.getProject().get();
            ProjectLoader loader = project.getLoader();
            assert (loader != null);
            ProjectFileSystem fileSystem = loader.getProjectFileSystem();
            VFileSystem dataFileSystem = fileSystem.getDataFileSystem();
            VFile file = dataFileSystem.createFile("project.lock");
            file.delete();
            dataFileSystem.flush();
            tx.commit();
        }
        catch (IOException e) {
            tx.rollback();
            throw PersistenceException.createIOException(e);
        }
        catch (MetadataException e) {
            tx.rollback();
            throw new PersistenceException(e);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public LockType getLock(@NotNull VFileSystem fileSystem) throws PersistenceException {
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.getLock must not be null");
        }
        VFileInputStream input = null;
        LockType ret = null;
        try {
            VFile file = fileSystem.createFile("project.lock");
            input = new VFileInputStream(file);
            ret = MetadataArtifactHelper.deserializeLock((InputStream)input);
        }
        catch (FileNotFoundException e) {
            StreamUtils.close((Closeable[])new Closeable[]{input});
        }
        catch (IOException e2) {
            throw PersistenceException.createIOException(e2);
            {
                catch (Throwable throwable) {
                    StreamUtils.close((Closeable[])new Closeable[]{input});
                    throw throwable;
                }
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{input});
        return ret;
    }

    /*
     * Loose catch block
     */
    @Override
    public LockType getLock(@NotNull MetadataType metadataType) throws PersistenceException {
        if (metadataType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.getLock must not be null");
        }
        VFileInputStream input = null;
        LockType ret = null;
        try {
            String rootFileSystem;
            Topology topology = metadataType.getTopology();
            if (ProjectType.DRAFT.equals((Object)metadataType.getProjectType())) {
                CowFilesystem cowFilesystem = topology.getFilesystem().getCowFilesystem();
                rootFileSystem = cowFilesystem.getRead().getSimpleFilesystem();
            } else {
                rootFileSystem = topology.getFilesystem().getSimpleFilesystem();
            }
            MdsFileSystem fileSystem = new MdsFileSystem(this.mdsInstance, rootFileSystem);
            VFile file = fileSystem.createFile("project.lock");
            input = new VFileInputStream(file);
            ret = MetadataArtifactHelper.deserializeLock((InputStream)input);
        }
        catch (FileNotFoundException e) {
            StreamUtils.close((Closeable[])new Closeable[]{input});
        }
        catch (IOException e2) {
            throw PersistenceException.createIOException(e2);
            {
                catch (Throwable throwable) {
                    StreamUtils.close((Closeable[])new Closeable[]{input});
                    throw throwable;
                }
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{input});
        return ret;
    }

    @Override
    public <T extends MdProject> MetadataType loadMetadataArtifact(@NotNull Class<T> mdType, @NotNull ProjectFolder folder) throws PersistenceException {
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.loadMetadataArtifact must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.loadMetadataArtifact must not be null");
        }
        MdsFileSystem filesystem = new MdsFileSystem(this.mdsInstance, this.folderToLocation(MetadataArtifactHelper.getProjectType(mdType), folder));
        return MetadataArtifactHelper.getMetadataArtifact(filesystem, mdType, "/");
    }

    @Override
    public <T extends MdProject> void saveMetadataArtifact(@NotNull Class<T> mdType, @NotNull VFileSystem filesystem, @NotNull MetadataType metadata) throws PersistenceException {
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.saveMetadataArtifact must not be null");
        }
        if (filesystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.saveMetadataArtifact must not be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.saveMetadataArtifact must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        try {
            tx.begin();
            MetadataArtifactBuilder.saveMetadataArtifact(mdType, filesystem, metadata);
            tx.commit();
        }
        catch (PersistenceException e) {
            tx.rollback();
            throw PersistenceException.createIOException((Throwable)((Object)e));
        }
    }

    @Override
    public <T extends MdProject> LocalRef<T> getMdProject(@NotNull Class<T> type, @NotNull String projectLocation, @NotNull MetadataType metadata) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.getMdProject must not be null");
        }
        if (projectLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.getMdProject must not be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.getMdProject must not be null");
        }
        this.releaseFromCache(metadata);
        T artifact = this.createMdProject(type, projectLocation, metadata);
        return new LocalRef<T>(metadata.getName(), artifact);
    }

    @Override
    public <T extends MdProject> LocalRef<T> loadMdProject(@NotNull Class<T> type, @NotNull String projectLocation, boolean reload) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.loadMdProject must not be null");
        }
        if (projectLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.loadMdProject must not be null");
        }
        ProjectFolder projectLocationFolder = ProjectFolder.create(projectLocation);
        MetadataType metadata = this.loadMetadataArtifact(type, projectLocationFolder);
        if (metadata == null) {
            throw MetadataExceptionFactory.createProjectNotFound((String)projectLocation);
        }
        if (reload) {
            this.releaseFromCache(metadata);
        }
        T artifact = this.createMdProject(type, projectLocation, metadata);
        return new LocalRef<T>(metadata.getName(), artifact);
    }

    @Override
    public <T extends MdProject, K extends ProjectArtifact> Collection<LocalRef<T>> find(final @NotNull Class<T> mdType, @Nullable LocalRef<K> parent, final @Nullable Predicate<T> predicate, boolean includeFolders) throws PersistenceException {
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.find must not be null");
        }
        final ArrayList<LocalRef<T>> result = new ArrayList<LocalRef<T>>();
        MdQueryHelper.FindFilter<QueryResult> filter = new MdQueryHelper.FindFilter<QueryResult>(){

            @Override
            public boolean accept(@NotNull QueryResult queryResult) throws PersistenceException {
                boolean accepted = false;
                String location = queryResult.getResourceName().getPackageName();
                String relativePath = MdsMdPersistence.this.getRelativePath(mdType, location);
                MdProject artifact = MdsMdPersistence.this.documentToMetadata(mdType, relativePath);
                if (artifact != null && (predicate == null || predicate.check((Object)artifact))) {
                    result.add(new LocalRef<MdProject>(artifact.getName(), artifact));
                    accepted = true;
                }
                return accepted;
            }
        };
        MdQueryHelper.findMdProject(this.mdsInstance, mdType, parent, filter, includeFolders, false);
        return result;
    }

    @Override
    public <T extends MdProject> MdTree browseFolders(@NotNull Class<T> mdType, @Nullable Predicate<String> predicate) throws PersistenceException {
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.browseFolders must not be null");
        }
        return MdQueryHelper.createFolderTree(this.mdsInstance, mdType, predicate);
    }

    @Override
    public <T extends MdProject> MdTree browseFolders(@NotNull Class<T> mdType) throws PersistenceException {
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.browseFolders must not be null");
        }
        return this.browseFolders(mdType, null);
    }

    @Override
    public <T extends MdProject, K extends ProjectArtifact> MdTree browse(final @NotNull Class<T> mdType, @Nullable LocalRef<K> parent, final @Nullable Predicate<T> predicate, boolean includeFolders) throws PersistenceException {
        MdTree result;
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.browse must not be null");
        }
        final HashMap loadedArtifact = new HashMap();
        final HashMap skippedArtifact = new HashMap();
        MdQueryHelper.FindFilter<QueryResult> filter = new MdQueryHelper.FindFilter<QueryResult>(){

            @Override
            public boolean accept(@NotNull QueryResult queryResult) throws PersistenceException {
                boolean accepted;
                boolean bl = accepted = !queryResult.isDocument();
                if (queryResult.isDocument()) {
                    ProjectType type;
                    String location = queryResult.getResourceName().getPackageName();
                    String relativePath = MdsMdPersistence.this.getRelativePath(location, type = MetadataArtifactHelper.getProjectType(mdType));
                    MdProject artifact = MdsMdPersistence.this.documentToMetadata(mdType, relativePath);
                    accepted = artifact != null && (predicate == null || predicate.check((Object)artifact));
                    String path = artifact.getFolder().get().getLocation();
                    if (accepted) {
                        loadedArtifact.put(path, artifact);
                    } else {
                        skippedArtifact.put(path, artifact);
                    }
                }
                return accepted;
            }
        };
        Collection<QueryResult> resources = MdQueryHelper.findResources(this.mdsInstance, mdType, parent, filter, includeFolders, false);
        if (predicate == null || includeFolders) {
            result = this.createTree(mdType, loadedArtifact, skippedArtifact, resources);
        } else {
            result = new MdTree();
            for (MdProject artifact : loadedArtifact.values()) {
                result.insert(artifact);
            }
        }
        return result;
    }

    public <T extends MdProject> MdTree createTree(@NotNull Class<T> mdType, @NotNull Map<String, T> loadedArtifact, @NotNull Map<String, T> skippedArtifact, @NotNull Collection<QueryResult> queryResult) throws PersistenceException {
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.createTree must not be null");
        }
        if (loadedArtifact == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.createTree must not be null");
        }
        if (skippedArtifact == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.createTree must not be null");
        }
        if (queryResult == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.createTree must not be null");
        }
        MdTree tree = new MdTree();
        ArrayList<String> artifactsPaths = new ArrayList<String>();
        ArrayList<String> projectsPaths = new ArrayList<String>();
        String pathFrom = MetadataArtifactHelper.getRelativePathFrom(MetadataArtifactHelper.getProjectType(mdType));
        for (QueryResult result : queryResult) {
            String location = result.getResourceName().getPackageName();
            String relativeLocation = location.substring(pathFrom.length());
            if (result.getResultType() == QueryResult.ResultType.MO_RESULT) {
                projectsPaths.add(relativeLocation);
                continue;
            }
            artifactsPaths.add(result.getAbsoluteName().substring(pathFrom.length()));
        }
        Collections.sort(artifactsPaths);
        Collections.sort(projectsPaths);
        int idx = 0;
        for (String artifactsPath : artifactsPaths) {
            ProjectFolder folder;
            boolean skip;
            String projectPath = this.getNextProjectPath(projectsPaths, idx);
            if (projectPath != null && artifactsPath.equals(projectPath)) {
                tree.insert((MdProject)loadedArtifact.get(projectPath));
                continue;
            }
            if (projectPath != null) {
                if (artifactsPath.startsWith(projectPath + "/")) continue;
                if (artifactsPath.compareTo(projectPath) > 0) {
                    projectPath = this.getNextProjectPath(projectsPaths, ++idx);
                }
                if (projectPath != null && artifactsPath.equals(projectPath)) {
                    tree.insert((MdProject)loadedArtifact.get(projectPath));
                    continue;
                }
                skip = this.isSkipped(skippedArtifact, artifactsPath);
                if (skip) continue;
                folder = ProjectFolder.create(artifactsPath);
                tree.insert(folder);
                continue;
            }
            skip = this.isSkipped(skippedArtifact, artifactsPath);
            if (skip) continue;
            folder = ProjectFolder.create(artifactsPath);
            tree.insert(folder);
        }
        return tree;
    }

    private MdsProjectRepository getRepository(ProjectType projectType) {
        MdsProjectRepository repository = projectType == ProjectType.SNAPSHOT ? new MdsProjectRepository(this.mdsInstance, MetadataArtifactHelper.getRelativePathFrom(ProjectType.SNAPSHOT)) : this.repositories.get((Object)projectType);
        return repository;
    }

    private <T extends MdProject> boolean isSkipped(@NotNull Map<String, T> skippedArtifact, @NotNull String path) {
        int pos;
        if (skippedArtifact == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.isSkipped must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.isSkipped must not be null");
        }
        boolean isSkipped = skippedArtifact.containsKey(path);
        if (!isSkipped && (pos = path.lastIndexOf("/")) > 0) {
            do {
                String relativePath = path.substring(0, pos);
                isSkipped = skippedArtifact.containsKey(relativePath);
                pos = path.lastIndexOf("/", pos - 1);
            } while (!isSkipped && pos > 0);
        }
        return isSkipped;
    }

    private <T extends MdProject> String getRelativePath(@NotNull Class<T> mdType, String absoluteLocation) {
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.getRelativePath must not be null");
        }
        ProjectType type = MetadataArtifactHelper.getProjectType(mdType);
        String pathFrom = MetadataArtifactHelper.getRelativePathFrom(type);
        return absoluteLocation.substring(pathFrom.length());
    }

    private String getRelativePath(String location, ProjectType type) {
        String pathFrom = MetadataArtifactHelper.getRelativePathFrom(type);
        return location.substring(pathFrom.length());
    }

    private String getNextProjectPath(@NotNull List<String> projectsPaths, int idx) {
        if (projectsPaths == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.getNextProjectPath must not be null");
        }
        String projectPath = null;
        if (idx < projectsPaths.size()) {
            projectPath = projectsPaths.get(idx);
        }
        return projectPath;
    }

    private <T extends MdProject> T documentToMetadata(@NotNull Class<T> mdType, @NotNull String projectLocation) throws PersistenceException {
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.documentToMetadata must not be null");
        }
        if (projectLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.documentToMetadata must not be null");
        }
        T result = null;
        T artifact = this.createMdProject(mdType, projectLocation, null);
        ProjectType projectType = MetadataArtifactHelper.getProjectType(mdType);
        if (projectType.equals((Object)MetadataArtifactHelper.getProjectType(mdType))) {
            result = artifact;
        }
        return result;
    }

    private String folderToLocation(@NotNull ProjectType type, @NotNull ProjectFolder folder) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.folderToLocation must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.folderToLocation must not be null");
        }
        String baseLocation = MetadataArtifactHelper.getRelativePathFrom(type);
        StringBuilder absolutePath = new StringBuilder(baseLocation);
        absolutePath.append("/").append(folder.getLocation());
        return absolutePath.toString();
    }

    private <T extends MdProject> T createMdProject(@NotNull Class<T> clazz, @NotNull String projectLocation, @Nullable MetadataType metadata) throws PersistenceException {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.createMdProject must not be null");
        }
        if (projectLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.createMdProject must not be null");
        }
        T artifact = ProjectArtifactFactory.create(clazz, projectLocation, this, metadata);
        if (PublicShareProject.class.equals(clazz)) {
            PublicShareProjectExt publicShared = (PublicShareProjectExt)artifact;
            ProjectFolder folder = publicShared.getFolder().get();
            try {
                MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
                String location = this.folderToLocation(ProjectType.PUBLIC_SHARED, folder);
                location = location + "/" + "project.lock";
                publicShared.setIsLock(tx.existsFile(location));
                boolean isUpToDateFromBaseTemplate = this.isPublicShareUpToDateFromBaseTemplate(publicShared.getId());
                publicShared.setUpToDateFromBaseTemplate(isUpToDateFromBaseTemplate);
            }
            catch (MetadataException e) {
                throw new PersistenceException(e);
            }
        }
        return artifact;
    }

    private boolean isPublicShareUpToDateFromBaseTemplate(@NotNull String publicShareId) throws MetadataException {
        long templateRevisionDate;
        if (publicShareId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdsMdPersistence.isPublicShareUpToDateFromBaseTemplate must not be null");
        }
        MetadataType publicShareMetadata = this.loadMetadataArtifact(PublicShareProject.class, ProjectFolder.create(publicShareId));
        MetadataType.Properties.Property actualHistoryIdProperty = MetadataArtifactHelper.findProperty(publicShareMetadata, PropertyKeys.HISTORY_REVISION_ID.getKey());
        MetadataType.Properties.Property baseTemplateIdProperty = MetadataArtifactHelper.findProperty(publicShareMetadata, PropertyKeys.BASE_TEMPLATE_ID.getKey());
        if (actualHistoryIdProperty == null || baseTemplateIdProperty == null) {
            return true;
        }
        String actualRevisionId = actualHistoryIdProperty.getValue();
        String baseTemplateId = baseTemplateIdProperty.getValue();
        MetadataType templateMetadata = this.loadMetadataArtifact(TemplateProject.class, ProjectFolder.create(baseTemplateId));
        if (templateMetadata == null) {
            return true;
        }
        MetadataType.Properties.Property templateRevisionIdProperty = MetadataArtifactHelper.findProperty(templateMetadata, PropertyKeys.HISTORY_REVISION_ID.getKey());
        if (templateRevisionIdProperty == null) {
            throw MetadataExceptionFactory.createUnableToUpdateFromBaseTemplate((String)templateMetadata.getName());
        }
        String templateRevisionId = templateRevisionIdProperty.getValue();
        if ("".equals(templateRevisionId)) {
            return true;
        }
        long actualRevisionDate = Long.parseLong(actualRevisionId);
        return actualRevisionDate >= (templateRevisionDate = Long.parseLong(templateRevisionId));
    }
}

