/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.mds.persistence;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import oracle.bpm.collections.Predicate;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.Cast;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.MdTree;
import oracle.bpm.metadata.artifact.jaxb.ProjectType;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.impl.MetadataArtifactHelper;
import oracle.bpm.metadata.mds.Namespace;
import oracle.bpm.metadata.mds.utils.MdsUtils;
import oracle.bpm.metadata.persistence.PersistenceException;
import oracle.mds.core.MDSInstance;
import oracle.mds.core.MDSSession;
import oracle.mds.query.Condition;
import oracle.mds.query.ConditionFactory;
import oracle.mds.query.DocumentQuery;
import oracle.mds.query.DocumentResult;
import oracle.mds.query.Query;
import oracle.mds.query.QueryFactory;
import oracle.mds.query.QueryResult;
import oracle.mds.query.ResourceQuery;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MdQueryHelper {
    private static final String ON_STATE = "on";
    private static final String ACTIVE_MODE = "active";
    private static final String FOLDERS_FILE = "folders.xml";
    private static final QName FOLDER_TAG = new QName("folder");
    private static final QName NAME_ATTRIBUTE = new QName("name");
    private static final QName STATE_ATTRIBUTE = new QName("state");
    private static final QName MODE_ATTRIBUTE = new QName("mode");
    private static final String MATCH_ALL_WILDCARD = "%";

    MdQueryHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends MdProject, K extends ProjectArtifact> Collection<QueryResult> findResources(@NotNull MDSInstance mdsInstance, @NotNull Class<T> mdType, @Nullable LocalRef<K> parent, @Nullable FindFilter filter, boolean includeFolders, boolean stopOnFirstFound) throws PersistenceException {
        if (mdsInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdQueryHelper.findResources must not be null");
        }
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdQueryHelper.findResources must not be null");
        }
        ResourceQuery resourceQuery = null;
        ArrayList<QueryResult> result = new ArrayList<QueryResult>();
        String location = MetadataArtifactHelper.getFullPath(mdType, parent);
        try {
            Condition nameCondition = MdQueryHelper.createProjectMetadataCondition(includeFolders, location);
            resourceQuery = QueryFactory.createResourceQuery((MDSInstance)mdsInstance, (Condition)nameCondition);
            MdQueryHelper.processQueryResult(filter, stopOnFirstFound, (Query)resourceQuery, result);
        }
        catch (Throwable throwable) {
            MdsUtils.closeQuery(resourceQuery);
            throw throwable;
        }
        MdsUtils.closeQuery((Query)resourceQuery);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends MdProject, K extends ProjectArtifact> Collection<DocumentResult> findMdProject(@NotNull MDSInstance mdsInstance, @NotNull Class<T> mdType, @Nullable LocalRef<K> parent, @Nullable FindFilter filter, boolean includeFolders, boolean stopOnFirstFound) throws PersistenceException {
        if (mdsInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdQueryHelper.findMdProject must not be null");
        }
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdQueryHelper.findMdProject must not be null");
        }
        DocumentQuery resourceQuery = null;
        ArrayList<DocumentResult> result = new ArrayList<DocumentResult>();
        String location = MetadataArtifactHelper.getFullPath(mdType, parent);
        Condition nameCondition = MdQueryHelper.createProjectMetadataCondition(includeFolders, location);
        try {
            resourceQuery = QueryFactory.createDocumentQuery((MDSInstance)mdsInstance, (Condition)nameCondition);
            MdQueryHelper.processQueryResult(filter, stopOnFirstFound, (Query)resourceQuery, result);
        }
        finally {
            MdsUtils.closeQuery((Query)resourceQuery);
        }
        return result;
    }

    public static <T extends MdProject> MdTree createFolderTree(@NotNull MDSInstance mdsInstance, @NotNull Class<T> mdType, @Nullable Predicate<String> predicate) throws PersistenceException {
        MdTree result;
        if (mdsInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdQueryHelper.createFolderTree must not be null");
        }
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdQueryHelper.createFolderTree must not be null");
        }
        if (MetadataArtifactHelper.getProjectType(mdType) == ProjectType.DEPLOY) {
            result = MdQueryHelper.createFolderTreeDeployed(mdsInstance, predicate);
        } else {
            result = new MdTree();
            String location = MetadataArtifactHelper.getFullPath(mdType, null);
            int length = location.length();
            ResourceQuery query = QueryFactory.createResourceQuery((MDSInstance)mdsInstance, (Condition)ConditionFactory.createNameCondition((String)location, (String)MATCH_ALL_WILDCARD, (boolean)true));
            Iterator resultIterator = (Iterator)Cast.force((Object)query.execute());
            HashSet<String> projects = new HashSet<String>();
            HashSet<String> packages = new HashSet<String>();
            while (resultIterator.hasNext()) {
                QueryResult queryResult = (QueryResult)resultIterator.next();
                String resourceName = queryResult.getAbsoluteName().substring(length);
                if (queryResult.getResultType() == QueryResult.ResultType.PACKAGE_RESULT) {
                    packages.add(resourceName);
                    continue;
                }
                if (!resourceName.endsWith("projectMetadata.xml")) continue;
                projects.add(MdQueryHelper.getParentFolder(resourceName));
            }
            Iterator i$ = packages.iterator();
            while (i$.hasNext()) {
                boolean found;
                String pack;
                String parent = pack = (String)i$.next();
                do {
                    parent = MdQueryHelper.getParentFolder(parent);
                    boolean bl = found = projects.contains(pack) || projects.contains(parent);
                } while (parent.length() > 1 && !found);
                if (found) continue;
                ProjectFolder folder = ProjectFolder.create(pack);
                result.insert(folder);
            }
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T extends MdProject> MdTree createFolderTreeDeployed(@NotNull MDSInstance mdsInstance, @Nullable Predicate<String> predicate) throws PersistenceException {
        if (mdsInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdQueryHelper.createFolderTreeDeployed must not be null");
        }
        MdTree result = new MdTree();
        InputStream inputStream = null;
        XMLStreamReader sr = null;
        String location = Namespace.SOAINFRA_CONFIG.getMdsNamespace().getPath() + "/" + FOLDERS_FILE;
        MDSSession mdsSession = mdsInstance.createSession(null, null);
        try {
            inputStream = MdsUtils.openInputStream(mdsSession, location);
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            sr = inputFactory.createXMLStreamReader(inputStream);
            while (sr.hasNext()) {
                QName srName;
                int eventCode = sr.next();
                if (eventCode != 1 || !FOLDER_TAG.equals(srName = sr.getName())) continue;
                int attributeCount = sr.getAttributeCount();
                boolean attributeActive = true;
                String folder = null;
                for (int i = 0; i < attributeCount && attributeActive; ++i) {
                    QName attribute = sr.getAttributeName(i);
                    if (NAME_ATTRIBUTE.equals(attribute)) {
                        folder = sr.getAttributeValue(i);
                        continue;
                    }
                    if (STATE_ATTRIBUTE.equals(attribute)) {
                        attributeActive = ON_STATE.equalsIgnoreCase(sr.getAttributeValue(i));
                        continue;
                    }
                    if (!MODE_ATTRIBUTE.equals(attribute)) continue;
                    attributeActive = ACTIVE_MODE.equalsIgnoreCase(sr.getAttributeValue(i));
                }
                if (!attributeActive || folder == null || predicate != null && (predicate == null || !predicate.check(folder))) continue;
                result.insert(ProjectFolder.create(folder));
            }
            if (inputStream == null) return result;
        }
        catch (FileNotFoundException e) {
            try {
                throw new PersistenceException(e);
                catch (XMLStreamException e2) {
                    throw new PersistenceException(e2);
                }
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                StreamUtils.close((Closeable[])new Closeable[]{inputStream});
                if (sr == null) throw throwable;
                try {
                    sr.close();
                    throw throwable;
                }
                catch (XMLStreamException e3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{inputStream});
        if (sr == null) return result;
        try {
            sr.close();
            return result;
        }
        catch (XMLStreamException e) {
            return result;
        }
    }

    private static <T extends QueryResult> void processQueryResult(@Nullable FindFilter<T> filter, boolean stopOnFirstFound, @NotNull Query resourceQuery, @NotNull Collection<T> result) throws PersistenceException {
        if (resourceQuery == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdQueryHelper.processQueryResult must not be null");
        }
        if (result == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdQueryHelper.processQueryResult must not be null");
        }
        Iterator queryResultIterator = resourceQuery.execute();
        while (queryResultIterator.hasNext()) {
            QueryResult document = (QueryResult)queryResultIterator.next();
            if (filter != null && !filter.accept(document)) continue;
            result.add(document);
            if (!stopOnFirstFound) continue;
            break;
        }
    }

    private static Condition createProjectMetadataCondition(boolean includeFolders, String location) {
        String matchExpression = "%projectMetadata.xml";
        return ConditionFactory.createNameCondition((String)location, (String)"%projectMetadata.xml", (boolean)includeFolders);
    }

    private static String getParentFolder(@NotNull String location) {
        int idx;
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/persistence/MdQueryHelper.getParentFolder must not be null");
        }
        String path = location;
        if (!path.equals("/") && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((idx = path.lastIndexOf("/")) == 0) {
            path = "/";
        } else if (idx > 0) {
            path = path.substring(0, idx);
        }
        return path;
    }

    public static interface FindFilter<T extends QueryResult> {
        public boolean accept(@NotNull T var1) throws PersistenceException;
    }
}

