/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.mds;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import oracle.bpm.metadata.mds.Namespace;
import oracle.mds.config.CacheConfig;
import oracle.mds.config.ContentConfig;
import oracle.mds.config.ContentOptions;
import oracle.mds.config.ContentOptionsMapping;
import oracle.mds.config.MDSConfig;
import oracle.mds.config.MDSConfigurationException;
import oracle.mds.config.NamespaceConfig;
import oracle.mds.config.PConfig;
import oracle.mds.core.MDSInstance;
import oracle.mds.exception.InvalidNamespaceException;
import oracle.mds.exception.MDSException;
import oracle.mds.persistence.MetadataStore;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

public final class MdsInstanceInitializer {
    public static final String OBPM_MDS = Namespace.BPM.getDescription();
    public static final String TASKFLOW_MDS = Namespace.TASKFLOW.getDescription();
    public static final String SOA_INFRA_MDS = Namespace.SOAINFRA.getDescription();

    public static MDSInstance getMDSInstance(@NotNull URL configFile) throws MDSException, MalformedURLException {
        if (configFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/MdsInstanceInitializer.getMDSInstance must not be null");
        }
        return MdsInstanceInitializer.getMDSInstance(OBPM_MDS, configFile);
    }

    public static MDSInstance getMDSInstance(@NotNull String instanceName, @NotNull URL urlConfigFile) throws MDSException {
        if (instanceName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/MdsInstanceInitializer.getMDSInstance must not be null");
        }
        if (urlConfigFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/MdsInstanceInitializer.getMDSInstance must not be null");
        }
        MDSConfig mdsConfig = new MDSConfig(urlConfigFile);
        return MdsInstanceInitializer.getMDSInstance(instanceName, mdsConfig);
    }

    public static MDSInstance getMDSInstance(@NotNull Element configElement) throws MDSException {
        if (configElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/MdsInstanceInitializer.getMDSInstance must not be null");
        }
        MDSConfig mdsConfig = new MDSConfig(configElement);
        return MdsInstanceInitializer.getMDSInstance(OBPM_MDS, mdsConfig);
    }

    public static MDSInstance getMDSInstance(@NotNull String instanceName, @NotNull MetadataStore store, @NotNull Namespace namespace) throws MDSException {
        if (instanceName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/MdsInstanceInitializer.getMDSInstance must not be null");
        }
        if (store == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/MdsInstanceInitializer.getMDSInstance must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/mds/MdsInstanceInitializer.getMDSInstance must not be null");
        }
        MDSConfig mdsConfig = MdsInstanceInitializer.createMDSConfig(store, namespace);
        return MDSInstance.getOrCreateInstance((String)instanceName, (MDSConfig)mdsConfig);
    }

    public static MDSInstance getCurrentMDSInstance() {
        return MDSInstance.getInstance((String)OBPM_MDS);
    }

    private static MDSInstance getMDSInstance(String instanceName, MDSConfig mdsConfig) throws MDSConfigurationException, InvalidNamespaceException {
        PConfig pConfig = mdsConfig.getPConfig();
        MetadataStore bpmMetadataStore = MdsInstanceInitializer.getBPMMetadataStore(pConfig);
        if (bpmMetadataStore != null) {
            mdsConfig = MdsInstanceInitializer.createMDSConfig(bpmMetadataStore, mdsConfig, Namespace.BPM);
        }
        return MDSInstance.getOrCreateInstance((String)instanceName, (MDSConfig)mdsConfig, (boolean)true);
    }

    private static MDSConfig createMDSConfig(@NotNull MetadataStore store, @NotNull Namespace namespace) throws MDSConfigurationException, InvalidNamespaceException {
        if (store == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/MdsInstanceInitializer.createMDSConfig must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/MdsInstanceInitializer.createMDSConfig must not be null");
        }
        PConfig pConfig = new PConfig(MdsInstanceInitializer.createNamespaceConfig(store, namespace), MdsInstanceInitializer.createContentConfig(namespace), false, Integer.valueOf(0), Integer.valueOf(0));
        return MdsInstanceInitializer.createMDSConfig(store, new MDSConfig(null, pConfig, null), namespace);
    }

    private static MDSConfig createMDSConfig(@NotNull MetadataStore store, @NotNull MDSConfig mdsConfig, @NotNull Namespace namespace) throws MDSConfigurationException, InvalidNamespaceException {
        if (store == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/MdsInstanceInitializer.createMDSConfig must not be null");
        }
        if (mdsConfig == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/MdsInstanceInitializer.createMDSConfig must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/mds/MdsInstanceInitializer.createMDSConfig must not be null");
        }
        MDSConfig result = mdsConfig;
        if (Namespace.BPM.equals((Object)namespace)) {
            ContentConfig contentConfig = MdsInstanceInitializer.createContentConfig(namespace);
            NamespaceConfig[] namespaceConfig = MdsInstanceInitializer.createNamespaceConfig(store, namespace);
            PConfig pConfig = mdsConfig.getPConfig();
            boolean readOnlyModeEnabled = pConfig.isReadOnlyModeEnabled();
            Integer autoPurgeTime = pConfig.getAutoPurgeTime();
            Integer pollingInterval = pConfig.getPollingInterval();
            PConfig newPConfig = new PConfig(namespaceConfig, contentConfig, readOnlyModeEnabled, autoPurgeTime, pollingInterval);
            CacheConfig cacheConfig = new CacheConfig(0);
            result = new MDSConfig(null, newPConfig, null, null, cacheConfig);
        }
        return result;
    }

    private static ContentConfig createContentConfig(@NotNull Namespace namespace) throws MDSConfigurationException {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/MdsInstanceInitializer.createContentConfig must not be null");
        }
        ContentOptionsMapping[] contentOptionsMap = Namespace.BPM.equals((Object)namespace) ? new ContentOptionsMapping[]{new ContentOptionsMapping(Namespace.BPM.getMdsNamespace().getPath() + "/", null, new ContentOptions(true))} : null;
        return new ContentConfig(contentOptionsMap);
    }

    private static NamespaceConfig[] createNamespaceConfig(@NotNull MetadataStore store, @NotNull Namespace namespace) {
        if (store == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/MdsInstanceInitializer.createNamespaceConfig must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/MdsInstanceInitializer.createNamespaceConfig must not be null");
        }
        return new NamespaceConfig[]{new NamespaceConfig(namespace.getMdsNamespace(), store)};
    }

    private static MetadataStore getBPMMetadataStore(@NotNull PConfig pConfig) {
        if (pConfig == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/MdsInstanceInitializer.getBPMMetadataStore must not be null");
        }
        List configs = pConfig.getNamespaceConfig();
        MetadataStore bpmMetadataStore = null;
        for (NamespaceConfig namespaceConfig : configs) {
            oracle.mds.naming.Namespace namespace = namespaceConfig.getNamespace();
            if (!namespace.equals((Object)Namespace.BPM.getMdsNamespace())) continue;
            bpmMetadataStore = namespaceConfig.getMetadataStore();
            break;
        }
        return bpmMetadataStore;
    }
}

