/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.impl;

import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.metadata.artifact.jaxb.MetadataType;
import oracle.bpm.metadata.artifact.jaxb.ProjectType;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.impl.MetadataArtifactHelper;
import oracle.bpm.metadata.msg.MetadataMsg;
import org.jetbrains.annotations.NotNull;

public final class Utils {
    public static void checkTimestamp(@NotNull MetadataType originalMetadata, @NotNull MetadataType localMetadata) throws MetadataException {
        if (originalMetadata == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/Utils.checkTimestamp must not be null");
        }
        if (localMetadata == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/Utils.checkTimestamp must not be null");
        }
        XMLGregorianCalendar originalTimestamp = originalMetadata.getUpdateTimestamp();
        XMLGregorianCalendar localTimestamp = localMetadata.getUpdateTimestamp();
        if (localTimestamp == null && originalTimestamp != null || originalTimestamp != null && !localTimestamp.equals(originalTimestamp)) {
            throw new MetadataException(MetadataMsg.PROJECT_VERSION_OUTDATED((String)originalMetadata.getName()));
        }
    }

    public static <T extends MdProject> String getAbsoluteLocation(@NotNull Class<T> type, @NotNull ProjectFolder location, @NotNull String projectName) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/Utils.getAbsoluteLocation must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/Utils.getAbsoluteLocation must not be null");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/impl/Utils.getAbsoluteLocation must not be null");
        }
        ProjectType projectType = MetadataArtifactHelper.getProjectType(type);
        String baseLocation = MetadataArtifactHelper.getRelativePathFrom(projectType);
        return VFileUtils.getCanonicalPath((String)(baseLocation + "/" + location.getLocation() + "/" + projectName));
    }
}

