/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.impl;

import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.mds.MdsFileSystem;
import oracle.bpm.metadata.MdDomain;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.exception.MetadataExceptionFactory;
import oracle.bpm.metadata.impl.Utils;
import oracle.bpm.metadata.persistence.MdPersistence;
import oracle.bpm.metadata.persistence.PersistenceException;
import oracle.bpm.project.model.Project;
import oracle.mds.core.MDSInstance;
import org.jetbrains.annotations.NotNull;

public final class PublicShareInfo {
    private String absoluteLocation;
    private boolean exists;
    private PublicShareProject loadedPublicShare;
    private final MdDomain mdDomain;
    private MdPersistence mdPersistence;
    private final MDSInstance mdsInstance;
    private boolean originallyLocked;
    private String projectId;
    private boolean sameFileSystem;
    private VFileSystem sourceFs;
    private VFileSystem targetFs;
    private final String userName;

    private PublicShareInfo(@NotNull MdDomain mdDomain, @NotNull MDSInstance mdsInstance, @NotNull ProjectFolder location, @NotNull PublicShareProject mdPublicShare, @NotNull MdPersistence mdPersistence, @NotNull String userName, boolean checkVersion) throws MetadataException {
        if (mdDomain == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/PublicShareInfo.<init> must not be null");
        }
        if (mdsInstance == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/PublicShareInfo.<init> must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/impl/PublicShareInfo.<init> must not be null");
        }
        if (mdPublicShare == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/metadata/impl/PublicShareInfo.<init> must not be null");
        }
        if (mdPersistence == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/metadata/impl/PublicShareInfo.<init> must not be null");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of oracle/bpm/metadata/impl/PublicShareInfo.<init> must not be null");
        }
        this.mdDomain = mdDomain;
        this.mdsInstance = mdsInstance;
        this.userName = userName;
        this.mdPersistence = mdPersistence;
        this.exists = false;
        this.originallyLocked = false;
        this.sameFileSystem = false;
        this.checkAndLockPublicShare(location, mdPublicShare, checkVersion);
    }

    public static PublicShareInfo checkAndLockPublicShare(@NotNull MdDomain mdDomain, @NotNull MDSInstance mdsInstance, @NotNull ProjectFolder location, @NotNull PublicShareProject mdPublicShare, @NotNull MdPersistence mdPersistence, @NotNull String userName, boolean checkVersion) throws MetadataException {
        if (mdDomain == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/PublicShareInfo.checkAndLockPublicShare must not be null");
        }
        if (mdsInstance == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/PublicShareInfo.checkAndLockPublicShare must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/impl/PublicShareInfo.checkAndLockPublicShare must not be null");
        }
        if (mdPublicShare == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/metadata/impl/PublicShareInfo.checkAndLockPublicShare must not be null");
        }
        if (mdPersistence == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/metadata/impl/PublicShareInfo.checkAndLockPublicShare must not be null");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of oracle/bpm/metadata/impl/PublicShareInfo.checkAndLockPublicShare must not be null");
        }
        return new PublicShareInfo(mdDomain, mdsInstance, location, mdPublicShare, mdPersistence, userName, checkVersion);
    }

    public boolean wasOriginallyLocked() {
        return this.originallyLocked;
    }

    public boolean sameFileSystem() {
        return this.sameFileSystem;
    }

    public String getAbsoluteLocation() {
        return this.absoluteLocation;
    }

    public VFileSystem getSourceFs() {
        return this.sourceFs;
    }

    public void setLoadedPublicShare(PublicShareProject loadedPublicShare) {
        this.loadedPublicShare = loadedPublicShare;
    }

    public PublicShareProject getLoadedPublicShare() {
        return this.loadedPublicShare;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public VFileSystem getTargetFs() {
        return this.targetFs;
    }

    public boolean exists() {
        return this.exists;
    }

    private void checkAndLockPublicShare(@NotNull ProjectFolder location, @NotNull PublicShareProject mdPublicShare, boolean checkVersion) throws MetadataException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/PublicShareInfo.checkAndLockPublicShare must not be null");
        }
        if (mdPublicShare == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/PublicShareInfo.checkAndLockPublicShare must not be null");
        }
        if (mdPublicShare.getProject() == null) {
            throw MetadataExceptionFactory.createInvalidProjectException();
        }
        if (this.userName.trim().length() == 0) {
            throw MetadataExceptionFactory.createOwnerNotSet();
        }
        Project sourceProject = mdPublicShare.getProject().get();
        if (sourceProject.getLoader() == null || sourceProject.getLoader().getProjectFileSystem() == null) {
            throw MetadataExceptionFactory.createInvalidProjectException();
        }
        this.sourceFs = sourceProject.getLoader().getProjectFileSystem().getDataFileSystem();
        String projectName = mdPublicShare.getName();
        ProjectFolder projectFolder = ProjectFolder.create(location, projectName);
        ProjectFolder foundProject = this.mdDomain.findProjectByName(PublicShareProject.class, projectName);
        this.projectId = projectFolder.getLocation();
        this.absoluteLocation = Utils.getAbsoluteLocation(PublicShareProject.class, location, mdPublicShare.getName());
        if (foundProject == null) {
            if (this.mdPersistence.existsFolder(PublicShareProject.class, projectFolder)) {
                throw MetadataExceptionFactory.createArtifactAlreadyExists((String)projectFolder.getLocation());
            }
            this.targetFs = new MdsFileSystem(this.mdsInstance, this.absoluteLocation);
        } else {
            this.exists = true;
            if (!foundProject.equals(projectFolder)) {
                throw PersistenceException.createArtifactLocationMismatchException(projectName);
            }
            this.loadedPublicShare = this.mdDomain.loadProject(PublicShareProject.class, projectFolder.getLocation(), false).get();
            Project loadedProject = this.loadedPublicShare.getProject().get();
            if (loadedProject.getLoader() == null || loadedProject.getLoader().getProjectFileSystem() == null) {
                throw MetadataExceptionFactory.createInvalidProjectException();
            }
            this.targetFs = loadedProject.getLoader().getProjectFileSystem().getDataFileSystem();
            this.sameFileSystem = this.targetFs.equals(this.sourceFs);
            if (!this.sameFileSystem && checkVersion) {
                Utils.checkTimestamp(this.loadedPublicShare.getMetadata(), mdPublicShare.getMetadata());
            }
            this.originallyLocked = this.loadedPublicShare.isLocked();
            this.mdDomain.getLock(this.loadedPublicShare, this.userName);
        }
        mdPublicShare.setOwner(this.userName);
    }
}

